/*
 * Decompiled with CFR 0.152.
 */
package staticStuff;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVG_Exporter
extends Graphics2D {
    private Node theNode;
    private Node parentNode;
    private Color currentColor = Color.BLACK;
    private int r;
    private int g;
    private int b;
    private Graphics2D graph;
    private boolean horizontal = true;

    public SVG_Exporter(Node parent) {
        this.theNode = parent;
        this.graph = new BufferedImage(2, 2, 6).createGraphics();
    }

    public void setNode(Node newNode) {
        this.theNode = newNode;
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.graph.addRenderingHints(hints);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        System.out.println("clearRect not implemented");
    }

    @Override
    public void clip(Shape s) {
        System.out.println("clip not implemented");
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        System.out.println("clipRect not implemented");
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.out.println("copyArea not implemented");
    }

    @Override
    public Graphics create() {
        System.out.println("create not implemented");
        return null;
    }

    @Override
    public void dispose() {
        this.graph.dispose();
    }

    @Override
    public void draw(Shape s) {
        System.out.println("draw shape not implemented");
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        System.out.println("drawArc not implemented");
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        System.out.println("drawGlyph not implemented");
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        System.out.println("drawImage 1 not implemented");
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        System.out.println("drawImage 2 not implemented");
    }

    @Override
    public boolean drawImage(Image img, int offsetX, int offsetY, ImageObserver observer) {
        BufferedImage bi = null;
        if (img instanceof BufferedImage) {
            bi = (BufferedImage)img;
            Node group = SVG_Exporter.addGroup(this.theNode);
            int emtpyPixel = 0;
            int whitePixel = -1;
            int width = bi.getWidth();
            for (int x = 0; x < width; ++x) {
                int height = bi.getHeight();
                for (int y = 0; y < height; ++y) {
                    int dot = bi.getRGB(x, y);
                    if (dot == whitePixel || dot == emtpyPixel) continue;
                    Color c = new Color(dot);
                    SVG_Exporter.addDot(group, offsetX + x, offsetY + y, c.getRed(), c.getGreen(), c.getBlue());
                }
            }
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        System.out.println("drawImage 4 not implemented");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        System.out.println("drawImage 5 not implemented");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        System.out.println("drawImage 6 not implemented");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        System.out.println("drawImage 7 not implemented");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        System.out.println("drawImage 8 not implemented");
        return false;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        SVG_Exporter.addLine(this.theNode, x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        System.out.println("drawOval not implemented");
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        SVG_Exporter.addPolygon(this.theNode, xPoints, yPoints, nPoints, false);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        System.out.println("drawPolyline not implemented");
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        System.out.println("drawRenderableImage 1 not implemented");
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        System.out.println("drawRenderableImage 2 not implemented");
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        System.out.println("drawRoundRect not implemented");
    }

    @Override
    public void drawString(String str, int x, int y) {
        SVG_Exporter.addText(this.theNode, x, y, this.graph.getFont().getSize2D(), this.horizontal, str);
    }

    @Override
    public void drawString(String str, float x, float y) {
        SVG_Exporter.addText(this.theNode, x, y, this.graph.getFont().getSize2D(), this.horizontal, str);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        System.out.println("drawString 3 not implemented");
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        System.out.println("drawString 4 not implemented");
    }

    @Override
    public void fill(Shape s) {
        System.out.println("fill not implemented");
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        System.out.println("fillArc not implemented");
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        System.out.println("fillOval not implemented");
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        SVG_Exporter.addPolygon(this.theNode, xPoints, yPoints, nPoints, true);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        SVG_Exporter.addRect(this.theNode, x, y, width, height, this.r, this.g, this.b);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        System.out.println("fillRoundRect not implemented");
    }

    @Override
    public Color getBackground() {
        return this.graph.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        this.graph.setBackground(color);
    }

    @Override
    public Shape getClip() {
        System.out.println("getClip not implemented");
        return null;
    }

    @Override
    public void setClip(Shape clip) {
        System.out.println("setClip not implemented");
    }

    @Override
    public Rectangle getClipBounds() {
        System.out.println("getClipBounds not implemented");
        return null;
    }

    @Override
    public Color getColor() {
        return this.currentColor;
    }

    @Override
    public void setColor(Color c) {
        this.currentColor = c;
        this.r = c.getRed();
        this.g = c.getGreen();
        this.b = c.getBlue();
    }

    @Override
    public Composite getComposite() {
        System.out.println("getComposite not implemented");
        return null;
    }

    @Override
    public void setComposite(Composite comp) {
        System.out.println("setComposite not implemented");
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graph.getDeviceConfiguration();
    }

    @Override
    public Font getFont() {
        return this.graph.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.graph.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.graph.getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.graph.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.graph.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        this.graph.setPaint(paint);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.graph.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.graph.getRenderingHints();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.graph.setRenderingHints(hints);
    }

    @Override
    public Stroke getStroke() {
        return this.graph.getStroke();
    }

    @Override
    public void setStroke(Stroke s) {
        this.graph.setStroke(s);
    }

    @Override
    public AffineTransform getTransform() {
        return this.graph.getTransform();
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.graph.setTransform(Tx);
        this.horizontal = true;
    }

    @Override
    public void setXORMode(Color c1) {
        this.graph.setXORMode(c1);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.graph.hit(rect, s, onStroke);
    }

    @Override
    public void rotate(double theta) {
        this.graph.rotate(theta);
        this.horizontal = false;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.graph.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.graph.scale(sx, sy);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.graph.setClip(x, y, width, height);
    }

    @Override
    public void setPaintMode() {
        this.graph.setPaint(this.currentColor);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graph.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public void shear(double shx, double shy) {
        this.graph.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        System.out.println("transform not implemented");
    }

    @Override
    public void translate(int x, int y) {
        System.out.println("translate 1 not implemented");
    }

    @Override
    public void translate(double tx, double ty) {
        System.out.println("translate 2 not implemented");
    }

    public void newSVG(float x, float y, float width, float height) {
        this.parentNode = this.theNode;
        Node newNode = SVG_Exporter.addSVG(this.parentNode, x, y, width, height);
        this.parentNode.appendChild(newNode);
        this.theNode = newNode;
    }

    public void returnToParentNode() {
        this.theNode = this.parentNode;
    }

    private static void addLine(Node parent, float start_x, float start_y, float end_x, float end_y) {
        Element newNode = parent.getOwnerDocument().createElement("line");
        newNode.setAttribute("x1", String.valueOf(start_x));
        newNode.setAttribute("y1", String.valueOf(start_y));
        newNode.setAttribute("x2", String.valueOf(end_x));
        newNode.setAttribute("y2", String.valueOf(end_y));
        newNode.setAttribute("stroke", "black");
        parent.appendChild(newNode);
    }

    private static void addPolygon(Node parent, int[] x, int[] y, int n, boolean fill) {
        Element newNode = parent.getOwnerDocument().createElement("polygon");
        if (!fill) {
            newNode.setAttribute("fill", "none");
        }
        newNode.setAttribute("stroke", "black");
        StringBuilder points = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            points.append(x[i]);
            points.append(",");
            points.append(y[i]);
            points.append(",");
        }
        points.append(x[0]);
        points.append(",");
        points.append(y[0]);
        newNode.setAttribute("points", points.toString());
        parent.appendChild(newNode);
    }

    private static void addDot(Node parent, float start_x, float start_y, int color_r, int color_g, int color_b) {
        SVG_Exporter.addRect(parent, start_x, start_y, 1.0f, 1.0f, color_r, color_g, color_b);
    }

    private static void addDot(Node parent, float start_x, float start_y) {
        SVG_Exporter.addRect(parent, start_x, start_y, 1.0f, 1.0f, 0, 0, 0);
    }

    private static void addRect(Node parent, float start_x, float start_y, float width, float height, int color_r, int color_g, int color_b) {
        Element newNode = parent.getOwnerDocument().createElement("rect");
        newNode.setAttribute("x", String.valueOf(start_x));
        newNode.setAttribute("y", String.valueOf(start_y));
        newNode.setAttribute("width", String.valueOf(width));
        newNode.setAttribute("height", String.valueOf(height));
        newNode.setAttribute("fill", "rgb(" + color_r + "," + color_g + "," + color_b + ")");
        parent.appendChild(newNode);
    }

    public static void addText(Node parent, float start_x, float start_y, float fontSize, boolean horizontal, String text) {
        Element newNode = parent.getOwnerDocument().createElement("text");
        newNode.setAttribute("font-family", "sans-serif");
        newNode.setAttribute("font-size", String.valueOf(fontSize));
        newNode.setAttribute("fill", "rgb(0,0,0)");
        if (!horizontal) {
            float y_temp = -start_x;
            start_x = start_y;
            start_y = y_temp;
            newNode.setAttribute("transform", "rotate(-90," + String.valueOf(start_x) + "," + String.valueOf(start_y) + ")");
        }
        newNode.setAttribute("x", String.valueOf(start_x));
        newNode.setAttribute("y", String.valueOf(start_y));
        newNode.setTextContent(text);
        parent.appendChild(newNode);
    }

    private static Node addGroup(Node parent) {
        Element newNode = parent.getOwnerDocument().createElement("g");
        parent.appendChild(newNode);
        return newNode;
    }

    public static Node addSVG(Node parent, float start_x, float start_y, float width, float height) {
        Element newNode = parent.getOwnerDocument().createElement("svg");
        newNode.setAttribute("x", String.valueOf(start_x));
        newNode.setAttribute("y", String.valueOf(start_y));
        newNode.setAttribute("width", String.valueOf(width));
        newNode.setAttribute("height", String.valueOf(height));
        parent.appendChild(newNode);
        return newNode;
    }

    public static Node addSVG(Document XML_doc, int width, int height) {
        Element rootNode = XML_doc.createElement("svg");
        rootNode.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        rootNode.setAttribute("width", String.valueOf(width));
        rootNode.setAttribute("height", String.valueOf(height));
        return rootNode;
    }

    public static void addTable(Node parent, float x, float y, float width, float height, String[][] text, float fontSize) {
        Element newNode = parent.getOwnerDocument().createElement("g");
        parent.appendChild(newNode);
        float rowHeight = height / (float)text.length;
        float y_adjust = rowHeight / 2.0f + fontSize / 4.0f;
        float colWidth = width / (float)text[0].length;
        for (int i = 0; i <= text.length; ++i) {
            int currentY = (int)(y + (float)i * rowHeight);
            SVG_Exporter.addLine(newNode, x, currentY, x + width, currentY);
            for (int j = 0; j <= text[0].length; ++j) {
                int currentX = (int)(x + (float)j * colWidth);
                SVG_Exporter.addLine(newNode, currentX, y, currentX, y + height);
                if (i >= text.length || j >= text[0].length) continue;
                SVG_Exporter.addText(newNode, currentX + 2, (float)currentY + y_adjust, fontSize, true, text[i][j]);
            }
        }
    }
}

