/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.formatter;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sciplore.formatter.Bean;
import org.sciplore.formatter.SimpleTypeElementBean;

public class BeanConverter
extends JavaBeanConverter {
    public BeanConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Bean bean = (Bean)object;
        Map<String, Method> methods = this.getGetterMethods(object);
        for (String activeElements : bean.getActiveElements()) {
            try {
                Object value;
                Method method = methods.get(activeElements.toLowerCase());
                if (method == null) continue;
                if (method.getReturnType() == String.class) {
                    value = method.invoke(object, new Object[0]);
                    if (activeElements.equalsIgnoreCase("value") && object instanceof SimpleTypeElementBean) {
                        if (value == null) continue;
                        writer.setValue(value.toString());
                        continue;
                    }
                    if (value == null) {
                        writer.addAttribute(activeElements.toLowerCase(), "");
                        continue;
                    }
                    writer.addAttribute(activeElements.toLowerCase(), value.toString());
                    continue;
                }
                if (this.canConvert(method.getReturnType())) {
                    value = method.invoke(object, new Object[0]);
                    if (value == null) {
                        writer.startNode(activeElements.toLowerCase());
                        writer.endNode();
                        continue;
                    }
                    writer.startNode(activeElements.toLowerCase());
                    this.marshal(value, writer, context);
                    writer.endNode();
                    continue;
                }
                if (!this.contains(method.getReturnType().getInterfaces(), "java.util.Collection") || (value = method.invoke(object, new Object[0])) == null) continue;
                Collection values = (Collection)value;
                for (Object element : values) {
                    writer.startNode(element.getClass().getSimpleName().toLowerCase());
                    this.marshal(element, writer, context);
                    writer.endNode();
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, Method> getGetterMethods(Object object) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        Class<?> clazz = object.getClass();
        while (clazz != null && clazz != Object.class && clazz != Bean.class) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().startsWith("get")) {
                    String name = m.getName().toLowerCase().substring(3);
                    result.put(name, m);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private boolean contains(Class<?>[] classes, String s) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.getName().equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader arg0, UnmarshallingContext arg1) {
        return null;
    }

    @Override
    public boolean canConvert(Class clazz) {
        while (clazz != null && clazz != Object.class) {
            if (clazz == Bean.class) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

