/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity;

import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.wizard.integrity.IntegrityMessage;

public class IntegrityCheck {
    private Vector<IntegrityMessage> messages = new Vector();

    public Vector<IntegrityMessage> checkBibtexDatabase(BibtexDatabase base) {
        this.messages.clear();
        if (base != null) {
            for (BibtexEntry entry : base.getEntries()) {
                this.checkSingleEntry(entry);
            }
        }
        return new Vector<IntegrityMessage>(this.messages);
    }

    public Vector<IntegrityMessage> checkBibtexEntry(BibtexEntry entry) {
        this.messages.clear();
        this.checkSingleEntry(entry);
        return new Vector<IntegrityMessage>(this.messages);
    }

    public void checkSingleEntry(BibtexEntry entry) {
        if (entry == null) {
            return;
        }
        String data = entry.getField("author");
        if (data != null) {
            this.authorNameCheck(data.toString(), "author", entry);
        }
        if ((data = entry.getField("editor")) != null) {
            this.authorNameCheck(data.toString(), "editor", entry);
        }
        if ((data = entry.getField("title")) != null) {
            this.titleCheck(data.toString(), "title", entry);
        }
        if ((data = entry.getField("year")) != null) {
            this.yearCheck(data.toString(), "year", entry);
        }
    }

    private void authorNameCheck(String names, String fieldName, BibtexEntry entry) {
        StringBuffer structure = new StringBuffer();
        int len = names.length();
        int mode = -1;
        block7: for (int t = 0; t < len; ++t) {
            char ch = names.charAt(t);
            switch (ch) {
                case ',': {
                    if (mode == 5) {
                        structure.append('a');
                    } else {
                        structure.append('N');
                    }
                    structure.append(',');
                    mode = 0;
                    continue block7;
                }
                case ' ': {
                    if (mode == 5) {
                        structure.append('a');
                    } else if (mode != 0) {
                        structure.append('N');
                    }
                    mode = -1;
                    continue block7;
                }
                case 'a': {
                    if (mode != -1) continue block7;
                    mode = 2;
                    continue block7;
                }
                case 'n': {
                    if (mode != 2) continue block7;
                    mode = 3;
                    continue block7;
                }
                case 'd': {
                    if (mode != 3) continue block7;
                    mode = 5;
                    continue block7;
                }
                default: {
                    mode = 1;
                }
            }
        }
        if (mode == 5) {
            structure.append('a');
        } else if (mode != 0) {
            structure.append('N');
        }
        len = structure.length();
        if (len > 0) {
            if (structure.charAt(0) != 'N') {
                this.messages.add(new IntegrityMessage(1010, entry, fieldName, null));
            }
            if (structure.charAt(structure.length() - 1) != 'N') {
                this.messages.add(new IntegrityMessage(1011, entry, fieldName, null));
            }
        }
    }

    private void titleCheck(String title, String fieldName, BibtexEntry entry) {
        int len = title.length();
        int mode = 0;
        int upLowCounter = 0;
        block5: for (int t = 0; t < len; ++t) {
            char ch = title.charAt(t);
            switch (ch) {
                case '}': {
                    if (mode == 0) {
                        this.messages.add(new IntegrityMessage(2010, entry, fieldName, null));
                        continue block5;
                    }
                    --mode;
                    continue block5;
                }
                case '{': {
                    ++mode;
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                default: {
                    if (mode != 0 || !Character.isUpperCase(ch) || t <= 1) continue block5;
                    ++upLowCounter;
                }
            }
        }
        if (upLowCounter > 0) {
            // empty if block
        }
    }

    private void yearCheck(String number, String fieldName, BibtexEntry entry) {
        int len = number.length();
        int digitCounter = 0;
        boolean fourDigitsBlock = false;
        boolean containsFourDigits = false;
        for (int t = 0; t < len; ++t) {
            char ch = number.charAt(t);
            if (Character.isDigit(ch)) {
                if (++digitCounter == 4) {
                    fourDigitsBlock = true;
                    continue;
                }
                fourDigitsBlock = false;
                continue;
            }
            if (fourDigitsBlock) {
                containsFourDigits = true;
            }
            digitCounter = 0;
        }
        if (!containsFourDigits && !fourDigitsBlock) {
            this.messages.add(new IntegrityMessage(11, entry, fieldName, null));
        }
    }
}

