/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.jabref.Util;

public class Pair<P, V> {
    public P p;
    public V v;

    public Pair(P p, V v) {
        this.p = p;
        this.v = v;
    }

    public static <P extends Comparable<P>, V> Comparator<Pair<P, V>> pCompare() {
        return new Comparator<Pair<P, V>>(){

            @Override
            public int compare(Pair<P, V> arg0, Pair<P, V> arg1) {
                return ((Comparable)arg0.p).compareTo(arg1.p);
            }
        };
    }

    public static <P> Comparator<? super Pair<P, ?>> pCompare(final Comparator<P> comp) {
        return new Comparator<Pair<P, ?>>(){

            @Override
            public int compare(Pair<P, ?> arg0, Pair<P, ?> arg1) {
                return comp.compare(arg0.p, arg1.p);
            }
        };
    }

    public Pair<V, P> flip() {
        return new Pair<V, P>(this.v, this.p);
    }

    public static <P, V> List<Pair<V, P>> flipList(List<Pair<P, V>> list) {
        LinkedList<Pair<V, P>> result = new LinkedList<Pair<V, P>>();
        for (Pair<P, V> pair : list) {
            result.add(pair.flip());
        }
        return result;
    }

    public static <P extends Comparable<P>, V> List<Pair<P, Set<V>>> disjointPartition(List<Pair<P, V>> list) {
        LinkedList<Pair<P, Set<V>>> result = new LinkedList<Pair<P, Set<V>>>();
        Comparator<Pair<P, V>> c = Pair.pCompare();
        Collections.sort(list, Collections.reverseOrder(c));
        Iterator<Pair<P, V>> i = list.iterator();
        if (i.hasNext()) {
            Pair<P, V> first = i.next();
            Comparable last = (Comparable)first.p;
            HashSet<V> vs = new HashSet<V>();
            vs.add(first.v);
            while (i.hasNext()) {
                Pair<P, V> next = i.next();
                if (last.compareTo(next.p) == 0) {
                    vs.add(next.v);
                    continue;
                }
                result.add(new Pair(last, vs));
                vs = new HashSet();
                last = (Comparable)next.p;
                vs.add(next.v);
            }
            result.add(new Pair(last, vs));
        }
        return result;
    }

    public static <V extends Comparable<V>> Comparator<? super Pair<?, V>> vCompare() {
        return new Comparator<Pair<?, V>>(){

            @Override
            public int compare(Pair<?, V> arg0, Pair<?, V> arg1) {
                return ((Comparable)arg0.v).compareTo(arg1.v);
            }
        };
    }

    public static <V> Comparator<? super Pair<?, V>> vCompare(final Comparator<V> vComp) {
        return new Comparator<Pair<?, V>>(){

            @Override
            public int compare(Pair<?, V> arg0, Pair<?, V> arg1) {
                return vComp.compare(arg0.v, arg1.v);
            }
        };
    }

    public static <P, V> List<Pair<P, V>> zip(List<P> ps, List<V> vs) {
        LinkedList<Pair<P, V>> result = new LinkedList<Pair<P, V>>();
        Iterator<P> pI = ps.iterator();
        Iterator<V> vI = vs.iterator();
        while (pI.hasNext()) {
            V nextV = vI.hasNext() ? (V)vI.next() : null;
            result.add(new Pair<P, Object>(pI.next(), nextV));
        }
        while (vI.hasNext()) {
            result.add(new Pair<Object, V>(null, vI.next()));
        }
        return result;
    }

    public static <P> List<P> pList(List<? extends Pair<P, ?>> list) {
        LinkedList<P> result = new LinkedList<P>();
        for (Pair<P, ?> pair : list) {
            result.add(pair.p);
        }
        return result;
    }

    public static <V> List<V> vList(List<? extends Pair<?, V>> list) {
        LinkedList<V> result = new LinkedList<V>();
        for (Pair<?, V> pair : list) {
            result.add(pair.v);
        }
        return result;
    }

    public static <V> Iterator<V> iteratorV(final Iterator<? extends Pair<?, V>> iterator) {
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                return ((Pair)iterator.next()).v;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <V> Iterable<V> iterableV(final Iterable<? extends Pair<?, V>> iterable) {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Pair.iteratorV(iterable.iterator());
            }
        };
    }

    public static <P> Iterator<P> iteratorP(final Iterator<? extends Pair<P, ?>> iterator) {
        return new Iterator<P>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public P next() {
                return ((Pair)iterator.next()).p;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <P> Iterable<P> iterableP(final Iterable<? extends Pair<P, ?>> iterable) {
        return new Iterable<P>(){

            @Override
            public Iterator<P> iterator() {
                return Pair.iteratorP(iterable.iterator());
            }
        };
    }

    public String toString() {
        return new StringBuffer().append('<').append(this.p).append(',').append(this.v).append('>').toString();
    }

    public int hashCode() {
        return (this.p == null ? 0 : this.p.hashCode()) | (this.v == null ? 0 : this.v.hashCode());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return Util.equals(this.p, other.p) && Util.equals(this.v, other.v);
    }
}

