/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.plugin;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.plugin.PluginCore;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;

public class PluginInstaller {
    public static final String PLUGIN_XML_FILE = "plugin.xml";
    public static final int SUCCESS = 0;
    public static final int UNABLE_TO_CREATE_DIR = 1;
    public static final int UNABLE_TO_COPY_FILE = 2;
    public static final int NO_VERSIONS_INSTALLED = 0;
    public static final int NEWER_VERSION_INSTALLED = 1;
    public static final int SAME_VERSION_INSTALLED = 2;
    public static final int OLDER_VERSION_INSTALLED = 3;
    public static final int UNCONVENTIONAL_FILENAME = 4;
    public static final int UNKNOWN_VERSION = 5;
    public static final int NOT_LOADED = 0;
    public static final int LOADED = 1;
    public static final int BAD = 2;
    static Pattern pluginFilePattern = Pattern.compile("(.*)-([\\d\\.]+).jar");
    static Pattern pluginFilePatternNoVersion = Pattern.compile("(.*).jar");

    public static void installPlugin(JabRefFrame frame, File file, String targetFileName) {
        boolean created;
        String fileName;
        String string = fileName = targetFileName != null ? targetFileName : file.getName();
        if (!PluginCore.userPluginDir.exists() && !(created = PluginCore.userPluginDir.mkdirs())) {
            JOptionPane.showMessageDialog(frame, Globals.lang("Unable to create plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").", Globals.lang("Plugin installer"), 0);
            return;
        }
        int status = PluginInstaller.checkInstalledVersion(file);
        switch (status) {
            case 0: {
                int result = PluginInstaller.copyPlugin((JFrame)frame, file, fileName);
                if (result == 0) {
                    JOptionPane.showMessageDialog(frame, Globals.lang("Plugin installed successfully. You must restart JabRef to load the new plugin."), Globals.lang("Plugin installer"), 1);
                    break;
                }
                String reason = result == 2 ? Globals.lang("Unable to copy file") : Globals.lang("Unable to create user plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").";
                JOptionPane.showMessageDialog(frame, Globals.lang("Plugin installation failed.") + " " + reason, Globals.lang("Plugin installer"), 0);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(frame, Globals.lang("The same version of this plugin is already installed."), Globals.lang("Plugin installer"), 1);
                break;
            }
            case 1: {
                JOptionPane.showMessageDialog(frame, Globals.lang("A newer version of this plugin is already installed."), Globals.lang("Plugin installer"), 1);
                break;
            }
            case 3: {
                int result = PluginInstaller.copyPlugin((JFrame)frame, file, fileName);
                if (result == 0) {
                    int answer = JOptionPane.showConfirmDialog(frame, Globals.lang("One or more older versions of this plugin is installed. Delete old versions?"), Globals.lang("Plugin installer"), 0);
                    if (answer != 0) break;
                    boolean success = PluginInstaller.deleteOlderVersions(file);
                    if (success) {
                        JOptionPane.showMessageDialog(frame, Globals.lang("Old versions deleted successfully."), Globals.lang("Plugin installer"), 1);
                        break;
                    }
                    JOptionPane.showMessageDialog(frame, Globals.lang("Old plugin versions will be deleted next time JabRef starts up."), Globals.lang("Plugin installer"), 1);
                    break;
                }
                String reason = result == 2 ? Globals.lang("Unable to copy file") : Globals.lang("Unable to create user plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").";
                JOptionPane.showMessageDialog(frame, Globals.lang("Plugin installation failed.") + " " + reason, Globals.lang("Plugin installer"), 0);
                break;
            }
            case 5: {
                JLabel lab = new JLabel("<html>" + Globals.lang("Unable to determine plugin name and version. This may not be a valid JabRef plugin.") + "<br>" + Globals.lang("Install anyway?") + "</html>");
                int answer = JOptionPane.showConfirmDialog(frame, lab, Globals.lang("Plugin installer"), 0);
                if (answer != 0) break;
                int result = PluginInstaller.copyPlugin((JFrame)frame, file, fileName);
                if (result == 0) {
                    JOptionPane.showMessageDialog(frame, Globals.lang("Plugin installed successfully. You must restart JabRef to load the new plugin."), Globals.lang("Plugin installer"), 1);
                    break;
                }
                String reason = result == 2 ? Globals.lang("Unable to copy file") : Globals.lang("Unable to create user plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").";
                JOptionPane.showMessageDialog(frame, Globals.lang("Plugin installation failed.") + " " + reason, Globals.lang("Plugin installer"), 0);
            }
        }
    }

    public static int checkInstalledVersion(File f) {
        boolean hasNewer;
        String[] nav = PluginInstaller.getNameAndVersion(f);
        if (nav == null) {
            return 5;
        }
        VersionNumber vn = new VersionNumber(nav[1]);
        Map<VersionNumber, File> versions = PluginInstaller.getInstalledVersions(nav[0]);
        if (versions.size() == 0) {
            return 0;
        }
        VersionNumber thenum = versions.keySet().iterator().next();
        boolean hasSame = vn.compareTo(thenum) == 0;
        boolean bl = hasNewer = vn.compareTo(thenum) > 0;
        if (hasNewer) {
            return 1;
        }
        if (hasSame) {
            return 2;
        }
        return 3;
    }

    public static boolean deletePlugin(NameAndVersion plugin) {
        return PluginInstaller.deletePluginFile(plugin.file);
    }

    public static boolean deleteOlderVersions(File f) {
        String[] nav = PluginInstaller.getNameAndVersion(f);
        if (nav == null) {
            return false;
        }
        boolean success = true;
        VersionNumber num = new VersionNumber(nav[1]);
        Map<VersionNumber, File> versions = PluginInstaller.getInstalledVersions(nav[0]);
        for (VersionNumber versionNumber : versions.keySet()) {
            if (num.compareTo(versionNumber) >= 0) continue;
            String vnString = versionNumber.equals(VersionNumber.ZERO) ? null : versionNumber.toString();
            File file = versions.get(versionNumber);
            success = PluginInstaller.deletePluginFile(file);
        }
        return success;
    }

    public static boolean deletePluginFile(File f) {
        boolean success = f.delete();
        if (success) {
            return true;
        }
        PluginInstaller.schedulePluginForDeletion(f.getPath());
        return false;
    }

    public static int copyPlugin(JFrame frame, URL source, String destFileName) {
        boolean created;
        if (destFileName == null) {
            destFileName = source.getFile();
        }
        if (!PluginCore.userPluginDir.exists() && !(created = PluginCore.userPluginDir.mkdirs())) {
            return 1;
        }
        File destFile = new File(PluginCore.userPluginDir, destFileName);
        URLDownload ud = new URLDownload(frame, source, destFile);
        try {
            ud.download();
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyPlugin(JFrame frame, File source, String destFileName) {
        boolean created;
        if (destFileName == null) {
            destFileName = source.getName();
        }
        if (!PluginCore.userPluginDir.exists() && !(created = PluginCore.userPluginDir.mkdirs())) {
            return 1;
        }
        File destFile = new File(PluginCore.userPluginDir, destFileName);
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int count;
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] buf = new byte[1024];
            while ((count = in.read(buf, 0, buf.length)) > 0) {
                ((BufferedOutputStream)out).write(buf, 0, count);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            int n = 2;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    return 2;
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public static Map<VersionNumber, File> getInstalledVersions(String pluginName) {
        String[] files = PluginCore.userPluginDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith(".jar");
            }
        });
        TreeMap<VersionNumber, File> versions = new TreeMap<VersionNumber, File>();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            File f = new File(PluginCore.userPluginDir, file);
            String[] nav = PluginInstaller.getNameAndVersion(f);
            if (nav == null || !nav[0].equals(pluginName)) continue;
            VersionNumber vn = new VersionNumber(nav[1]);
            versions.put(vn, f);
        }
        return versions;
    }

    public static void schedulePluginForDeletion(String filename) {
        String[] newValues;
        String[] oldValues = Globals.prefs.getStringArray("deletePlugins");
        String[] stringArray = newValues = oldValues == null ? new String[1] : new String[oldValues.length + 1];
        if (oldValues != null) {
            for (int i = 0; i < oldValues.length; ++i) {
                newValues[i] = oldValues[i];
            }
        }
        newValues[newValues.length - 1] = filename;
        Globals.prefs.putStringArray("deletePlugins", newValues);
    }

    public static void deletePluginsOnStartup(String[] filenames) {
        for (int i = 0; i < filenames.length; ++i) {
            String s = filenames[i];
            File f = new File(s);
            if (f.getParentFile().equals(PluginCore.userPluginDir)) {
                boolean success = f.delete();
                continue;
            }
            System.out.println("File outside of user plugin dir: " + s);
        }
    }

    public static String[] getNameAndVersion(File f) {
        try {
            File temp = PluginInstaller.unpackPluginXML(f);
            if (temp == null) {
                return null;
            }
            ManifestInfo mi = PluginCore.getManager().getRegistry().readManifestInfo(temp.toURI().toURL());
            temp.delete();
            return new String[]{mi.getId(), mi.getVersion().toString()};
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (ManifestProcessingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unpackPluginXML(File f) {
        InputStream in = null;
        OutputStream out = null;
        try {
            int nBytes;
            JarFile jar = new JarFile(f);
            ZipEntry entry = jar.getEntry(PLUGIN_XML_FILE);
            if (entry == null) {
                File file = null;
                return file;
            }
            File dest = File.createTempFile("jabref_plugin", ".xml");
            dest.deleteOnExit();
            in = new BufferedInputStream(jar.getInputStream(entry));
            out = new BufferedOutputStream(new FileOutputStream(dest));
            byte[] buffer = new byte[2048];
            while ((nBytes = in.read(buffer)) > 0) {
                out.write(buffer, 0, nBytes);
            }
            out.flush();
            File file = dest;
            return file;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public static EventList<NameAndVersion> findInstalledPlugins() {
        NameAndVersion nameAndVersion;
        BasicEventList<NameAndVersion> plugins = new BasicEventList<NameAndVersion>();
        if (!PluginCore.userPluginDir.exists()) {
            return plugins;
        }
        String[] files = PluginCore.userPluginDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        HashMap<String, PluginDescriptor> urls = new HashMap<String, PluginDescriptor>();
        Collection<PluginDescriptor> descriptors = PluginCore.getManager().getRegistry().getPluginDescriptors();
        for (PluginDescriptor desc : descriptors) {
            if (desc.getPluginClassName() != null && desc.getPluginClassName().equals("net.sf.jabref.plugin.core.JabRefPlugin")) continue;
            urls.put(desc.getId(), desc);
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(PluginCore.userPluginDir, files[i]);
            String[] nav = PluginInstaller.getNameAndVersion(file);
            if (nav == null) continue;
            VersionNumber vn = nav[1] != null ? new VersionNumber(nav[1]) : null;
            nameAndVersion = new NameAndVersion(nav[0], vn, true, file);
            Iterator it = urls.keySet().iterator();
            while (it.hasNext()) {
                String loc = (String)it.next();
                if (loc.indexOf(nav[0]) < 0) continue;
                PluginDescriptor desc = (PluginDescriptor)urls.get(loc);
                if (!PluginCore.getManager().isPluginEnabled((PluginDescriptor)urls.get(loc))) {
                    nameAndVersion.setStatus(2);
                } else {
                    nameAndVersion.setStatus(1);
                }
                it.remove();
            }
            plugins.add(nameAndVersion);
        }
        for (String url : urls.keySet()) {
            PluginDescriptor desc = (PluginDescriptor)urls.get(url);
            File location = new File(desc.getLocation().getFile());
            if (location.getPath().indexOf(PluginCore.userPluginDir.getPath()) >= 0) continue;
            nameAndVersion = new NameAndVersion(desc.getId(), new VersionNumber(desc.getVersion().toString()), false, location);
            if (!PluginCore.getManager().isPluginEnabled((PluginDescriptor)urls.get(url))) {
                nameAndVersion.setStatus(2);
            } else {
                nameAndVersion.setStatus(1);
            }
            plugins.add(nameAndVersion);
        }
        return plugins;
    }

    static class VersionNumber
    implements Comparable {
        public static final VersionNumber ZERO = new VersionNumber("0");
        List<Integer> digits = new ArrayList<Integer>();

        public VersionNumber(String number) {
            String[] elms = number.split("\\.");
            for (int i = 0; i < elms.length; ++i) {
                try {
                    int num = Integer.parseInt(elms[i]);
                    this.digits.add(num);
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }

        public int compareTo(Object o) {
            VersionNumber oth = (VersionNumber)o;
            for (int i = 0; i < Math.min(this.digits.size(), oth.digits.size()); ++i) {
                if (this.digits.get(i) == oth.digits.get(i)) continue;
                return oth.digits.get(i) - this.digits.get(i);
            }
            return oth.digits.size() - this.digits.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<Integer> integerIterator = this.digits.iterator();
            while (integerIterator.hasNext()) {
                sb.append(integerIterator.next());
                if (!integerIterator.hasNext()) continue;
                sb.append(".");
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }
    }

    public static class NameAndVersion
    implements Comparable {
        String name;
        VersionNumber version;
        int status = 0;
        boolean inUserDirectory;
        File file;

        public NameAndVersion(String name, VersionNumber version, boolean inUserDirectory, File file) {
            this.name = name;
            this.version = version;
            this.inUserDirectory = inUserDirectory;
            this.file = file;
        }

        public int compareTo(Object o) {
            NameAndVersion oth = (NameAndVersion)o;
            if (!this.name.equals(oth.name)) {
                return this.name.compareTo(oth.name);
            }
            if (this.version == null) {
                return 1;
            }
            if (oth.version == null) {
                return -1;
            }
            return this.version.compareTo(oth.version);
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }
}

