/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.Globals;

public class AutoDetectPaths
extends AbstractWorker {
    boolean foundPaths = false;
    boolean fileSearchCancelled = false;
    JDialog prog;
    private JDialog parent;

    public AutoDetectPaths(JDialog parent) {
        this.parent = parent;
    }

    public boolean runAutodetection() {
        try {
            if (AutoDetectPaths.checkAutoDetectedPaths()) {
                return true;
            }
            this.init();
            this.getWorker().run();
            this.update();
            return this.foundPaths;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void run() {
        this.foundPaths = this.autoDetectPaths();
    }

    public boolean getResult() {
        return this.foundPaths;
    }

    public boolean cancelled() {
        return this.fileSearchCancelled;
    }

    @Override
    public void init() throws Throwable {
        this.prog = this.showProgressDialog(this.parent, Globals.lang("Autodetecting paths..."), Globals.lang("Please wait..."), true);
    }

    @Override
    public void update() {
        this.prog.dispose();
    }

    public boolean autoDetectPaths() {
        if (Globals.ON_WIN) {
            File dir;
            List<File> progFiles = AutoDetectPaths.findProgramFilesDir();
            File sOffice = null;
            if (this.fileSearchCancelled) {
                return false;
            }
            Iterator<File> i$ = progFiles.iterator();
            while (i$.hasNext() && (sOffice = this.findFileDir(dir = i$.next(), "soffice.exe")) == null) {
            }
            if (sOffice == null) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("Unable to autodetect OpenOffice installation. Please choose the installation directory manually."), Globals.lang("Could not find OpenOffice installation"), 1);
                JFileChooser jfc = new JFileChooser(new File("C:\\"));
                jfc.setDialogType(0);
                jfc.setFileFilter(new javax.swing.filechooser.FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Globals.lang("Directories");
                    }
                });
                jfc.setFileSelectionMode(1);
                jfc.showOpenDialog(this.parent);
                if (jfc.getSelectedFile() != null) {
                    sOffice = jfc.getSelectedFile();
                }
            }
            if (sOffice == null) {
                return false;
            }
            Globals.prefs.put("ooExecutablePath", new File(sOffice, "soffice.exe").getPath());
            File unoil = this.findFileDir(sOffice.getParentFile(), "unoil.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            File jurt = this.findFileDir(sOffice.getParentFile(), "jurt.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            if (unoil != null && jurt != null) {
                Globals.prefs.put("ooUnoilPath", unoil.getPath());
                Globals.prefs.put("ooJurtPath", jurt.getPath());
                return true;
            }
            return false;
        }
        if (Globals.ON_MAC) {
            File rootDir = new File("/Applications");
            File[] files = rootDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isDirectory() || !file.getName().equals("OpenOffice.org.app")) continue;
                rootDir = file;
                break;
            }
            File sOffice = this.findFileDir(rootDir, "soffice.bin");
            if (this.fileSearchCancelled) {
                return false;
            }
            if (sOffice != null) {
                Globals.prefs.put("ooExecutablePath", new File(sOffice, "soffice.bin").getPath());
                File unoil = this.findFileDir(rootDir, "unoil.jar");
                if (this.fileSearchCancelled) {
                    return false;
                }
                File jurt = this.findFileDir(rootDir, "jurt.jar");
                if (this.fileSearchCancelled) {
                    return false;
                }
                if (unoil != null && jurt != null) {
                    Globals.prefs.put("ooUnoilPath", unoil.getPath());
                    Globals.prefs.put("ooJurtPath", jurt.getPath());
                    return true;
                }
                return false;
            }
            return false;
        }
        String usrRoot = "/usr/lib";
        File inUsr = this.findFileDir(new File("/usr/lib"), "soffice");
        if (this.fileSearchCancelled) {
            return false;
        }
        if (inUsr == null && (inUsr = this.findFileDir(new File("/usr/lib64"), "soffice")) != null) {
            usrRoot = "/usr/lib64";
        }
        if (this.fileSearchCancelled) {
            return false;
        }
        File inOpt = this.findFileDir(new File("/opt"), "soffice");
        if (this.fileSearchCancelled) {
            return false;
        }
        if (inUsr != null && inOpt == null) {
            Globals.prefs.put("ooExecutablePath", new File(inUsr, "soffice.bin").getPath());
            File unoil = this.findFileDir(new File(usrRoot), "unoil.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            File jurt = this.findFileDir(new File(usrRoot), "jurt.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            if (unoil != null && jurt != null) {
                Globals.prefs.put("ooUnoilPath", unoil.getPath());
                Globals.prefs.put("ooJurtPath", jurt.getPath());
                return true;
            }
            return false;
        }
        if (inOpt != null && inUsr == null) {
            Globals.prefs.put("ooExecutablePath", new File(inOpt, "soffice.bin").getPath());
            File unoil = this.findFileDir(new File("/opt"), "unoil.jar");
            File jurt = this.findFileDir(new File("/opt"), "jurt.jar");
            if (unoil != null && jurt != null) {
                Globals.prefs.put("ooUnoilPath", unoil.getPath());
                Globals.prefs.put("ooJurtPath", jurt.getPath());
                return true;
            }
            return false;
        }
        if (inOpt != null) {
            JRadioButton optRB = new JRadioButton(inOpt.getPath(), true);
            JRadioButton usrRB = new JRadioButton(inUsr.getPath(), false);
            ButtonGroup bg = new ButtonGroup();
            bg.add(optRB);
            bg.add(usrRB);
            DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref", ""));
            b.append(Globals.lang("Found more than one OpenOffice executable. Please choose which one to connect to:"));
            b.append(optRB);
            b.append(usrRB);
            int answer = JOptionPane.showConfirmDialog(null, b.getPanel(), Globals.lang("Choose OpenOffice executable"), 2);
            if (answer == 2) {
                return false;
            }
            if (optRB.isSelected()) {
                Globals.prefs.put("ooExecutablePath", new File(inOpt, "soffice.bin").getPath());
                File unoil = this.findFileDir(new File("/opt"), "unoil.jar");
                if (this.fileSearchCancelled) {
                    return false;
                }
                File jurt = this.findFileDir(new File("/opt"), "jurt.jar");
                if (this.fileSearchCancelled) {
                    return false;
                }
                if (unoil != null && jurt != null) {
                    Globals.prefs.put("ooUnoilPath", unoil.getPath());
                    Globals.prefs.put("ooJurtPath", jurt.getPath());
                    return true;
                }
                return false;
            }
            Globals.prefs.put("ooExecutablePath", new File(inUsr, "soffice.bin").getPath());
            File unoil = this.findFileDir(new File(usrRoot), "unoil.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            File jurt = this.findFileDir(new File(usrRoot), "jurt.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            if (unoil != null && jurt != null) {
                Globals.prefs.put("ooUnoilPath", unoil.getPath());
                Globals.prefs.put("ooJurtPath", jurt.getPath());
                return true;
            }
            return false;
        }
        return false;
    }

    private static List<File> findProgramFilesDir() {
        ArrayList<File> dirList = new ArrayList<File>();
        File root = new File("C:\\");
        File[] dirs = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        for (int i = 0; i < dirs.length; ++i) {
            File dir = dirs[i];
            if (dir.getName().toLowerCase().equals("program files")) {
                dirList.add(dir);
                continue;
            }
            if (!dir.getName().toLowerCase().equals("program files (x86)")) continue;
            dirList.add(dir);
        }
        return dirList;
    }

    public static boolean checkAutoDetectedPaths() {
        if (Globals.prefs.hasKey("ooUnoilPath") && Globals.prefs.hasKey("ooJurtPath") && Globals.prefs.hasKey("ooExecutablePath")) {
            return new File(Globals.prefs.get("ooUnoilPath"), "unoil.jar").exists() && new File(Globals.prefs.get("ooJurtPath"), "jurt.jar").exists() && new File(Globals.prefs.get("ooExecutablePath")).exists();
        }
        return false;
    }

    public File findFileDir(File startDir, String filename) {
        if (this.fileSearchCancelled) {
            return null;
        }
        File[] files = startDir.listFiles();
        if (files == null) {
            return null;
        }
        File result = null;
        for (int i = 0; i < files.length; ++i) {
            if (this.fileSearchCancelled) {
                return null;
            }
            if (files[i].isDirectory()) {
                result = this.findFileDir(files[i], filename);
                if (result == null) continue;
                break;
            }
            if (!files[i].getName().equals(filename)) continue;
            result = startDir;
            break;
        }
        return result;
    }

    public JDialog showProgressDialog(JDialog parent, String title, String message, boolean includeCancelButton) {
        this.fileSearchCancelled = false;
        JProgressBar bar = new JProgressBar(0);
        JButton cancel = new JButton(Globals.lang("Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoDetectPaths.this.fileSearchCancelled = true;
                ((JButton)event.getSource()).setEnabled(false);
            }
        });
        JDialog prog = new JDialog(parent, title, false);
        bar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        bar.setIndeterminate(true);
        if (includeCancelButton) {
            prog.add((Component)cancel, "South");
        }
        prog.add((Component)new JLabel(message), "North");
        prog.add((Component)bar, "Center");
        prog.pack();
        prog.setLocationRelativeTo(null);
        prog.setVisible(true);
        return prog;
    }
}

