/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.undo.NamedCompound;

public class UnabbreviateAction
extends AbstractWorker {
    BasePanel panel;
    String message = "";

    public UnabbreviateAction(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void init() {
        this.panel.output("Unabbreviating...");
    }

    @Override
    public void run() {
        BibtexEntry[] entries = this.panel.getSelectedEntries();
        if (entries == null) {
            return;
        }
        NamedCompound ce = new NamedCompound("Unabbreviate journal names");
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (!Globals.journalAbbrev.unabbreviate(this.panel.database(), entries[i], "journal", ce)) continue;
            ++count;
        }
        if (count > 0) {
            ce.end();
            this.panel.undoManager.addEdit(ce);
            this.panel.markBaseChanged();
            this.message = Globals.lang("Unabbreviated %0 journal names.", String.valueOf(count));
        } else {
            this.message = Globals.lang("No journal names could be unabbreviated.");
        }
    }

    @Override
    public void update() {
        this.panel.output(this.message);
    }
}

