/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class FreeCiteImporter
extends ImportFormat {
    @Override
    public boolean isRecognizedFormat(InputStream in) throws IOException {
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream in, OutputPrinter status) throws IOException {
        String text = new Scanner(in).useDelimiter("\\A").next();
        return this.importEntries(text, status);
    }

    public List<BibtexEntry> importEntries(String text, OutputPrinter status) {
        URLConnection conn;
        String urlencodedCitation = null;
        try {
            urlencodedCitation = URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String data = "citation=" + urlencodedCitation;
        try {
            URL url = new URL("http://freecite.library.brown.edu/citations/create");
            conn = url.openConnection();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            conn.setRequestProperty("accept", "text/xml");
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(data);
            writer.flush();
        }
        catch (IOException e) {
            status.showMessage(Globals.lang("Unable to connect to freecite online service."));
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        ArrayList<BibtexEntry> res = new ArrayList<BibtexEntry>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader parser = factory.createXMLStreamReader(conn.getInputStream());
            while (parser.hasNext()) {
                if (parser.getEventType() == 1 && parser.getLocalName().equals("citation")) {
                    parser.nextTag();
                    StringBuilder noteSB = new StringBuilder();
                    BibtexEntry e = new BibtexEntry();
                    BibtexEntryType type = BibtexEntryType.INPROCEEDINGS;
                    while (parser.getEventType() != 2 || !parser.getLocalName().equals("citation")) {
                        if (parser.getEventType() == 1) {
                            String ln = parser.getLocalName();
                            if (ln.equals("authors")) {
                                StringBuilder sb = new StringBuilder();
                                parser.nextTag();
                                while (parser.getEventType() == 1) {
                                    assert (parser.getLocalName().equals("author"));
                                    String author = parser.getElementText();
                                    if (sb.length() == 0) {
                                        sb.append(author);
                                    } else {
                                        sb.append(" and ");
                                        sb.append(author);
                                    }
                                    assert (parser.getEventType() == 2);
                                    assert (parser.getLocalName().equals("author"));
                                    parser.nextTag();
                                }
                                e.setField("author", sb.toString());
                            } else if (ln.equals("journal")) {
                                type = BibtexEntryType.ARTICLE;
                                e.setField(ln, parser.getElementText());
                            } else if (ln.equals("tech")) {
                                type = BibtexEntryType.TECHREPORT;
                                e.setField("number", parser.getElementText());
                            } else if (ln.equals("doi") || ln.equals("institution") || ln.equals("location") || ln.equals("number") || ln.equals("note") || ln.equals("title") || ln.equals("pages") || ln.equals("publisher") || ln.equals("volume") || ln.equals("year")) {
                                e.setField(ln, parser.getElementText());
                            } else if (ln.equals("booktitle")) {
                                String booktitle = parser.getElementText();
                                if (booktitle.startsWith("In ")) {
                                    booktitle = booktitle.substring(3);
                                }
                                e.setField("booktitle", booktitle);
                            } else if (!ln.equals("raw_string")) {
                                noteSB.append(ln);
                                noteSB.append(":");
                                noteSB.append(parser.getElementText());
                                noteSB.append(Globals.NEWLINE);
                            }
                        }
                        parser.next();
                    }
                    if (noteSB.length() > 0) {
                        String note = e.getField("note");
                        note = note != null ? note.concat(Globals.NEWLINE).concat(noteSB.toString()) : noteSB.toString();
                        e.setField("note", note);
                    }
                    e.setType(type);
                    e = LabelPatternUtil.makeLabel(JabRef.jrf.basePanel().metaData(), JabRef.jrf.basePanel().database(), e);
                    res.add(e);
                }
                parser.next();
            }
            parser.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return res;
    }

    @Override
    public String getFormatName() {
        return "text citations";
    }
}

