/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.help.HTMLParagraphView;

public class LargeHTMLEditorKit
extends HTMLEditorKit {
    ViewFactory factory = new MyViewFactory();

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }

    private class HTMLBlockView
    extends BlockView {
        public HTMLBlockView(Element elem) {
            super(elem, 1);
        }

        @Override
        protected void layout(int width, int height) {
            if (width < Integer.MAX_VALUE) {
                super.layout(new Double((double)width / this.getZoomFactor()).intValue(), new Double((double)height * this.getZoomFactor()).intValue());
            }
        }

        public double getZoomFactor() {
            Double scale = (Double)this.getDocument().getProperty("ZOOM_FACTOR");
            if (scale == null) {
                return GUIGlobals.zoomLevel;
            }
            return scale;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Graphics2D g2d = (Graphics2D)g;
            double zoomFactor = this.getZoomFactor();
            AffineTransform old = g2d.getTransform();
            g2d.scale(zoomFactor, zoomFactor);
            super.paint(g2d, allocation);
            g2d.setTransform(old);
        }

        @Override
        public float getMinimumSpan(int axis) {
            float f = super.getMinimumSpan(axis);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }

        @Override
        public float getMaximumSpan(int axis) {
            float f = super.getMaximumSpan(axis);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }

        @Override
        public float getPreferredSpan(int axis) {
            float f = super.getPreferredSpan(axis);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            double zoomFactor = this.getZoomFactor();
            Rectangle alloc = a.getBounds();
            Shape s = super.modelToView(pos, alloc, b);
            alloc = s.getBounds();
            alloc.x = (int)((double)alloc.x * zoomFactor);
            alloc.y = (int)((double)alloc.y * zoomFactor);
            alloc.width = (int)((double)alloc.width * zoomFactor);
            alloc.height = (int)((double)alloc.height * zoomFactor);
            return alloc;
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            double zoomFactor = this.getZoomFactor();
            Rectangle alloc = a.getBounds();
            x = (float)((double)x / zoomFactor);
            y = (float)((double)y / zoomFactor);
            alloc.x = (int)((double)alloc.x / zoomFactor);
            alloc.y = (int)((double)alloc.y / zoomFactor);
            alloc.width = (int)((double)alloc.width / zoomFactor);
            alloc.height = (int)((double)alloc.height / zoomFactor);
            return super.viewToModel(x, y, alloc, bias);
        }
    }

    class MyViewFactory
    extends HTMLEditorKit.HTMLFactory {
        MyViewFactory() {
        }

        @Override
        public View create(Element elem) {
            Object o;
            AttributeSet attrs = elem.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object = o = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag) {
                HTML.Tag kind = (HTML.Tag)o;
                if (kind == HTML.Tag.HTML) {
                    return new HTMLBlockView(elem);
                }
                if (kind == HTML.Tag.IMPLIED) {
                    String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (ws != null && ws.equals("pre")) {
                        return super.create(elem);
                    }
                    return new HTMLParagraphView(elem);
                }
                if (kind == HTML.Tag.P || kind == HTML.Tag.H1 || kind == HTML.Tag.H2 || kind == HTML.Tag.H3 || kind == HTML.Tag.H4 || kind == HTML.Tag.H5 || kind == HTML.Tag.H6 || kind == HTML.Tag.DT) {
                    return new HTMLParagraphView(elem);
                }
            }
            return super.create(elem);
        }
    }
}

