/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.sf.jabref.Globals;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;

public class PluginBasedExportFormat
extends ExportFormat {
    public _JabRefPlugin.ExportFormatTemplateExtension extension;

    public static PluginBasedExportFormat getFormat(_JabRefPlugin.ExportFormatTemplateExtension extension) {
        String consoleName = extension.getConsoleName();
        String displayName = extension.getDisplayName();
        String layoutFilename = extension.getLayoutFilename();
        String fileExtension = extension.getExtension();
        String encoding = extension.getEncoding();
        if ("".equals(fileExtension) || "".equals(displayName) || "".equals(consoleName) || "".equals(layoutFilename)) {
            Globals.logger("Could not load extension " + extension.getId());
            return null;
        }
        return new PluginBasedExportFormat(displayName, consoleName, layoutFilename, fileExtension, encoding, extension);
    }

    public PluginBasedExportFormat(String displayName, String consoleName, String layoutFileName, String fileExtension, String encoding, _JabRefPlugin.ExportFormatTemplateExtension extension) {
        super(displayName, consoleName, layoutFileName, null, fileExtension);
        if (encoding != null) {
            this.setEncoding(encoding);
        }
        this.extension = extension;
    }

    @Override
    public Reader getReader(String filename) throws IOException {
        URL reso = this.extension.getDirAsUrl(filename);
        if (reso != null) {
            try {
                return new InputStreamReader(reso.openStream());
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        try {
            return new FileReader(new File(filename));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(Globals.lang("Could not find layout file") + ": '" + filename + "'.");
        }
    }
}

