/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.SortedList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexString;
import net.sf.jabref.BibtexStringComparator;
import net.sf.jabref.CrossRefEntryComparator;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.FieldComparatorStack;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.IdComparator;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;

public class FileActions {
    private static Pattern refPat = Pattern.compile("(#[A-Za-z]+#)");

    private static void writePreamble(Writer fw, String preamble) throws IOException {
        if (preamble != null) {
            fw.write("@PREAMBLE{");
            fw.write(preamble);
            fw.write("}" + Globals.NEWLINE + Globals.NEWLINE);
        }
    }

    private static void writeStrings(Writer fw, BibtexDatabase database) throws IOException {
        ArrayList<BibtexString> strings = new ArrayList<BibtexString>();
        for (String s : database.getStringKeySet()) {
            strings.add(database.getString(s));
        }
        Collections.sort(strings, new BibtexStringComparator(true));
        HashMap<String, BibtexString> remaining = new HashMap<String, BibtexString>();
        for (BibtexString string : strings) {
            remaining.put(string.getName(), string);
        }
        for (BibtexString bs : strings) {
            if (!remaining.containsKey(bs.getName())) continue;
            FileActions.writeString(fw, bs, remaining);
        }
    }

    private static void writeString(Writer fw, BibtexString bs, HashMap<String, BibtexString> remaining) throws IOException {
        Matcher m;
        remaining.remove(bs.getName());
        String content = bs.getContent();
        while ((m = refPat.matcher(content)).find()) {
            String foundLabel = m.group(1);
            int restIndex = content.indexOf(foundLabel) + foundLabel.length();
            content = content.substring(restIndex);
            BibtexString referred = remaining.get(foundLabel.substring(1, foundLabel.length() - 1));
            if (referred == null) continue;
            FileActions.writeString(fw, referred, remaining);
        }
        fw.write("@STRING{" + bs.getName() + " = ");
        if (!bs.getContent().equals("")) {
            try {
                String formatted = new LatexFieldFormatter().format(bs.getContent(), "__string");
                fw.write(formatted);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(Globals.lang("The # character is not allowed in BibTeX strings unless escaped as in '\\#'.") + "\n" + Globals.lang("Before saving, please edit any strings containing the # character."));
            }
        } else {
            fw.write("{}");
        }
        fw.write("}" + Globals.NEWLINE + Globals.NEWLINE);
    }

    private static void writeBibFileHeader(Writer out, String encoding) throws IOException {
        out.write("% ");
        out.write("This file was created with JabRef");
        out.write(" " + GUIGlobals.version + "." + Globals.NEWLINE + "% " + GUIGlobals.encPrefix + encoding + Globals.NEWLINE + Globals.NEWLINE);
    }

    public static SaveSession saveDatabase(BibtexDatabase database, MetaData metaData, File file, JabRefPreferences prefs, boolean checkSearch, boolean checkGroup, String encoding, boolean suppressBackup) throws SaveException {
        SaveSession session;
        TreeMap<String, BibtexEntryType> types = new TreeMap<String, BibtexEntryType>();
        boolean backup = prefs.getBoolean("backup");
        if (suppressBackup) {
            backup = false;
        }
        BibtexEntry exceptionCause = null;
        try {
            session = new SaveSession(file, encoding, backup);
        }
        catch (Throwable e) {
            if (encoding != null) {
                System.err.println("Error from encoding: '" + encoding + "' Len: " + encoding.length());
            }
            e.printStackTrace();
            throw new SaveException(e.getMessage());
        }
        try {
            BibtexEntryType tp;
            VerifyingWriter fw = session.getWriter();
            FileActions.writeBibFileHeader(fw, encoding);
            FileActions.writePreamble(fw, database.getPreamble());
            FileActions.writeStrings(fw, database);
            List<BibtexEntry> sorter = FileActions.getSortedEntries(database, null, true);
            LatexFieldFormatter ff = new LatexFieldFormatter();
            Iterator<BibtexEntry> i$ = sorter.iterator();
            while (i$.hasNext()) {
                BibtexEntry be;
                exceptionCause = be = i$.next();
                tp = be.getType();
                if (BibtexEntryType.getStandardType(tp.getName()) == null) {
                    types.put(tp.getName(), tp);
                }
                boolean write = true;
                if (checkSearch && !FileActions.nonZeroField(be, "__search")) {
                    write = false;
                }
                if (checkGroup && !FileActions.nonZeroField(be, "__groupsearch")) {
                    write = false;
                }
                if (!write) continue;
                be.write(fw, ff, true);
                fw.write(Globals.NEWLINE);
            }
            if (metaData != null) {
                metaData.writeMetaData(fw);
            }
            if (types.size() > 0) {
                Iterator i = types.keySet().iterator();
                while (i.hasNext()) {
                    BibtexEntryType type = (BibtexEntryType)types.get(i.next());
                    if (!(type instanceof CustomEntryType)) continue;
                    tp = (CustomEntryType)type;
                    ((CustomEntryType)tp).save(fw);
                    fw.write(Globals.NEWLINE);
                }
            }
            fw.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            try {
                session.cancel();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SaveException(ex.getMessage() + "\n" + Globals.lang("Warning: could not complete file repair; your file may have been corrupted. Error message") + ": " + e.getMessage());
            }
            throw new SaveException(ex.getMessage(), exceptionCause);
        }
        return session;
    }

    public static SaveSession savePartOfDatabase(BibtexDatabase database, MetaData metaData, File file, JabRefPreferences prefs, BibtexEntry[] bes, String encoding) throws SaveException {
        SaveSession session;
        TreeMap<String, BibtexEntryType> types = new TreeMap<String, BibtexEntryType>();
        BibtexEntry be2 = null;
        boolean backup = prefs.getBoolean("backup");
        try {
            session = new SaveSession(file, encoding, backup);
        }
        catch (IOException e) {
            throw new SaveException(e.getMessage());
        }
        try {
            BibtexEntryType tp;
            boolean terD;
            boolean secD;
            boolean priD;
            String ter;
            String sec;
            String pri;
            VerifyingWriter fw = session.getWriter();
            FileActions.writeBibFileHeader(fw, encoding);
            FileActions.writePreamble(fw, database.getPreamble());
            FileActions.writeStrings(fw, database);
            if (!prefs.getBoolean("saveInStandardOrder")) {
                pri = prefs.get("priSort");
                sec = prefs.get("secSort");
                ter = prefs.get("terSort");
                priD = prefs.getBoolean("priDescending");
                secD = prefs.getBoolean("secDescending");
                terD = prefs.getBoolean("terDescending");
            } else {
                pri = "author";
                sec = "editor";
                ter = "year";
                priD = false;
                secD = false;
                terD = true;
            }
            ArrayList<Comparator<BibtexEntry>> comparators = new ArrayList<Comparator<BibtexEntry>>();
            comparators.add(new CrossRefEntryComparator());
            comparators.add(new FieldComparator(pri, priD));
            comparators.add(new FieldComparator(sec, secD));
            comparators.add(new FieldComparator(ter, terD));
            comparators.add(new FieldComparator("bibtexkey"));
            BasicEventList entryList = new BasicEventList();
            SortedList<BibtexEntry> sorter = new SortedList<BibtexEntry>(entryList, new FieldComparatorStack(comparators));
            if (bes != null && bes.length > 0) {
                for (int i = 0; i < bes.length; ++i) {
                    sorter.add(bes[i]);
                }
            }
            LatexFieldFormatter ff = new LatexFieldFormatter();
            for (BibtexEntry be2 : sorter) {
                tp = be2.getType();
                if (BibtexEntryType.getStandardType(tp.getName()) == null) {
                    types.put(tp.getName(), tp);
                }
                be2.write(fw, ff, true);
                fw.write(Globals.NEWLINE);
            }
            if (metaData != null) {
                metaData.writeMetaData(fw);
            }
            if (types.size() > 0) {
                Iterator<Object> i = types.keySet().iterator();
                while (i.hasNext()) {
                    tp = (CustomEntryType)types.get(i.next());
                    ((CustomEntryType)tp).save(fw);
                    fw.write(Globals.NEWLINE);
                }
            }
            fw.close();
        }
        catch (Throwable ex) {
            try {
                session.cancel();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SaveException(ex.getMessage() + "\n" + Globals.lang("Warning: could not complete file repair; your file may have been corrupted. Error message") + ": " + e.getMessage());
            }
            throw new SaveException(ex.getMessage(), be2);
        }
        return session;
    }

    public static Reader getReader(String name) throws IOException {
        InputStreamReader reader = null;
        URL reso = Globals.class.getResource(name);
        if (reso != null) {
            try {
                reader = new InputStreamReader(reso.openStream());
            }
            catch (FileNotFoundException ex) {
                throw new IOException(Globals.lang("Could not find layout file") + ": '" + name + "'.");
            }
        }
        File f = new File(name);
        try {
            reader = new FileReader(f);
        }
        catch (FileNotFoundException ex) {
            throw new IOException(Globals.lang("Could not find layout file") + ": '" + name + "'.");
        }
        return reader;
    }

    public static List<BibtexEntry> getSortedEntries(BibtexDatabase database, Set<String> keySet, boolean isSaveOperation) {
        boolean inOriginalOrder;
        FieldComparatorStack comparatorStack = null;
        boolean bl = inOriginalOrder = isSaveOperation ? Globals.prefs.getBoolean("saveInOriginalOrder") : Globals.prefs.getBoolean("exportInOriginalOrder");
        if (inOriginalOrder) {
            ArrayList<Comparator<BibtexEntry>> comparators = new ArrayList<Comparator<BibtexEntry>>();
            comparators.add(new CrossRefEntryComparator());
            comparators.add(new IdComparator());
            comparatorStack = new FieldComparatorStack(comparators);
        } else {
            boolean secD;
            boolean priD;
            String ter;
            String sec;
            String pri;
            boolean inStandardOrder;
            boolean terD = false;
            boolean bl2 = inStandardOrder = isSaveOperation ? Globals.prefs.getBoolean("saveInStandardOrder") : Globals.prefs.getBoolean("exportInStandardOrder");
            if (!inStandardOrder) {
                pri = Globals.prefs.get("priSort");
                sec = Globals.prefs.get("secSort");
                ter = Globals.prefs.get("terSort");
                priD = Globals.prefs.getBoolean("priDescending");
                secD = Globals.prefs.getBoolean("secDescending");
                terD = Globals.prefs.getBoolean("terDescending");
            } else {
                pri = "author";
                sec = "editor";
                ter = "year";
                priD = false;
                secD = false;
                terD = true;
            }
            ArrayList<Comparator<BibtexEntry>> comparators = new ArrayList<Comparator<BibtexEntry>>();
            if (isSaveOperation) {
                comparators.add(new CrossRefEntryComparator());
            }
            comparators.add(new FieldComparator(pri, priD));
            comparators.add(new FieldComparator(sec, secD));
            comparators.add(new FieldComparator(ter, terD));
            comparators.add(new FieldComparator("bibtexkey"));
            comparatorStack = new FieldComparatorStack(comparators);
        }
        BasicEventList entryList = new BasicEventList();
        SortedList<BibtexEntry> sorter = new SortedList<BibtexEntry>(entryList, comparatorStack);
        if (keySet == null) {
            keySet = database.getKeySet();
        }
        if (keySet != null) {
            Iterator<String> i = keySet.iterator();
            while (i.hasNext()) {
                sorter.add(database.getEntryById(i.next()));
            }
        }
        return sorter;
    }

    private static boolean nonZeroField(BibtexEntry be, String field) {
        String o = be.getField(field);
        return o != null && !o.equals("0");
    }
}

