/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;

public class EntryAddChange
extends Change {
    BibtexEntry diskEntry;
    PreviewPanel pp;
    JScrollPane sp;

    public EntryAddChange(BibtexEntry diskEntry) {
        super("Added entry");
        this.diskEntry = diskEntry;
        this.pp = new PreviewPanel(null, diskEntry, null, new MetaData(), Globals.prefs.get("preview0"));
        this.sp = new JScrollPane(this.pp);
    }

    @Override
    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        this.diskEntry.setId(Util.createNeutralId());
        panel.database().insertEntry(this.diskEntry);
        secondary.insertEntry(this.diskEntry);
        undoEdit.addEdit(new UndoableInsertEntry(panel.database(), this.diskEntry, panel));
        return true;
    }

    @Override
    JComponent description() {
        return this.sp;
    }
}

