/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;

public class SplashScreen
extends Window {
    private Image splashImage;
    private boolean paintCalled = false;

    public SplashScreen(Frame owner) {
        super(owner);
        URL imageURL = SplashScreen.class.getResource("/images/splash.png");
        this.splashImage = Toolkit.getDefaultToolkit().createImage(imageURL);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.splashImage, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int imgWidth = this.splashImage.getWidth(this);
        int imgHeight = this.splashImage.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void update(Graphics g) {
        g.setColor(this.getForeground());
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.splashImage, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashScreen splashScreen = this;
            synchronized (splashScreen) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash() {
        Frame f = new Frame();
        SplashScreen w = new SplashScreen(f);
        w.setVisible(true);
        w.toFront();
        if (!EventQueue.isDispatchThread()) {
            SplashScreen splashScreen = w;
            synchronized (splashScreen) {
                if (!w.paintCalled) {
                    try {
                        w.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return f;
    }
}

