/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class ShortOption
extends Option {
    private short value;

    public ShortOption() {
        this(0);
    }

    public ShortOption(ShortOption op) {
        super(op);
        op.value = op.getValue();
    }

    public ShortOption(short value) {
        this(value, null);
    }

    public ShortOption(short value, String longOption) {
        this(value, longOption, '\u0000');
    }

    public ShortOption(short value, char shortOption) {
        this(value, null, shortOption);
    }

    public ShortOption(short value, String longOption, char shortOption) {
        super(longOption, shortOption);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return new Short(this.value);
    }

    @Override
    public void modify(String value) throws OptionModificationException {
        try {
            this.value = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new OptionModificationException("Error. A short must be specified, not '" + value + "'.");
        }
    }

    public void setValue(String value) throws OptionModificationException {
        this.modify(value);
    }

    public void setValue(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return Short.toString(this.value);
    }

    @Override
    public String getTypeName() {
        return "SHORT";
    }

    public String toString() {
        return this.getStringValue();
    }
}

