/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.profiler4j.console.AppEvent;
import net.sf.profiler4j.console.AppEventListener;
import net.sf.profiler4j.console.AppEventType;
import net.sf.profiler4j.console.ClassListTableModel;
import net.sf.profiler4j.console.Console;
import net.sf.profiler4j.console.ProjectDialog;
import net.sf.profiler4j.console.Rule;
import net.sf.profiler4j.console.client.ClassInfo;
import net.sf.profiler4j.console.client.ClientException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassListPanel
extends JPanel
implements AppEventListener {
    private Log log = LogFactory.getLog(this.getClass());
    private JScrollPane classesScrollPane = null;
    private JTable classesTable = null;
    private JPanel bottomPanel = null;
    private JTextField filterTextField = null;
    private ClassListTableModel classListTableModel = null;
    private JPanel topPanel = null;
    private JButton refreshButton = null;
    private Console app;
    private JButton clearButton = null;
    private JLabel jLabel = null;
    private JButton addAsRuleButton = null;
    private JCheckBox onlyInstrumentedCheckBox = null;

    public ClassListPanel(Console app) {
        this.app = app;
        this.initialize();
        app.addListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(582, 200);
        this.add((Component)this.getClassesScrollPane(), "Center");
        this.add((Component)this.getBottomPanel(), "South");
        this.add((Component)this.getTopPanel(), "North");
    }

    private JScrollPane getClassesScrollPane() {
        if (this.classesScrollPane == null) {
            this.classesScrollPane = new JScrollPane();
            this.classesScrollPane.setViewportView(this.getClassesTable());
        }
        return this.classesScrollPane;
    }

    private JTable getClassesTable() {
        if (this.classesTable == null) {
            this.classesTable = new JTable();
            this.classesTable.setSelectionMode(2);
            this.classesTable.setFont(new Font("Tahoma", 0, 12));
            this.classesTable.setModel(this.getClassListTableModel());
            this.classesTable.setRowHeight(20);
            this.classesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (ClassListPanel.this.classesTable.getSelectedRowCount() > 0) {
                        ClassListPanel.this.addAsRuleButton.setEnabled(true);
                    } else {
                        ClassListPanel.this.addAsRuleButton.setEnabled(false);
                    }
                }
            });
            TableColumn c = this.classesTable.getColumnModel().getColumn(0);
            c.setMinWidth(50);
            c.setMaxWidth(50);
            c = this.classesTable.getColumnModel().getColumn(1);
            c.setMinWidth(300);
            c.setCellRenderer(new DefaultTableCellRenderer(){
                Font f1 = new Font("Tahoma", 0, 12);
                Font f2 = new Font("Tahoma", 1, 12);

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (isSelected) {
                        this.setFont(this.f2);
                    } else {
                        this.setFont(this.f1);
                    }
                    if (((ClassListPanel)ClassListPanel.this).classListTableModel.getRow((int)row).info.isInstrumented()) {
                        if (isSelected) {
                            this.setForeground(Color.YELLOW);
                            this.setBackground(Color.BLUE);
                        } else {
                            this.setBackground(Color.decode("#bbffbb"));
                            this.setForeground(Color.BLACK);
                        }
                    } else if (isSelected) {
                        this.setForeground(Color.WHITE);
                        this.setBackground(Color.BLUE);
                    } else {
                        this.setBackground(Color.WHITE);
                        this.setForeground(Color.BLACK);
                    }
                    this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
                    return this;
                }
            });
        }
        return this.classesTable;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 5;
            gridBagConstraints11.insets = new Insets(8, 4, 8, 8);
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(8, 4, 8, 4);
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.gridx = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(8, 4, 8, 4);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 3;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 8, 4, 4);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Filter: ");
            this.bottomPanel = new JPanel();
            this.bottomPanel.setLayout(new GridBagLayout());
            this.bottomPanel.add((Component)this.jLabel, gridBagConstraints);
            this.bottomPanel.add((Component)this.getFilterTextField(), gridBagConstraints1);
            this.bottomPanel.add((Component)this.getClearButton(), gridBagConstraints2);
            this.bottomPanel.add((Component)this.getRefreshButton(), gridBagConstraints3);
            this.bottomPanel.add((Component)this.getAddAsRuleButton(), gridBagConstraints11);
            this.bottomPanel.add((Component)this.getOnlyInstrumentedCheckBox(), gridBagConstraints12);
        }
        return this.bottomPanel;
    }

    private JTextField getFilterTextField() {
        if (this.filterTextField == null) {
            this.filterTextField = new JTextField();
            this.filterTextField.setColumns(20);
            this.filterTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ClassListPanel.this.refreshClassList();
                    }
                }
            });
        }
        return this.filterTextField;
    }

    private ClassListTableModel getClassListTableModel() {
        if (this.classListTableModel == null) {
            this.classListTableModel = new ClassListTableModel();
        }
        return this.classListTableModel;
    }

    public void refreshClassList() {
        try {
            ClassInfo[] classes = this.app.getClient().listLoadedClasses();
            this.classListTableModel.setFilters(this.filterTextField.getText(), this.onlyInstrumentedCheckBox.isSelected());
            this.classListTableModel.setClasses(classes);
        }
        catch (ClientException ce) {
            this.log.error((Object)"Could not refresh class list", (Throwable)ce);
            JOptionPane.showMessageDialog(this, "Request error", "Error", 0);
        }
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout());
        }
        return this.topPanel;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setToolTipText("Refresh list");
            this.refreshButton.setPreferredSize(new Dimension(28, 28));
            this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/refresh.gif")));
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassListPanel.this.refreshClassList();
                }
            });
        }
        return this.refreshButton;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/removed.gif")));
            this.clearButton.setPreferredSize(new Dimension(28, 28));
            this.clearButton.setToolTipText("Clear filter");
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassListPanel.this.filterTextField.setText("");
                    ClassListPanel.this.refreshClassList();
                }
            });
        }
        return this.clearButton;
    }

    private JButton getAddAsRuleButton() {
        if (this.addAsRuleButton == null) {
            this.addAsRuleButton = new JButton();
            this.addAsRuleButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/wand.png")));
            this.addAsRuleButton.setToolTipText("Create rules from classes");
            this.addAsRuleButton.setEnabled(false);
            this.addAsRuleButton.setPreferredSize(new Dimension(28, 28));
            this.addAsRuleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int ret = JOptionPane.showConfirmDialog(ClassListPanel.this, "Create rules from selected classes?", "Question", 0);
                    if (ret == 0) {
                        int i = 0;
                        for (int r : ClassListPanel.this.classesTable.getSelectedRows()) {
                            String n = ((ClassListPanel)ClassListPanel.this).classListTableModel.getRow((int)r).info.getName();
                            Rule rule = new Rule(n + ".*(*)", Rule.Action.ACCEPT);
                            ClassListPanel.this.app.getProject().getRules().add(i++, rule);
                        }
                        ProjectDialog d = new ProjectDialog(ClassListPanel.this.app.getMainFrame(), ClassListPanel.this.app);
                        d.edit(ClassListPanel.this.app.getProject());
                    }
                }
            });
        }
        return this.addAsRuleButton;
    }

    private JCheckBox getOnlyInstrumentedCheckBox() {
        if (this.onlyInstrumentedCheckBox == null) {
            this.onlyInstrumentedCheckBox = new JCheckBox();
            this.onlyInstrumentedCheckBox.setText("Only Instrumented");
            this.onlyInstrumentedCheckBox.setSelected(false);
            this.onlyInstrumentedCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ClassListPanel.this.refreshClassList();
                }
            });
        }
        return this.onlyInstrumentedCheckBox;
    }

    public boolean receiveEvent(AppEvent ev) {
        if (ev.getType() == AppEventType.CONNECTED) {
            this.refreshClassList();
        } else if (ev.getType() == AppEventType.DISCONNECTED) {
            this.classListTableModel.clear();
        } else if (ev.getType() == AppEventType.RULES_APPLIED) {
            this.refreshClassList();
        }
        return false;
    }
}

