/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.cdi.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.jersey.gf.cdi.internal.LocalizationMessages;

public final class InjecteeSkippingAnalyzer
implements ClassAnalyzer {
    private final ClassAnalyzer defaultAnalyzer;
    private final Map<Class<?>, Set<Method>> methodsToSkip;
    private final Map<Class<?>, Set<Field>> fieldsToSkip;

    public InjecteeSkippingAnalyzer(ClassAnalyzer defaultAnalyzer, Map<Class<?>, Set<Method>> methodsToSkip, Map<Class<?>, Set<Field>> fieldsToSkip) {
        this.defaultAnalyzer = defaultAnalyzer;
        this.methodsToSkip = methodsToSkip;
        this.fieldsToSkip = fieldsToSkip;
    }

    public <T> Constructor<T> getConstructor(Class<T> type) throws MultiException, NoSuchMethodException {
        throw new IllegalStateException(LocalizationMessages.CDI_CLASS_ANALYZER_MISUSED());
    }

    public <T> Set<Method> getInitializerMethods(Class<T> type) throws MultiException {
        Set originalMethods = this.defaultAnalyzer.getInitializerMethods(type);
        Set skippedMethods = this.getMembersToSkip(type, this.methodsToSkip);
        return skippedMethods == null ? originalMethods : Sets.difference((Set)originalMethods, skippedMethods);
    }

    public <T> Set<Field> getFields(Class<T> type) throws MultiException {
        Set originalFields = this.defaultAnalyzer.getFields(type);
        Set skippedFields = this.getMembersToSkip(type, this.fieldsToSkip);
        return skippedFields == null ? originalFields : Sets.difference((Set)originalFields, skippedFields);
    }

    public <T> Method getPostConstructMethod(Class<T> type) throws MultiException {
        throw new IllegalStateException(LocalizationMessages.CDI_CLASS_ANALYZER_MISUSED());
    }

    public <T> Method getPreDestroyMethod(Class<T> type) throws MultiException {
        throw new IllegalStateException(LocalizationMessages.CDI_CLASS_ANALYZER_MISUSED());
    }

    private <M extends Member> Set<M> getMembersToSkip(Class<?> type, Map<Class<?>, Set<M>> skippedMembers) {
        Set<M> directResult = skippedMembers.get(type);
        if (directResult != null) {
            return directResult;
        }
        HashSet compositeResult = new HashSet();
        for (Class<?> originalType : skippedMembers.keySet()) {
            if (!originalType.isAssignableFrom(type)) continue;
            compositeResult.addAll(skippedMembers.get(originalType));
        }
        return compositeResult;
    }
}

