/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface ReflectionLogger
extends WeldLogger {
    public static final ReflectionLogger LOG = (ReflectionLogger)Logger.getMessageLogger(ReflectionLogger.class, (String)Category.REFLECTION.getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=600, value="{0} is missing @Retention(RUNTIME). Weld will use this annotation, however this may make the application unportable.", format=Message.Format.MESSAGE_FORMAT)
    public void missingRetention(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=601, value="{0} is missing @Target. Weld will use this annotation, however this may make the application unportable.", format=Message.Format.MESSAGE_FORMAT)
    public void missingTarget(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=602, value="{0} is not declared @Target(TYPE, METHOD) or @Target(TYPE). Weld will use this annotation, however this may make the application unportable.", format=Message.Format.MESSAGE_FORMAT)
    public void missingTargetTypeMethodOrTargetType(Object var1);

    @Deprecated
    @Message(id=603, value="{0} is declared @Target(TYPE, METHOD), but inherits {1}, which is declared @Target(TYPE). Weld will use this annotation, however this may make the application unportable.", format=Message.Format.MESSAGE_FORMAT)
    public String targetTypeMethodInheritsFromTargetType(Object var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=604, value="{0} is not declared @Target(METHOD, FIELD, TYPE). Weld will use this annotation, however this may make the application unportable.", format=Message.Format.MESSAGE_FORMAT)
    public void missingTargetMethodFieldType(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=605, value="{0} is not declared @Target(METHOD, FIELD, TYPE, PARAMETER), @Target(METHOD, TYPE), @Target(METHOD), @Target(TYPE) or @Target(FIELD). Weld will use this annotation, however this may make the application unportable.", format=Message.Format.MESSAGE_FORMAT)
    public void missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField(Object var1);

    @Message(id=606, value="Unable to determine name of parameter")
    public IllegalArgumentException unableToGetParameterName();

    @Message(id=607, value="annotationMap cannot be null")
    public WeldException annotationMapNull();

    @Message(id=608, value="declaredAnnotationMap cannot be null")
    public WeldException declaredAnnotationMapNull();

    @Deprecated
    @Message(id=609, value="Cleaning Javassist proxy. Class {0}", format=Message.Format.MESSAGE_FORMAT)
    public String cleaningJavassistProxyClass(Object var1);

    @Message(id=610, value="Unable to deserialize constructor. Declaring class {0}, index {1}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException unableToGetConstructorOnDeserialization(Object var1, Object var2, @Cause Throwable var3);

    @Message(id=611, value="Unable to deserialize method. Declaring class {0}, index {1}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException unableToGetMethodOnDeserialization(Object var1, Object var2, @Cause Throwable var3);

    @Message(id=612, value="Unable to deserialize field. Declaring class {0}, field name {1}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException unableToGetFieldOnDeserialization(Object var1, Object var2, @Cause Throwable var3);

    @Deprecated
    @Message(id=613, value="Unable to deserialize parameter. Declaring class {0}, parameter {2} of method with signature {1}", format=Message.Format.MESSAGE_FORMAT)
    public String unableToGetParameterOnDeserialization(Object var1, Object var2, Object var3);

    @Message(id=614, value="Incorrect number of AnnotatedParameters {0} on AnnotatedMethod {1}. AnnotatedMethod has {2} as parameters but should have {3} as parameters", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException incorrectNumberOfAnnotatedParametersMethod(Object var1, Object var2, Object var3, Object var4);

    @Deprecated
    @Message(id=615, value="Incorrect number of AnnotatedParameters {0} on AnnotatedConstructor {1}. AnnotatedConstructor has {2} as parameters but should have {3} as parameters", format=Message.Format.MESSAGE_FORMAT)
    public String incorrectNumberOfAnnotatedParametersConstructor(Object var1, Object var2, Object var3, Object var4);

    @Message(id=616, value="Instantiation through ReflectionFactory of {0} failed", format=Message.Format.MESSAGE_FORMAT)
    public WeldException reflectionfactoryInstantiationFailed(Object var1, @Cause Throwable var2);

    @Message(id=617, value="Instantiation through Unsafe of {0} failed", format=Message.Format.MESSAGE_FORMAT)
    public WeldException unsafeInstantiationFailed(Object var1, @Cause Throwable var2);

    @Deprecated
    @Message(id=618, value="Could not set MethodHandler on {0}", format=Message.Format.MESSAGE_FORMAT)
    public String methodhandlerSetFailed(Object var1);

    @Message(id=619, value="An interceptor for lifecycle callbacks {0} declares and interceptor binding {1} with METHOD as its @Target.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException methodElementTypeNotAllowed(Object var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=620, value="{0} is not declared @Target(METHOD, FIELD, PARAMETER, TYPE). Weld will use this annotation, however this may make the application unportable.", format=Message.Format.MESSAGE_FORMAT)
    public void missingTargetMethodFieldParameterType(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=621, value="Interceptor binding {0} with @Target defined as {1} should not be applied on interceptor binding {2} with @Target definition: {3}", format=Message.Format.MESSAGE_FORMAT)
    public void invalidInterceptorBindingTargetDeclaration(Object var1, Object var2, Object var3, Object var4);

    @Message(id=622, value="IllegalArgumentException invoking {2} on {1} ({0}) with parameters {3}", format=Message.Format.MESSAGE_FORMAT)
    public WeldException illegalArgumentExceptionOnReflectionInvocation(Class<?> var1, Object var2, Method var3, String var4, @Cause java.lang.IllegalArgumentException var5);
}

