/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ctl;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.directory.InvalidAttributeValueException;

public final class VirtualListViewControl
extends BasicControl {
    public static final String OID = "2.16.840.1.113730.3.4.9";
    private int beforeCount;
    private int afterCount;
    private int targetOffset = -1;
    private int listSize;
    private Object targetAttrValue = null;
    private byte[] cookie = null;
    private static final long serialVersionUID = 7739016048653396131L;

    public VirtualListViewControl(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        super(OID, bl, null);
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException();
        }
        this.targetOffset = n;
        this.listSize = n2;
        this.beforeCount = n3;
        this.afterCount = n4;
        this.value = this.setEncodedValue();
    }

    public VirtualListViewControl(int n, int n2, boolean bl) throws IOException {
        super(OID, bl, null);
        if (n > 100 || n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.targetOffset = n;
        this.listSize = 100;
        if (n2 > 0) {
            --n2;
        }
        this.afterCount = n2 / 2;
        this.beforeCount = this.afterCount++;
        if (n2 != n2 / 2 * 2) {
            // empty if block
        }
        this.value = this.setEncodedValue();
    }

    public VirtualListViewControl(Object object, int n, int n2, boolean bl) throws InvalidAttributeValueException, IOException {
        super(OID, bl, null);
        if (object == null || !(object instanceof String) && !(object instanceof byte[])) {
            throw new InvalidAttributeValueException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.targetAttrValue = object;
        this.beforeCount = n;
        this.afterCount = n2;
        this.value = this.setEncodedValue();
    }

    public VirtualListViewControl(Object object, int n, boolean bl) throws InvalidAttributeValueException, IOException {
        super(OID, bl, null);
        if (object == null || !(object instanceof String) && !(object instanceof byte[])) {
            throw new InvalidAttributeValueException();
        }
        this.targetAttrValue = object;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > 0) {
            --n;
        }
        this.afterCount = n / 2;
        this.beforeCount = this.afterCount++;
        if (n != n / 2 * 2) {
            // empty if block
        }
        this.value = this.setEncodedValue();
    }

    public void setContextID(byte[] byArray) throws IOException {
        if (this.cookie != byArray) {
            this.cookie = byArray;
            this.value = this.setEncodedValue();
        } else {
            this.cookie = byArray;
        }
    }

    private byte[] setEncodedValue() throws IOException {
        BerEncoder berEncoder = new BerEncoder(64);
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(this.beforeCount);
        berEncoder.encodeInt(this.afterCount);
        if (this.targetOffset >= 0) {
            berEncoder.beginSeq(160);
            berEncoder.encodeInt(this.targetOffset);
            berEncoder.encodeInt(this.listSize);
            berEncoder.endSeq();
        } else if (this.targetAttrValue instanceof String) {
            berEncoder.encodeString((String)this.targetAttrValue, 129, true);
        } else {
            berEncoder.encodeOctetString((byte[])this.targetAttrValue, 129);
        }
        if (this.cookie != null) {
            berEncoder.encodeOctetString(this.cookie, 4);
        }
        berEncoder.endSeq();
        return berEncoder.getTrimmedBuf();
    }
}

