/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.component.WrapperEvent;
import com.sun.webui.jsf.util.MessageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class Form
extends UIForm {
    private VirtualFormDescriptor submittedVirtualForm;
    private static final String VF_DELIM_1 = ",";
    private static final String VF_DELIM_2 = "|";
    private static final String ID_SEP = String.valueOf(':');
    public static final char ID_WILD_CHAR = '*';
    private static final String ID_WILD = String.valueOf('*');
    private transient Map erasedMap = new HashMap();
    private transient Set nonDefaultRetainStatusEvhs = new HashSet();
    private static final boolean DEFAULT_RETAIN_STATUS = true;
    private boolean autoComplete = false;
    private boolean autoComplete_set = false;
    private String enctype = null;
    private VirtualFormDescriptor[] internalVirtualForms = null;
    private String onClick = null;
    private String onDblClick = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private String onReset = null;
    private String onSubmit = null;
    private String style = null;
    private String styleClass = null;
    private String target = null;
    private VirtualFormDescriptor[] virtualForms = null;
    private String virtualFormsConfig = null;
    private boolean visible = false;
    private boolean visible_set = false;

    public Form() {
        this.setRendererType("com.sun.webui.jsf.Form");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Form";
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.submittedVirtualForm = null;
        this.erasedMap.clear();
        this.decode(context);
        if (!this.isSubmitted()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
        if (this.submittedVirtualForm != null && !Form.childrenAreKnownToParticipate((UIComponent)this, this.submittedVirtualForm)) {
            this.eraseVirtualFormNonParticipants((UIComponent)this, null, null);
        }
    }

    public void queueEvent(FacesEvent event) {
        UIComponent sourceComp;
        VirtualFormDescriptor virtualFormComponentSubmits;
        FacesEvent relevantEvent = event;
        if (event instanceof WrapperEvent) {
            WrapperEvent wrapperEvent = (WrapperEvent)event;
            relevantEvent = wrapperEvent.getFacesEvent();
        }
        if (relevantEvent instanceof ActionEvent && this.submittedVirtualForm == null && (virtualFormComponentSubmits = this.getVirtualFormComponentSubmits(sourceComp = relevantEvent.getComponent())) != null) {
            this.submittedVirtualForm = virtualFormComponentSubmits;
        }
        super.queueEvent(event);
    }

    public void setSubmittedVirtualForm(VirtualFormDescriptor vfd) {
        if (this.submittedVirtualForm == null && vfd != null) {
            this.submittedVirtualForm = vfd;
        }
    }

    public void setVirtualForms(VirtualFormDescriptor[] vfds) {
        this.setVirtualForms(vfds, true);
    }

    private void setVirtualForms(VirtualFormDescriptor[] vfds, boolean sync) {
        this._setVirtualForms(vfds);
        if (sync) {
            String configStr = Form.generateVirtualFormsConfig(vfds);
            this.setVirtualFormsConfig(configStr, false);
        }
    }

    public void setVirtualFormsConfig(String configStr) {
        this.setVirtualFormsConfig(configStr, true);
    }

    private void setVirtualFormsConfig(String configStr, boolean sync) {
        this._setVirtualFormsConfig(configStr);
        if (sync) {
            VirtualFormDescriptor[] vfds = Form.generateVirtualForms(configStr);
            this.setVirtualForms(vfds, false);
        }
    }

    private VirtualFormDescriptor getVirtualFormComponentSubmitsByFullyQualifiedId(String fqId) {
        if (!Form.isValidFullyQualifiedId(fqId)) {
            return null;
        }
        VirtualFormDescriptor vfd = this.getVirtualFormComponentSubmitsByFullyQualifiedId(fqId, this.getVirtualForms());
        if (vfd != null) {
            return vfd;
        }
        vfd = this.getVirtualFormComponentSubmitsByFullyQualifiedId(fqId, this.getInternalVirtualForms());
        return vfd;
    }

    private VirtualFormDescriptor getVirtualFormComponentSubmitsByFullyQualifiedId(String fqId, VirtualFormDescriptor[] vfds) {
        if (vfds == null || vfds.length < 1) {
            return null;
        }
        String currentFqId = fqId;
        while (currentFqId.length() > 0) {
            for (int v = 0; v < vfds.length; ++v) {
                VirtualFormDescriptor vfd = vfds[v];
                String[] submitters = vfd.getSubmittingIds();
                for (int s = 0; submitters != null && s < submitters.length; ++s) {
                    boolean fqIdMatches;
                    String submitter = submitters[s];
                    if (submitter == null) continue;
                    String wildSuffix = ID_SEP + ID_WILD;
                    if (submitter.endsWith(wildSuffix)) {
                        submitter = submitter.substring(0, submitter.length() - wildSuffix.length());
                    }
                    if (submitter.length() < 1 || !(fqIdMatches = Form.fullyQualifiedIdMatchesPattern(currentFqId, submitter))) continue;
                    return vfd;
                }
            }
            int lastIndexOfSep = currentFqId.lastIndexOf(ID_SEP);
            currentFqId = currentFqId.substring(0, lastIndexOfSep);
        }
        return null;
    }

    private int getVirtualFormCount() {
        VirtualFormDescriptor[] vfds = this.getVirtualForms();
        VirtualFormDescriptor[] ivfds = this.getInternalVirtualForms();
        return (vfds == null ? 0 : vfds.length) + (ivfds == null ? 0 : ivfds.length);
    }

    private VirtualFormDescriptor getVirtualFormComponentSubmits(UIComponent component) {
        if (this.getVirtualFormCount() < 1) {
            return null;
        }
        String fqId = Form.getFullyQualifiedId(component);
        VirtualFormDescriptor vfd = this.getVirtualFormComponentSubmitsByFullyQualifiedId(fqId);
        return vfd;
    }

    public VirtualFormDescriptor getVirtualFormComponentSubmits(String id) {
        if (this.getVirtualFormCount() < 1) {
            return null;
        }
        if (Form.isValidFullyQualifiedId(id)) {
            return this.getVirtualFormComponentSubmitsByFullyQualifiedId(id);
        }
        UIComponent component = this.findComponentById(id);
        return this.getVirtualFormComponentSubmits(component);
    }

    public UIComponent findComponentById(String id) {
        if (id == null) {
            return null;
        }
        if (id.length() == 0 || id.endsWith(ID_WILD) || !id.equals(ID_SEP) && id.endsWith(ID_SEP)) {
            return null;
        }
        String fqId = Form.getFullyQualifiedId((UIComponent)this);
        if (Form.fullyQualifiedIdMatchesPattern(fqId, id)) {
            return this;
        }
        return this.searchKidsRecursivelyForId((UIComponent)this, id);
    }

    private UIComponent searchKidsRecursivelyForId(UIComponent parent, String id) {
        Iterator kids = parent.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            String fqId = Form.getFullyQualifiedId(kid);
            boolean fqIdMatches = Form.fullyQualifiedIdMatchesPattern(fqId, id);
            if (fqIdMatches) {
                return kid;
            }
            UIComponent match = this.searchKidsRecursivelyForId(kid, id);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private boolean participatesInSubmittedVirtualForm(UIComponent component) {
        if (this.submittedVirtualForm == null) {
            return false;
        }
        String fqId = Form.getFullyQualifiedId(component);
        return this.submittedVirtualForm.hasParticipant(fqId);
    }

    public static VirtualFormDescriptor[] generateVirtualForms(String configStr) {
        if (configStr == null) {
            return null;
        }
        if ((configStr = configStr.trim()).length() < 1) {
            return new VirtualFormDescriptor[0];
        }
        StringTokenizer st = new StringTokenizer(configStr, VF_DELIM_1);
        ArrayList<String> vfs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String vf = st.nextToken();
            if ((vf = vf.trim()).length() <= 0) continue;
            vfs.add(vf);
        }
        ArrayList<VirtualFormDescriptor> descriptors = new ArrayList<VirtualFormDescriptor>();
        for (int i = 0; i < vfs.size(); ++i) {
            String vf = (String)vfs.get(i);
            st = new StringTokenizer(vf, VF_DELIM_2);
            String[] parts = new String[3];
            for (int partIndex = 0; partIndex < parts.length && st.hasMoreTokens(); ++partIndex) {
                String part = st.nextToken();
                if ((part = part.trim()).length() <= 0) continue;
                parts[partIndex] = part;
            }
            if (parts[0] == null) continue;
            VirtualFormDescriptor vfd = new VirtualFormDescriptor();
            vfd.setName(parts[0]);
            descriptors.add(vfd);
            if (parts[1] != null) {
                String pidString = parts[1];
                st = new StringTokenizer(pidString);
                ArrayList<String> pidList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String pid = st.nextToken();
                    pidList.add(pid.trim());
                }
                String[] pids = pidList.toArray(new String[pidList.size()]);
                vfd.setParticipatingIds(pids);
            }
            if (parts[2] == null) continue;
            String sidString = parts[2];
            st = new StringTokenizer(sidString);
            ArrayList<String> sidList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String sid = st.nextToken();
                sidList.add(sid.trim());
            }
            String[] sids = sidList.toArray(new String[sidList.size()]);
            vfd.setSubmittingIds(sids);
        }
        return descriptors.toArray(new VirtualFormDescriptor[descriptors.size()]);
    }

    public static String generateVirtualFormsConfig(VirtualFormDescriptor[] descriptors) {
        if (descriptors == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < descriptors.length; ++i) {
            String vf;
            if (descriptors[i] == null || (vf = descriptors[i].toString()).length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            sb.append(vf);
        }
        return sb.toString();
    }

    public static String getFullyQualifiedId(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Form) {
            return ID_SEP;
        }
        String compId = component.getId();
        if (compId == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(compId);
        boolean formEncountered = false;
        for (UIComponent currentComp = component.getParent(); currentComp != null; currentComp = currentComp.getParent()) {
            sb.insert(0, ID_SEP);
            if (currentComp instanceof Form) {
                formEncountered = true;
                break;
            }
            String currentCompId = currentComp.getId();
            if (currentCompId == null) {
                return null;
            }
            sb.insert(0, currentCompId);
        }
        if (formEncountered) {
            return sb.toString();
        }
        return null;
    }

    public static boolean isValidFullyQualifiedId(String id) {
        return id != null && id.startsWith(ID_SEP) && (id.length() == 1 || !id.endsWith(ID_SEP)) && !id.endsWith(ID_WILD) && id.indexOf(32) == -1;
    }

    public static boolean fullyQualifiedIdMatchesPattern(String fqId, String pattern) {
        if (!Form.isValidFullyQualifiedId(fqId)) {
            return false;
        }
        if (pattern == null || pattern.length() < 1 || pattern.indexOf(32) != -1) {
            return false;
        }
        if (pattern.endsWith(ID_SEP) && !pattern.equals(ID_SEP)) {
            return false;
        }
        String wildSuffix = ID_SEP + ID_WILD;
        int indexOfWildInPattern = pattern.indexOf(ID_WILD);
        if (indexOfWildInPattern != -1) {
            if (indexOfWildInPattern != pattern.length() - 1) {
                return false;
            }
            if (!pattern.endsWith(wildSuffix)) {
                return false;
            }
        }
        if (pattern.equals(wildSuffix)) {
            return true;
        }
        if (pattern.endsWith(wildSuffix)) {
            String patternPrefix = pattern.substring(0, pattern.length() - wildSuffix.length());
            if (patternPrefix.startsWith(ID_SEP)) {
                return fqId.equals(patternPrefix) || fqId.startsWith(patternPrefix + ID_SEP);
            }
            return fqId.endsWith(ID_SEP + patternPrefix) || fqId.indexOf(ID_SEP + patternPrefix + ID_SEP) > -1;
        }
        if (pattern.startsWith(ID_SEP)) {
            return fqId.equals(pattern);
        }
        return fqId.endsWith(ID_SEP + pattern);
    }

    public void addInternalVirtualForm(VirtualFormDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        VirtualFormDescriptor[] oldDescriptors = this.getInternalVirtualForms();
        if (oldDescriptors != null) {
            for (int i = 0; i < oldDescriptors.length; ++i) {
                String name;
                if (oldDescriptors[i] == null || (name = oldDescriptors[i].getName()) == null || !name.equals(descriptor.getName())) continue;
                oldDescriptors[i] = descriptor;
                return;
            }
        }
        int oldLength = oldDescriptors != null ? oldDescriptors.length : 0;
        VirtualFormDescriptor[] newDescriptors = new VirtualFormDescriptor[oldLength + 1];
        for (int i = 0; i < oldLength; ++i) {
            newDescriptors[i] = oldDescriptors[i];
        }
        newDescriptors[oldLength] = descriptor;
        this.setInternalVirtualForms(newDescriptors);
    }

    private static boolean childrenAreKnownToParticipate(UIComponent component, VirtualFormDescriptor vfd) {
        if (vfd == null) {
            return false;
        }
        String fqId = Form.getFullyQualifiedId(component);
        if (fqId == null) {
            return false;
        }
        String[] participants = vfd.getParticipatingIds();
        for (int i = 0; participants != null && i < participants.length; ++i) {
            String participant = participants[i];
            String wildSuffix = ID_SEP + ID_WILD;
            if (participant == null || !participant.endsWith(wildSuffix) || !Form.fullyQualifiedIdMatchesPattern(fqId, participant)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eraseVirtualFormNonParticipants(UIComponent parent, Object[] contextualTables, Object[] contextualRows) {
        Map map = this.erasedMap;
        synchronized (map) {
            Iterator kids = parent.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (kid instanceof EditableValueHolder && !this.participatesInSubmittedVirtualForm(kid)) {
                    EditableValueHolder kidEvh = (EditableValueHolder)kid;
                    Object submittedValueToErase = kidEvh.getSubmittedValue();
                    if (contextualTables == null) {
                        this.erasedMap.put(kidEvh, submittedValueToErase);
                    } else {
                        this.addTableValuesEntry(this.erasedMap, kidEvh, 0, contextualTables, contextualRows, submittedValueToErase);
                    }
                    kidEvh.setSubmittedValue(null);
                }
                if (Form.childrenAreKnownToParticipate(kid, this.submittedVirtualForm)) continue;
                if (kid instanceof UIData) {
                    UIData kidTable = (UIData)kid;
                    int originalRowIndex = kidTable.getRowIndex();
                    int rowIndex = 0;
                    kidTable.setRowIndex(rowIndex);
                    while (kidTable.isRowAvailable()) {
                        Object[] localContextualTables = Form.appendToArray(contextualTables, kidTable);
                        Object[] localContextualRows = Form.appendToArray(contextualRows, new Integer(rowIndex));
                        this.eraseVirtualFormNonParticipants((UIComponent)kidTable, localContextualTables, localContextualRows);
                        kidTable.setRowIndex(++rowIndex);
                    }
                    kidTable.setRowIndex(originalRowIndex);
                    continue;
                }
                if (kid instanceof TableRowGroup) {
                    TableRowGroup group = (TableRowGroup)kid;
                    RowKey[] rowKeys = group.getRowKeys();
                    RowKey oldRowKey = group.getRowKey();
                    if (rowKeys != null) {
                        for (int i = 0; i < rowKeys.length; ++i) {
                            group.setRowKey(rowKeys[i]);
                            if (!group.isRowAvailable()) continue;
                            Object[] localContextualTables = Form.appendToArray(contextualTables, (Object)group);
                            Object[] localContextualRows = Form.appendToArray(contextualRows, rowKeys[i]);
                            this.eraseVirtualFormNonParticipants((UIComponent)group, localContextualTables, localContextualRows);
                        }
                    }
                    group.setRowKey(oldRowKey);
                    continue;
                }
                this.eraseVirtualFormNonParticipants(kid, contextualTables, contextualRows);
            }
        }
    }

    private void addTableValuesEntry(Map map, Object mapKey, int c, Object[] contextualTables, Object[] contextualRows, Object submittedValueToErase) {
        TableValues tv = (TableValues)map.get(mapKey);
        if (tv == null) {
            tv = new TableValues(contextualTables[c]);
            map.put(mapKey, tv);
        }
        Map values = tv.getValues();
        if (c == contextualTables.length - 1) {
            values.put(contextualRows[c], submittedValueToErase);
        } else {
            this.addTableValuesEntry(values, contextualRows[c], c + 1, contextualTables, contextualRows, submittedValueToErase);
        }
    }

    private static Object[] appendToArray(Object[] array, Object item) {
        Object[] result;
        if (array == null) {
            result = new Object[]{item};
        } else {
            result = new Object[array.length + 1];
            System.arraycopy(array, 0, result, 0, array.length);
            result[array.length] = item;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreNonParticipatingSubmittedValues() {
        Map map = this.erasedMap;
        synchronized (map) {
            for (Map.Entry entry : this.erasedMap.entrySet()) {
                EditableValueHolder evh = (EditableValueHolder)entry.getKey();
                boolean evhAppearsInSet = this.nonDefaultRetainStatusEvhs.contains(evh);
                boolean discards = evhAppearsInSet;
                if (discards) continue;
                Object erasedMapValue = entry.getValue();
                if (erasedMapValue instanceof TableValues) {
                    TableValues tv = (TableValues)erasedMapValue;
                    this.restoreTableValues(tv, evh);
                    continue;
                }
                evh.setSubmittedValue(erasedMapValue);
            }
            this.nonDefaultRetainStatusEvhs.clear();
        }
    }

    private void restoreTableValues(TableValues tv, EditableValueHolder evh) {
        TableRowGroup rowGroup;
        Iterator<Object> rowIterator;
        Object oldRow;
        UIData uidata;
        Object table = tv.getTable();
        Map values = tv.getValues();
        if (table instanceof UIData) {
            uidata = (UIData)table;
            int iOldRow = uidata.getRowIndex();
            oldRow = new Integer(iOldRow);
            ArrayList rowList = new ArrayList();
            rowList.addAll(values.keySet());
            Collections.sort(rowList);
            rowIterator = rowList.iterator();
        } else {
            rowGroup = (TableRowGroup)((Object)table);
            oldRow = rowGroup.getRowKey();
            rowIterator = values.keySet().iterator();
        }
        while (rowIterator.hasNext()) {
            Object row = rowIterator.next();
            if (table instanceof UIData) {
                UIData uidata2 = (UIData)table;
                Integer rowInt = (Integer)row;
                int iRow = rowInt;
                uidata2.setRowIndex(iRow);
            } else {
                TableRowGroup rowGroup2 = (TableRowGroup)((Object)table);
                RowKey rowKey = (RowKey)row;
                rowGroup2.setRowKey(rowKey);
            }
            Object rowValue = values.get(row);
            if (rowValue instanceof TableValues) {
                TableValues rowValueTv = (TableValues)rowValue;
                this.restoreTableValues(rowValueTv, evh);
                continue;
            }
            evh.setSubmittedValue(rowValue);
        }
        if (table instanceof UIData) {
            uidata = (UIData)table;
            Integer oldRowInt = (Integer)oldRow;
            int iOldRow = oldRowInt;
            uidata.setRowIndex(iOldRow);
        } else {
            rowGroup = (TableRowGroup)((Object)table);
            Object oldRowKey = oldRow;
            rowGroup.setRowKey((RowKey)oldRowKey);
        }
    }

    public void discardSubmittedValue(EditableValueHolder inputField) {
        UIComponent uicInputField;
        if (inputField == null) {
            throw new IllegalArgumentException(Form.getMessage("nullInputField", null));
        }
        if (inputField instanceof UIComponent && this.participatesInSubmittedVirtualForm(uicInputField = (UIComponent)inputField)) {
            throw new IllegalArgumentException(Form.getMessage("supplyNonParticipatingInputField", new Object[]{uicInputField.getId(), "discardSubmittedValue"}));
        }
        ArrayList<EditableValueHolder> evhCollection = new ArrayList<EditableValueHolder>();
        evhCollection.add(inputField);
        this.setRetainWhenNonParticipating(evhCollection, false);
    }

    public void discardSubmittedValues(String virtualFormName) {
        VirtualFormDescriptor vfd = this.getVirtualFormByName(virtualFormName);
        if (vfd == null) {
            throw new IllegalArgumentException(Form.getMessage("unrecognizedVfName", new Object[]{virtualFormName}));
        }
        if (vfd == this.submittedVirtualForm) {
            throw new IllegalArgumentException(Form.getMessage("supplyUnsubmittedVirtualForm", new Object[]{virtualFormName, "discardSubmittedValues"}));
        }
        this.setRetainWhenNonParticipating(vfd, false);
    }

    private void setRetainWhenNonParticipating(VirtualFormDescriptor vfd, boolean retain) {
        String[] pids = vfd.getParticipatingIds();
        if (pids == null || pids.length < 1) {
            return;
        }
        ArrayList<UIComponent> evhList = new ArrayList<UIComponent>();
        for (int i = 0; i < pids.length; ++i) {
            UIComponent uic = this.findComponentById(pids[i]);
            if (!(uic instanceof EditableValueHolder)) continue;
            evhList.add(uic);
        }
        this.setRetainWhenNonParticipating(evhList, retain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRetainWhenNonParticipating(Collection evhs, boolean retain) {
        if (evhs == null || evhs.size() < 1) {
            return;
        }
        Map map = this.erasedMap;
        synchronized (map) {
            boolean shouldContain;
            boolean bl = shouldContain = !retain;
            if (shouldContain) {
                this.nonDefaultRetainStatusEvhs.addAll(evhs);
            } else {
                this.nonDefaultRetainStatusEvhs.removeAll(evhs);
            }
        }
    }

    private VirtualFormDescriptor getVirtualFormByName(String virtualFormName) {
        if (virtualFormName == null) {
            return null;
        }
        VirtualFormDescriptor[] vfds = this.getVirtualForms();
        for (int i = 0; vfds != null && i < vfds.length; ++i) {
            if (!virtualFormName.equals(vfds[i].getName())) continue;
            return vfds[i];
        }
        return null;
    }

    private static String getMessage(String key, Object[] args) {
        String baseName = Form.class.getPackage().getName() + ".Bundle";
        return MessageUtil.getMessage(FacesContext.getCurrentInstance(), baseName, key, args);
    }

    public String getEnctype() {
        String encType = this._getEnctype();
        if (encType == null || encType.length() == 0) {
            encType = "application/x-www-form-urlencoded";
            this.setEnctype(encType);
        }
        return encType;
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public boolean isAutoComplete() {
        if (this.autoComplete_set) {
            return this.autoComplete;
        }
        ValueExpression _vb = this.getValueExpression("autoComplete");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
        this.autoComplete_set = true;
    }

    private String _getEnctype() {
        if (this.enctype != null) {
            return this.enctype;
        }
        ValueExpression _vb = this.getValueExpression("enctype");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return "application/x-www-form-urlencoded";
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public VirtualFormDescriptor[] getInternalVirtualForms() {
        if (this.internalVirtualForms != null) {
            return this.internalVirtualForms;
        }
        ValueExpression _vb = this.getValueExpression("internalVirtualForms");
        if (_vb != null) {
            return (VirtualFormDescriptor[])_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setInternalVirtualForms(VirtualFormDescriptor[] internalVirtualForms) {
        this.internalVirtualForms = internalVirtualForms;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression _vb = this.getValueExpression("onClick");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression _vb = this.getValueExpression("onDblClick");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnDblClick(String onDblClick) {
        this.onDblClick = onDblClick;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression _vb = this.getValueExpression("onKeyDown");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String onKeyDown) {
        this.onKeyDown = onKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression _vb = this.getValueExpression("onKeyPress");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String onKeyPress) {
        this.onKeyPress = onKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression _vb = this.getValueExpression("onKeyUp");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String onKeyUp) {
        this.onKeyUp = onKeyUp;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression _vb = this.getValueExpression("onMouseDown");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String onMouseDown) {
        this.onMouseDown = onMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression _vb = this.getValueExpression("onMouseMove");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String onMouseMove) {
        this.onMouseMove = onMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression _vb = this.getValueExpression("onMouseOut");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String onMouseOut) {
        this.onMouseOut = onMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression _vb = this.getValueExpression("onMouseOver");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String onMouseOver) {
        this.onMouseOver = onMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression _vb = this.getValueExpression("onMouseUp");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String onMouseUp) {
        this.onMouseUp = onMouseUp;
    }

    public String getOnReset() {
        if (this.onReset != null) {
            return this.onReset;
        }
        ValueExpression _vb = this.getValueExpression("onReset");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnReset(String onReset) {
        this.onReset = onReset;
    }

    public String getOnSubmit() {
        if (this.onSubmit != null) {
            return this.onSubmit;
        }
        ValueExpression _vb = this.getValueExpression("onSubmit");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnSubmit(String onSubmit) {
        this.onSubmit = onSubmit;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression _vb = this.getValueExpression("style");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression _vb = this.getValueExpression("styleClass");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        ValueExpression _vb = this.getValueExpression("target");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public VirtualFormDescriptor[] getVirtualForms() {
        if (this.virtualForms != null) {
            return this.virtualForms;
        }
        ValueExpression _vb = this.getValueExpression("virtualForms");
        if (_vb != null) {
            return (VirtualFormDescriptor[])_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void _setVirtualForms(VirtualFormDescriptor[] virtualForms) {
        this.virtualForms = virtualForms;
    }

    public String getVirtualFormsConfig() {
        if (this.virtualFormsConfig != null) {
            return this.virtualFormsConfig;
        }
        ValueExpression _vb = this.getValueExpression("virtualFormsConfig");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void _setVirtualFormsConfig(String virtualFormsConfig) {
        this.virtualFormsConfig = virtualFormsConfig;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.autoComplete = (Boolean)_values[1];
        this.autoComplete_set = (Boolean)_values[2];
        this.enctype = (String)_values[3];
        this.internalVirtualForms = (VirtualFormDescriptor[])_values[4];
        this.onClick = (String)_values[5];
        this.onDblClick = (String)_values[6];
        this.onKeyDown = (String)_values[7];
        this.onKeyPress = (String)_values[8];
        this.onKeyUp = (String)_values[9];
        this.onMouseDown = (String)_values[10];
        this.onMouseMove = (String)_values[11];
        this.onMouseOut = (String)_values[12];
        this.onMouseOver = (String)_values[13];
        this.onMouseUp = (String)_values[14];
        this.onReset = (String)_values[15];
        this.onSubmit = (String)_values[16];
        this.style = (String)_values[17];
        this.styleClass = (String)_values[18];
        this.target = (String)_values[19];
        this.virtualForms = (VirtualFormDescriptor[])_values[20];
        this.virtualFormsConfig = (String)_values[21];
        this.visible = (Boolean)_values[22];
        this.visible_set = (Boolean)_values[23];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.autoComplete ? Boolean.TRUE : Boolean.FALSE, this.autoComplete_set ? Boolean.TRUE : Boolean.FALSE, this.enctype, this.internalVirtualForms, this.onClick, this.onDblClick, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.onReset, this.onSubmit, this.style, this.styleClass, this.target, this.virtualForms, this.virtualFormsConfig, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }

    private class TableValues {
        private Object table;
        private Map values;

        public TableValues(Object table) {
            this.table = table;
            this.values = new HashMap();
        }

        public Object getTable() {
            return this.table;
        }

        public Map getValues() {
            return this.values;
        }
    }

    public static class VirtualFormDescriptor
    implements Serializable {
        private static final long serialVersionUID = 7348674581125090187L;
        private String name;
        private String[] participatingIds;
        private String[] submittingIds;

        public VirtualFormDescriptor() {
        }

        public VirtualFormDescriptor(String name) {
            this.setName(name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException(Form.getMessage("nullVfName", null));
            }
            if ((name = name.trim()).length() < 1) {
                throw new IllegalArgumentException(Form.getMessage("vfNameWhitespaceOnly", null));
            }
            this.name = name;
        }

        public String[] getParticipatingIds() {
            return this.participatingIds;
        }

        public void setParticipatingIds(String[] participatingIds) {
            for (int i = 0; participatingIds != null && i < participatingIds.length; ++i) {
                if (participatingIds[i] == null) {
                    throw new IllegalArgumentException(Form.getMessage("nullParticipatingIdAtIndex", new Object[]{new Integer(i)}));
                }
                participatingIds[i] = participatingIds[i].trim();
                if (participatingIds[i].length() >= 1) continue;
                throw new IllegalArgumentException(Form.getMessage("whitespaceOnlyParticipatingIdAtIndex", new Object[]{new Integer(i)}));
            }
            this.participatingIds = participatingIds;
        }

        public String[] getSubmittingIds() {
            return this.submittingIds;
        }

        public void setSubmittingIds(String[] submittingIds) {
            for (int i = 0; submittingIds != null && i < submittingIds.length; ++i) {
                if (submittingIds[i] == null) {
                    throw new IllegalArgumentException(Form.getMessage("nullSubmittingIdAtIndex", new Object[]{new Integer(i)}));
                }
                submittingIds[i] = submittingIds[i].trim();
                if (submittingIds[i].length() >= 1) continue;
                throw new IllegalArgumentException(Form.getMessage("whitespaceOnlySubmittingIdAtIndex", new Object[]{new Integer(i)}));
            }
            this.submittingIds = submittingIds;
        }

        public boolean isSubmittedBy(String fqId) {
            if (!Form.isValidFullyQualifiedId(fqId)) {
                return false;
            }
            for (int i = 0; this.submittingIds != null && i < this.submittingIds.length; ++i) {
                if (!Form.fullyQualifiedIdMatchesPattern(fqId, this.submittingIds[i])) continue;
                return true;
            }
            return false;
        }

        public boolean hasParticipant(String fqId) {
            if (!Form.isValidFullyQualifiedId(fqId)) {
                return false;
            }
            for (int i = 0; this.participatingIds != null && i < this.participatingIds.length; ++i) {
                if (!Form.fullyQualifiedIdMatchesPattern(fqId, this.participatingIds[i])) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            int i;
            if (this.name == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.name);
            sb.append(" | ");
            for (i = 0; this.participatingIds != null && i < this.participatingIds.length; ++i) {
                sb.append(this.participatingIds[i]);
                sb.append(' ');
            }
            sb.append("| ");
            for (i = 0; this.submittingIds != null && i < this.submittingIds.length; ++i) {
                sb.append(this.submittingIds[i]);
                sb.append(' ');
            }
            return sb.toString().trim();
        }
    }
}

