/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=ConnectionFactoryDefinitionDescriptor.class)
public class ConnectionFactoryDefinitionDeployer
implements ResourceDeployer {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    private static Logger _logger = LogDomains.getLogger(ConnectionFactoryDefinitionDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    static final String PROPERTY_PREFIX = "org.glassfish.connector-connection-pool.";

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(Object resource) throws Exception {
        ConnectionFactoryDefinitionDescriptor desc = (ConnectionFactoryDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)JavaEEResourceType.CFDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectionFactoryDefinitionDeployer.deployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(desc, poolName);
        this.getDeployer(connectorCp).deployResource((Object)connectorCp);
        MyConnectorResource connectorResource = new MyConnectorResource(poolName, resourceName);
        this.getDeployer(connectorResource).deployResource((Object)connectorResource);
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    private ConnectionFactoryProperty convertProperty(String name, String value) {
        return new ConnectionFactoryProperty(name, value);
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void undeployResource(Object resource) throws Exception {
        ConnectionFactoryDefinitionDescriptor desc = (ConnectionFactoryDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)JavaEEResourceType.CFDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectionFactoryDefinitionDeployer.undeployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyConnectorResource connectorResource = new MyConnectorResource(poolName, resourceName);
        this.getDeployer(connectorResource).undeployResource((Object)connectorResource);
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(desc, poolName);
        this.getDeployer(connectorCp).undeployResource((Object)connectorCp);
    }

    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for connection-factory-definition type");
    }

    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for connection-factory-definition type");
    }

    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for connection-factory-definition type");
    }

    public boolean handles(Object resource) {
        return resource instanceof ConnectionFactoryDefinitionDescriptor;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    class ConnectionFactoryProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        ConnectionFactoryProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }

    class MyConnectorConnectionPool
    extends FakeConfigBean
    implements ConnectorConnectionPool {
        private ConnectionFactoryDefinitionDescriptor desc;
        private String name;

        public MyConnectorConnectionPool(ConnectionFactoryDefinitionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        public String getObjectType() {
            return "user";
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.name;
        }

        public String getSteadyPoolSize() {
            int minPoolSize = this.desc.getMinPoolSize();
            if (minPoolSize >= 0) {
                return Integer.toString(minPoolSize);
            }
            return "8";
        }

        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxPoolSize() {
            int maxPoolSize = this.desc.getMaxPoolSize();
            if (maxPoolSize >= 0) {
                return Integer.toString(maxPoolSize);
            }
            return "32";
        }

        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxWaitTimeInMillis() {
            String maxWaitTimeInMillis = this.desc.getProperty("org.glassfish.connector-connection-pool.max-wait-time-in-millis");
            if (maxWaitTimeInMillis != null && !maxWaitTimeInMillis.equals("")) {
                return maxWaitTimeInMillis;
            }
            return "60000";
        }

        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        public String getPoolResizeQuantity() {
            String poolResizeQuantity = this.desc.getProperty("org.glassfish.connector-connection-pool.pool-resize-quantity");
            if (poolResizeQuantity != null && !poolResizeQuantity.equals("")) {
                return poolResizeQuantity;
            }
            return "2";
        }

        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        public String getIdleTimeoutInSeconds() {
            String idleTimeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.idle-timeout-in-seconds");
            if (idleTimeoutInSeconds != null && !idleTimeoutInSeconds.equals("")) {
                return idleTimeoutInSeconds;
            }
            return "300";
        }

        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getIsConnectionValidationRequired() {
            String isConnectionValidationRequired = this.desc.getProperty("org.glassfish.connector-connection-pool.is-connection-validation-required");
            if (isConnectionValidationRequired != null && !isConnectionValidationRequired.equals("")) {
                return isConnectionValidationRequired;
            }
            return "false";
        }

        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        public String getResourceAdapterName() {
            return this.desc.getResourceAdapter();
        }

        public void setResourceAdapterName(String value) throws PropertyVetoException {
        }

        public String getConnectionDefinitionName() {
            return this.desc.getInterfaceName();
        }

        public void setConnectionDefinitionName(String value) throws PropertyVetoException {
        }

        public String getFailAllConnections() {
            String failAllConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.fail-all-connections");
            if (failAllConnections != null && !failAllConnections.equals("")) {
                return failAllConnections;
            }
            return "false";
        }

        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        public String getTransactionSupport() {
            return this.desc.getTransactionSupport();
        }

        public void setTransactionSupport(String value) throws PropertyVetoException {
        }

        public String getValidateAtmostOncePeriodInSeconds() {
            String validateAtmostOncePeriodInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.validate-at-most-once-period-in-seconds");
            if (validateAtmostOncePeriodInSeconds != null && !validateAtmostOncePeriodInSeconds.equals("")) {
                return validateAtmostOncePeriodInSeconds;
            }
            return "0";
        }

        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakTimeoutInSeconds() {
            String connectionLeakTimeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-timeout-in-seconds");
            if (connectionLeakTimeoutInSeconds != null && !connectionLeakTimeoutInSeconds.equals("")) {
                return connectionLeakTimeoutInSeconds;
            }
            return "0";
        }

        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakReclaim() {
            String connectionLeakReclaim = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-reclaim");
            if (connectionLeakReclaim != null && !connectionLeakReclaim.equals("")) {
                return connectionLeakReclaim;
            }
            return "0";
        }

        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryAttempts() {
            String connectionCreationRetryAttempts = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-attempts");
            if (connectionCreationRetryAttempts != null && !connectionCreationRetryAttempts.equals("")) {
                return connectionCreationRetryAttempts;
            }
            return "0";
        }

        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryIntervalInSeconds() {
            String connectionCreationRetryIntervalInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-interval-in-seconds");
            if (connectionCreationRetryIntervalInSeconds != null && !connectionCreationRetryIntervalInSeconds.equals("")) {
                return connectionCreationRetryIntervalInSeconds;
            }
            return "0";
        }

        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionEnlistment() {
            String lazyConnectionEnlistment = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-enlistment");
            if (lazyConnectionEnlistment != null && !lazyConnectionEnlistment.equals("")) {
                return lazyConnectionEnlistment;
            }
            return "false";
        }

        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionAssociation() {
            String lazyConnectionAssociation = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-association");
            if (lazyConnectionAssociation != null && !lazyConnectionAssociation.equals("")) {
                return lazyConnectionAssociation;
            }
            return "false";
        }

        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        public String getAssociateWithThread() {
            String associateWithThread = this.desc.getProperty("org.glassfish.connector-connection-pool.associate-with-thread");
            if (associateWithThread != null && !associateWithThread.equals("")) {
                return associateWithThread;
            }
            return "false";
        }

        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        public String getPooling() {
            String pooling = this.desc.getProperty("org.glassfish.connector-connection-pool.pooling");
            if (pooling != null && !pooling.equals("")) {
                return pooling;
            }
            return "true";
        }

        public void setPooling(String value) throws PropertyVetoException {
        }

        public String getMatchConnections() {
            String matchConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.match-connections");
            if (matchConnections != null && !matchConnections.equals("")) {
                return matchConnections;
            }
            return "true";
        }

        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        public String getMaxConnectionUsageCount() {
            String maxConnectionUsageCount = this.desc.getProperty("org.glassfish.connector-connection-pool.max-connection-usage-count");
            if (maxConnectionUsageCount != null && !maxConnectionUsageCount.equals("")) {
                return maxConnectionUsageCount;
            }
            return "0";
        }

        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> connectionFactoryProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(ConnectionFactoryDefinitionDeployer.PROPERTY_PREFIX)) continue;
                String value = (String)entry.getValue();
                ConnectionFactoryProperty dp = ConnectionFactoryDefinitionDeployer.this.convertProperty(key, value);
                connectionFactoryProperties.add(dp);
            }
            return connectionFactoryProperties;
        }

        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new ConnectionFactoryProperty(name, value);
        }

        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String value = null;
            value = this.desc.getProperty(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
        }

        public String getPing() {
            String ping = this.desc.getProperty("org.glassfish.connector-connection-pool.ping");
            if (ping != null && !ping.equals("")) {
                return ping;
            }
            return "false";
        }

        public void setPing(String value) throws PropertyVetoException {
        }

        public List<SecurityMap> getSecurityMap() {
            return new ArrayList<SecurityMap>(0);
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }
    }

    class MyConnectorResource
    extends FakeConfigBean
    implements ConnectorResource {
        private String poolName;
        private String jndiName;

        MyConnectorResource(String poolName, String jndiName) {
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = value;
        }

        public String getObjectType() {
            return null;
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.jndiName;
        }

        public String getEnabled() {
            return String.valueOf(true);
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            return null;
        }

        public Property getProperty(String name) {
            return null;
        }

        public String getPropertyValue(String name) {
            return null;
        }

        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = value;
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }
    }
}

