/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.DynamicConfigurationListener;
import org.glassfish.hk2.api.ErrorInformation;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.ErrorType;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.Immediate;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Operation;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ValidationInformation;
import org.glassfish.hk2.api.ValidationService;
import org.glassfish.hk2.api.Validator;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.utilities.ImmediateErrorHandler;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class ImmediateHelper
implements DynamicConfigurationListener,
Runnable,
ValidationService,
ErrorService,
Validator {
    private static final ThreadFactory THREAD_FACTORY = new ImmediateThreadFactory();
    private static final Executor DEFAULT_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), THREAD_FACTORY);
    private final Filter validationFilter;
    private final ServiceLocator locator;
    private final HashMap<ActiveDescriptor<?>, HandleAndService> currentImmediateServices = new HashMap();
    private final HashSet<ActiveDescriptor<?>> creating = new HashSet();
    private final HashSet<Long> tidsWithWork = new HashSet();
    private final Object queueLock = new Object();
    private boolean threadAvailable;
    private boolean outstandingJob;
    private boolean waitingForWork;
    private boolean firstTime = true;

    @Inject
    private ImmediateHelper(ServiceLocator serviceLocator) {
        this.locator = serviceLocator;
        this.validationFilter = new ImmediateLocalLocatorFilter(serviceLocator.getLocatorId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        U retVal = null;
        ImmediateHelper immediateHelper = this;
        synchronized (immediateHelper) {
            HandleAndService has = this.currentImmediateServices.get(activeDescriptor);
            if (has != null) {
                return (U)has.getService();
            }
            while (this.creating.contains(activeDescriptor)) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new MultiException(ie);
                }
            }
            has = this.currentImmediateServices.get(activeDescriptor);
            if (has != null) {
                return (U)has.getService();
            }
            this.creating.add(activeDescriptor);
        }
        try {
            retVal = activeDescriptor.create(root);
        }
        finally {
            immediateHelper = this;
            synchronized (immediateHelper) {
                ServiceHandle<?> discoveredRoot = null;
                if (root != null && root.getActiveDescriptor().equals(activeDescriptor)) {
                    discoveredRoot = root;
                }
                if (retVal != null) {
                    this.currentImmediateServices.put(activeDescriptor, new HandleAndService(discoveredRoot, retVal));
                }
                this.creating.remove(activeDescriptor);
                this.notifyAll();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        ImmediateHelper immediateHelper = this;
        synchronized (immediateHelper) {
            return this.currentImmediateServices.containsKey(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasWork() {
        long tid = Thread.currentThread().getId();
        ImmediateHelper immediateHelper = this;
        synchronized (immediateHelper) {
            boolean wasFirst = this.firstTime;
            this.firstTime = false;
            boolean retVal = this.tidsWithWork.contains(tid);
            this.tidsWithWork.remove(tid);
            if (retVal || !wasFirst) {
                return retVal;
            }
        }
        List<ActiveDescriptor<?>> immediates = this.getImmediateServices();
        return !immediates.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationChanged() {
        if (!this.hasWork()) {
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            this.outstandingJob = true;
            if (!this.threadAvailable) {
                this.threadAvailable = true;
                DEFAULT_EXECUTOR.execute(this);
            } else if (this.waitingForWork) {
                this.queueLock.notify();
            }
        }
    }

    @Override
    public Filter getLookupFilter() {
        return this.validationFilter;
    }

    @Override
    public Validator getValidator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(ErrorInformation errorInformation) throws MultiException {
        if (!ErrorType.DYNAMIC_CONFIGURATION_FAILURE.equals((Object)errorInformation.getErrorType())) {
            long tid = Thread.currentThread().getId();
            ImmediateHelper immediateHelper = this;
            synchronized (immediateHelper) {
                this.tidsWithWork.remove(tid);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(ValidationInformation info) {
        if (info.getOperation().equals((Object)Operation.BIND) || info.getOperation().equals((Object)Operation.UNBIND)) {
            long tid = Thread.currentThread().getId();
            ImmediateHelper immediateHelper = this;
            synchronized (immediateHelper) {
                this.tidsWithWork.add(tid);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object = this.queueLock;
            synchronized (object) {
                long elapsedTime;
                for (long decayTime = 20000L; !this.outstandingJob && decayTime > 0L; decayTime -= elapsedTime) {
                    this.waitingForWork = true;
                    long currentTime = System.currentTimeMillis();
                    try {
                        this.queueLock.wait(decayTime);
                    }
                    catch (InterruptedException ie) {
                        this.threadAvailable = false;
                        this.waitingForWork = false;
                        return;
                    }
                    elapsedTime = System.currentTimeMillis() - currentTime;
                }
                this.waitingForWork = false;
                if (!this.outstandingJob) {
                    this.threadAvailable = false;
                    return;
                }
                this.outstandingJob = false;
            }
            this.doWork();
        }
    }

    private List<ActiveDescriptor<?>> getImmediateServices() {
        List<ActiveDescriptor<?>> inScopeAndInThisLocator = this.locator.getDescriptors(this.validationFilter);
        return inScopeAndInThisLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyOne(ActiveDescriptor<?> descriptor, List<ImmediateErrorHandler> errorHandlers) {
        if (errorHandlers == null) {
            errorHandlers = this.locator.getAllServices(ImmediateErrorHandler.class, new Annotation[0]);
        }
        ImmediateHelper immediateHelper = this;
        synchronized (immediateHelper) {
            HandleAndService has = this.currentImmediateServices.remove(descriptor);
            Object instance = has.getService();
            try {
                descriptor.dispose(instance);
            }
            catch (Throwable th) {
                for (ImmediateErrorHandler ieh : errorHandlers) {
                    try {
                        ieh.preDestroyFailed(descriptor, th);
                    }
                    catch (Throwable th2) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<ImmediateErrorHandler> errorHandlers = this.locator.getAllServices(ImmediateErrorHandler.class, new Annotation[0]);
        ImmediateHelper immediateHelper = this;
        synchronized (immediateHelper) {
            for (Map.Entry<ActiveDescriptor<?>, HandleAndService> entry : new HashSet(this.currentImmediateServices.entrySet())) {
                HandleAndService has = entry.getValue();
                ServiceHandle handle = has.getHandle();
                if (handle != null) {
                    handle.destroy();
                    continue;
                }
                this.destroyOne(entry.getKey(), errorHandlers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        List<ActiveDescriptor<?>> inScopeAndInThisLocator = this.getImmediateServices();
        List<ImmediateErrorHandler> errorHandlers = this.locator.getAllServices(ImmediateErrorHandler.class, new Annotation[0]);
        HashSet newFullSet = new HashSet(inScopeAndInThisLocator);
        HashSet addMe = new HashSet();
        ImmediateHelper immediateHelper = this;
        synchronized (immediateHelper) {
            while (this.creating.size() > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            HashSet oldSet = new HashSet(this.currentImmediateServices.keySet());
            for (ActiveDescriptor<?> activeDescriptor : inScopeAndInThisLocator) {
                if (oldSet.contains(activeDescriptor)) continue;
                addMe.add(activeDescriptor);
            }
            oldSet.removeAll(newFullSet);
            for (ActiveDescriptor<?> activeDescriptor : oldSet) {
                HandleAndService has = this.currentImmediateServices.get(activeDescriptor);
                ServiceHandle handle = has.getHandle();
                if (handle != null) {
                    handle.destroy();
                    continue;
                }
                this.destroyOne(activeDescriptor, errorHandlers);
            }
        }
        for (ActiveDescriptor activeDescriptor : addMe) {
            try {
                this.locator.getServiceHandle(activeDescriptor).getService();
            }
            catch (Throwable throwable) {
                for (ImmediateErrorHandler ieh : errorHandlers) {
                    try {
                        ieh.postConstructFailed(activeDescriptor, throwable);
                    }
                    catch (Throwable th2) {}
                }
            }
        }
    }

    private static class HandleAndService {
        private final ServiceHandle<?> handle;
        private final Object service;

        private HandleAndService(ServiceHandle<?> handle, Object service) {
            this.handle = handle;
            this.service = service;
        }

        private ServiceHandle<?> getHandle() {
            return this.handle;
        }

        private Object getService() {
            return this.service;
        }
    }

    private static class ImmediateLocalLocatorFilter
    implements Filter {
        private final long locatorId;

        private ImmediateLocalLocatorFilter(long locatorId) {
            this.locatorId = locatorId;
        }

        @Override
        public boolean matches(Descriptor d) {
            String scope = d.getScope();
            if (scope == null) {
                return false;
            }
            if (d.getLocatorId() != this.locatorId) {
                return false;
            }
            return Immediate.class.getName().equals(scope);
        }
    }

    private static class ImmediateThread
    extends Thread {
        private ImmediateThread(Runnable r) {
            super(r);
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName() + "-" + System.currentTimeMillis());
        }
    }

    private static class ImmediateThreadFactory
    implements ThreadFactory {
        private ImmediateThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            ImmediateThread activeThread = new ImmediateThread(runnable);
            return activeThread;
        }
    }
}

