/*
 * Decompiled with CFR 0.152.
 */
package rpc.pdu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.util.Hexdump;
import ndr.NetworkDataRepresentation;
import rpc.ConnectionOrientedPdu;
import rpc.Fragmentable;

public class ResponseCoPdu
extends ConnectionOrientedPdu
implements Fragmentable {
    public static final int RESPONSE_TYPE = 2;
    private byte[] stub;
    private int allocationHint = 0;
    private int contextId = 0;
    private int cancelCount = 0;
    private static final Logger logger = Logger.getLogger("org.jinterop");

    public int getType() {
        return 2;
    }

    public byte[] getStub() {
        return this.stub;
    }

    public void setStub(byte[] stub) {
        this.stub = stub;
    }

    public int getAllocationHint() {
        return this.allocationHint;
    }

    public void setAllocationHint(int allocationHint) {
        this.allocationHint = allocationHint;
    }

    public int getContextId() {
        return this.contextId;
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    public int getCancelCount() {
        return this.cancelCount;
    }

    public void setCancelCount(int cancelCount) {
        this.cancelCount = cancelCount;
    }

    protected void readPdu(NetworkDataRepresentation ndr) {
        this.readHeader(ndr);
        this.readBody(ndr);
        this.readStub(ndr);
    }

    protected void writePdu(NetworkDataRepresentation ndr) {
        this.writeHeader(ndr);
        this.writeBody(ndr);
        this.writeStub(ndr);
    }

    protected void readBody(NetworkDataRepresentation ndr) {
        this.setAllocationHint(ndr.readUnsignedLong());
        this.setContextId(ndr.readUnsignedShort());
        this.setCancelCount(ndr.readUnsignedSmall());
    }

    protected void writeBody(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedLong(this.getAllocationHint());
        ndr.writeUnsignedShort(this.getContextId());
        ndr.writeUnsignedSmall((short)this.getCancelCount());
    }

    protected void readStub(NetworkDataRepresentation ndr) {
        ndr.getBuffer().align(8);
        byte[] stub = null;
        int length = this.getFragmentLength() - ndr.getBuffer().getIndex();
        if (length > 0) {
            stub = new byte[length];
            ndr.readOctetArray(stub, 0, length);
        }
        this.setStub(stub);
    }

    protected void writeStub(NetworkDataRepresentation ndr) {
        ndr.getBuffer().align(8, (byte)0);
        byte[] stub = this.getStub();
        if (stub != null) {
            ndr.writeOctetArray(stub, 0, stub.length);
        }
    }

    public Iterator fragment(int size) {
        byte[] stub = this.getStub();
        if (stub == null) {
            return Arrays.asList(this).iterator();
        }
        int stubSize = size - 24 - 8 - 16;
        if (stub.length <= stubSize) {
            return Arrays.asList(this).iterator();
        }
        return new FragmentIterator(stubSize);
    }

    public Fragmentable assemble(Iterator fragments) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[DURING RECIEVE IN ASSEMBLE]\n");
        }
        if (!fragments.hasNext()) {
            throw new IOException("No fragments available.");
        }
        try {
            ResponseCoPdu pdu = (ResponseCoPdu)fragments.next();
            byte[] stub = pdu.getStub();
            if (stub == null) {
                stub = new byte[]{};
            }
            int i = 0;
            while (fragments.hasNext()) {
                ResponseCoPdu fragment;
                byte[] fragmentStub;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[IN ASSEMBLE] Fragment { " + i + " }\n");
                }
                if ((fragmentStub = (fragment = (ResponseCoPdu)fragments.next()).getStub()) == null || fragmentStub.length <= 0) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[FRAGMENT'S STUB (new one)] Length is = " + fragmentStub.length);
                }
                byte[] tmp = new byte[stub.length + fragmentStub.length];
                System.arraycopy(stub, 0, tmp, 0, stub.length);
                System.arraycopy(fragmentStub, 0, tmp, stub.length, fragmentStub.length);
                stub = tmp;
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("[ADDED THIS STUB (previous stub + new one) into OLD STUB] Current Length of pieces assembled so far = " + stub.length);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump(new PrintStream(byteArrayOutputStream), stub, 0, stub.length);
                logger.finest("\n" + byteArrayOutputStream.toString());
            }
            int length = stub.length;
            if (length > 0) {
                pdu.setStub(stub);
                pdu.setAllocationHint(length);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[FULL AND FINAL STUB AFTER ASSEMBLY]\n");
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Hexdump.hexdump(new PrintStream(byteArrayOutputStream), stub, 0, stub.length);
                    logger.finest("\n" + byteArrayOutputStream.toString());
                }
            } else {
                pdu.setStub(null);
                pdu.setAllocationHint(0);
            }
            pdu.setFlag(1, true);
            pdu.setFlag(2, true);
            return pdu;
        }
        catch (Exception ex) {
            throw new IOException("Unable to assemble PDU fragments.");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }

    private class FragmentIterator
    implements Iterator {
        private int stubSize;
        private int index = 0;

        public FragmentIterator(int stubSize) {
            this.stubSize = stubSize;
        }

        public boolean hasNext() {
            return this.index < ResponseCoPdu.this.stub.length;
        }

        public Object next() {
            if (this.index >= ResponseCoPdu.this.stub.length) {
                throw new NoSuchElementException();
            }
            ResponseCoPdu fragment = (ResponseCoPdu)ResponseCoPdu.this.clone();
            int allocation = ResponseCoPdu.this.stub.length - this.index;
            fragment.setAllocationHint(allocation);
            if (this.stubSize < allocation) {
                allocation = this.stubSize;
            }
            byte[] fragmentStub = new byte[allocation];
            System.arraycopy(ResponseCoPdu.this.stub, this.index, fragmentStub, 0, allocation);
            fragment.setStub(fragmentStub);
            int flags = ResponseCoPdu.this.getFlags() & 0xFFFFFFFC;
            if (this.index == 0) {
                flags |= 1;
            }
            this.index += allocation;
            if (this.index >= ResponseCoPdu.this.stub.length) {
                flags |= 2;
            }
            fragment.setFlags(flags);
            return fragment;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

