/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.mgmt.transport.AbstractMultiMessageSender;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class GrizzlyUDPConnectorWrapper
extends AbstractMultiMessageSender {
    private final Controller controller;
    private final long writeTimeout;
    private final InetSocketAddress localSocketAddress;
    private final InetSocketAddress multicastSocketAddress;
    private static final String DEFAULT_MULTICAST_ADDRESS = "230.30.1.1";

    public GrizzlyUDPConnectorWrapper(Controller controller, long writeTimeout, String host, int port, String multicastAddress, PeerID<GrizzlyPeerID> localPeerID) {
        this.controller = controller;
        this.writeTimeout = writeTimeout;
        this.localSocketAddress = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        this.multicastSocketAddress = new InetSocketAddress(multicastAddress == null ? DEFAULT_MULTICAST_ADDRESS : multicastAddress, port);
        this.localPeerID = localPeerID;
    }

    @Override
    protected boolean doSend(PeerID peerID, Message message) throws IOException {
        if (peerID == null) {
            throw new IOException("peer ID can not be null");
        }
        Object uniqueID = peerID.getUniqueID();
        if (!(uniqueID instanceof GrizzlyPeerID)) {
            throw new IOException("peer ID must be GrizzlyPeerID type");
        }
        GrizzlyPeerID grizzlyPeerID = (GrizzlyPeerID)uniqueID;
        InetSocketAddress remoteSocketAddress = new InetSocketAddress(grizzlyPeerID.getHost(), grizzlyPeerID.getMulticastPort());
        try {
            return this.send(remoteSocketAddress, null, message);
        }
        catch (IOException ie) {
            return this.send(remoteSocketAddress, null, message);
        }
    }

    @Override
    protected boolean doBroadcast(Message message) throws IOException {
        if (this.multicastSocketAddress == null) {
            throw new IOException("multicast address can not be null");
        }
        try {
            return this.send(this.multicastSocketAddress, this.localSocketAddress, message);
        }
        catch (MessageIOException mioe) {
            throw mioe;
        }
        catch (IOException ie) {
            return this.send(this.multicastSocketAddress, this.localSocketAddress, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean send(SocketAddress remoteAddress, SocketAddress localAddress, Message message) throws IOException {
        if (this.controller == null) {
            throw new IOException("grizzly controller must be initialized");
        }
        if (remoteAddress == null) {
            throw new IOException("remote address can not be null");
        }
        if (message == null) {
            throw new IOException("message can not be null");
        }
        ConnectorHandler connectorHandler = null;
        try {
            connectorHandler = this.controller.acquireConnectorHandler(Controller.Protocol.UDP);
            connectorHandler.connect(remoteAddress, localAddress);
            OutputWriter.flushChannel((DatagramChannel)((DatagramChannel)connectorHandler.getUnderlyingChannel()), (SocketAddress)remoteAddress, (ByteBuffer)message.getPlainByteBuffer(), (long)this.writeTimeout);
        }
        finally {
            if (connectorHandler != null) {
                try {
                    connectorHandler.close();
                }
                catch (IOException e) {}
                this.controller.releaseConnectorHandler(connectorHandler);
            }
        }
        return true;
    }
}

