/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    static final DotSequence zero = new DotSequence("");
    static final Date zerotime = new Date(0L);
    static final Version nullVersion = new Version("");
    DotSequence release = zero;
    DotSequence build = zero;
    DotSequence branch = zero;
    String versionstr = "";
    Date timestamp = zerotime;
    static DateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public Version(String s) {
        this.versionstr = s;
        int timeidx = s.indexOf(":");
        String timestr = "";
        if (timeidx != -1) {
            timestr = s.substring(timeidx + 1);
        } else {
            timeidx = s.length();
        }
        int branchidx = s.indexOf("-");
        String branchstr = "";
        if (branchidx != -1) {
            branchstr = s.substring(branchidx + 1, timeidx);
        } else {
            branchidx = timeidx;
        }
        int buildidx = s.indexOf(",");
        String buildstr = "";
        if (buildidx != -1) {
            buildstr = s.substring(buildidx + 1, branchidx);
        } else {
            buildidx = branchidx;
        }
        String releasestr = s.substring(0, buildidx);
        if (releasestr.length() > 0) {
            this.release = new DotSequence(releasestr);
        }
        if (buildstr.length() > 0) {
            this.build = new DotSequence(buildstr);
        }
        if (branchstr.length() > 0) {
            this.branch = new DotSequence(branchstr);
        }
        if (timestr.length() > 0) {
            if (timestr.endsWith("Z") && timestr.indexOf("T") != -1) {
                try {
                    this.timestamp = df.parse(timestr);
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException("Invalid timestamp in version: " + timestr, ex);
                }
            } else {
                throw new IllegalArgumentException("Unrecognized timestamp in version: " + timestr);
            }
        }
    }

    public boolean matches(Version v) {
        boolean q;
        boolean bl = q = this.release.matches(v.release) && this.build.matches(v.build) && this.branch.matches(v.branch);
        if (v.timestamp == zerotime) {
            return q;
        }
        if (this.timestamp.equals(v.timestamp)) {
            return q;
        }
        return false;
    }

    public boolean equals(Object v) {
        return this.compareTo((Version)v) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.release != null ? this.release.hashCode() : 0);
        hash = 37 * hash + (this.branch != null ? this.branch.hashCode() : 0);
        hash = 37 * hash + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(Version v) {
        int i = this.release.compareTo(v.release);
        if (i != 0) {
            return i;
        }
        i = this.branch.compareTo(v.branch);
        if (i != 0) {
            return i;
        }
        return this.timestamp.compareTo(v.timestamp);
    }

    public boolean isSuccessor(Version v) {
        boolean release_match = false;
        boolean branch_match = false;
        boolean date_match = false;
        if (v.release != zero && this.release != zero) {
            if (v.release.isSubsequence(this.release)) {
                release_match = true;
            }
        } else if (v.release == zero) {
            release_match = true;
        }
        if (v.branch != zero && this.branch != zero) {
            if (v.branch.isSubsequence(this.branch)) {
                branch_match = true;
            }
        } else if (v.branch == zero) {
            branch_match = true;
        }
        if (v.timestamp != zerotime && this.timestamp != zerotime) {
            if (v.timestamp.equals(this.timestamp)) {
                date_match = true;
            }
        } else if (v.timestamp == zerotime) {
            date_match = true;
        }
        return release_match && branch_match && date_match;
    }

    public String toString() {
        return this.versionstr;
    }

    public boolean isNull() {
        return this.equals(nullVersion);
    }

    public DotSequence getRelease() {
        return this.release;
    }

    public DotSequence getBranch() {
        return this.branch;
    }

    public Date getPublishDate() {
        return this.timestamp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DotSequence
    implements Comparable<DotSequence> {
        int[] values;
        int hc = 0;

        DotSequence(String s) {
            if (s.length() == 0) {
                this.values = new int[0];
                return;
            }
            StringTokenizer st = new StringTokenizer(s, ".");
            this.values = new int[st.countTokens()];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = Integer.parseInt(st.nextToken());
                this.hc += this.values[i];
            }
        }

        public boolean equals(Object v) {
            return this.compareTo((DotSequence)v) == 0;
        }

        public int hashCode() {
            return this.hc;
        }

        @Override
        public int compareTo(DotSequence d) {
            int i;
            for (i = 0; i < this.values.length && i < d.values.length; ++i) {
                if (this.values[i] < d.values[i]) {
                    return -1;
                }
                if (this.values[i] <= d.values[i]) continue;
                return 1;
            }
            if (this.values.length == d.values.length) {
                return 0;
            }
            if (i < this.values.length) {
                while (i < this.values.length) {
                    if (this.values[i] > 0) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
            while (i < d.values.length) {
                if (d.values[i] > 0) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }

        public boolean matches(DotSequence d) {
            for (int i = 0; i < this.values.length && i < d.values.length; ++i) {
                if (this.values[i] == d.values[i]) continue;
                return false;
            }
            return this.values.length >= d.values.length;
        }

        public boolean isSubsequence(DotSequence d) {
            if (this.values.length > d.values.length) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == d.values[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            if (this.values.length == 0) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            buf.append(this.values[0]);
            for (int i = 1; i < this.values.length; ++i) {
                buf.append(".");
                buf.append(this.values[i]);
            }
            return buf.toString();
        }
    }
}

