/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.inject.Inject;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigurationCleanup;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.ConfigurationAccess;
import org.glassfish.config.support.DasReaderFilter;
import org.glassfish.config.support.InstanceReaderFilter;
import org.glassfish.config.support.ServerReaderFilter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigPopulatorException;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.Populator;

public abstract class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    protected ServiceLocator habitat;
    @Inject
    @Optional
    private ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ConfigurationAccess configAccess;
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXml.class);
    private static final LocalStringsImpl strings = new LocalStringsImpl(DomainXml.class);

    public void run(ConfigParser parser) throws ConfigPopulatorException {
        ClassLoader parentClassLoader;
        LogRecord lr = new LogRecord(Level.FINE, "NCLS-CFGAPI-00083" + this.getClass().getName());
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
        ClassLoader classLoader = parentClassLoader = this.registry == null ? this.getClass().getClassLoader() : this.registry.getParentClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        ServiceLocatorUtilities.addOneConstant(this.habitat, parentClassLoader, null, new Type[]{ClassLoader.class});
        try {
            this.parseDomainXml(parser, this.getDomainXml(this.env), this.env.getInstanceName());
        }
        catch (IOException e) {
            throw new ConfigPopulatorException(localStrings.getLocalString("ConfigParsingFailed", "Failed to parse domain.xml"), (Throwable)e);
        }
        if ("upgrade".equals(this.context.getPlatformMainServiceName())) {
            this.upgrade();
        }
        for (ServiceHandle<ConfigurationCleanup> cc : this.habitat.getAllServiceHandles(ConfigurationCleanup.class, new Annotation[0])) {
            try {
                cc.getService();
                lr = new LogRecord(Level.FINE, "NCLS-CFGAPI-00084" + cc.getClass());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            catch (Exception e) {
                lr = new LogRecord(Level.FINE, e.toString() + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
                lr = new LogRecord(Level.SEVERE, cc.getClass() + "NCLS-CFGAPI-00085" + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
        this.decorate();
    }

    protected void decorate() {
        Server server = this.habitat.getService(Server.class, this.env.getInstanceName(), new Annotation[0]);
        if (server == null) {
            LogRecord lr = new LogRecord(Level.SEVERE, "NCLS-CFGAPI-00086");
            lr.setLoggerName(this.getClass().getName());
            EarlyLogHandler.earlyMessages.add(lr);
            return;
        }
        ServiceLocatorUtilities.addOneConstant(this.habitat, server, "default-instance-name", new Type[]{Server.class});
        server.getConfig().addIndex(this.habitat, "default-instance-name");
        Cluster c = server.getCluster();
        if (c != null) {
            ServiceLocatorUtilities.addOneConstant(this.habitat, c, "default-instance-name", new Type[]{Cluster.class});
        }
    }

    protected void upgrade() {
        for (ServiceHandle<ConfigurationUpgrade> cu : this.habitat.getAllServiceHandles(ConfigurationUpgrade.class, new Annotation[0])) {
            try {
                cu.getService();
                LogRecord lr = new LogRecord(Level.FINE, "NCLS-CFGAPI-00087" + cu.getClass());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            catch (Exception e) {
                LogRecord lr = new LogRecord(Level.FINE, e.toString() + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
                lr = new LogRecord(Level.SEVERE, cu.getClass() + "NCLS-CFGAPI-00088" + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        File domainXml = new File(env.getConfigDirPath(), "domain.xml");
        if (domainXml.exists() && domainXml.length() > 0L) {
            return domainXml.toURI().toURL();
        }
        LogRecord lr = new LogRecord(Level.SEVERE, domainXml.getAbsolutePath() + "NCLS-CFGAPI-00090");
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
        domainXml = new File(env.getConfigDirPath(), "domain.xml.bak");
        if (domainXml.exists() && domainXml.length() > 0L) {
            return domainXml.toURI().toURL();
        }
        lr = new LogRecord(Level.SEVERE, "NCLS-CFGAPI-00090");
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
        throw new IOException(localStrings.getLocalString("NoUsableConfigFile", "No usable configuration file at {0}", new Object[]{env.getConfigDirPath()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        long startNano = System.nanoTime();
        try {
            ServerReaderFilter xsr = null;
            this.xif.setXMLResolver(new XMLResolver(){

                @Override
                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    return new ByteArrayInputStream(new byte[0]);
                }
            });
            if (this.env.getRuntimeType() == RuntimeType.DAS || this.env.getRuntimeType() == RuntimeType.EMBEDDED) {
                xsr = new DasReaderFilter(domainXml, this.xif);
            } else if (this.env.getRuntimeType() == RuntimeType.INSTANCE) {
                xsr = new InstanceReaderFilter(this.env.getInstanceName(), domainXml, this.xif);
            } else {
                throw new RuntimeException("Internal Error: Unknown server type: " + this.env.getRuntimeType());
            }
            Lock lock = null;
            try {
                try {
                    lock = this.configAccess.accessRead();
                }
                catch (Exception e) {
                    // empty catch block
                }
                parser.parse((XMLStreamReader)xsr, this.getDomDocument());
                xsr.close();
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
            String errorMessage = xsr.configWasFound();
            if (errorMessage != null) {
                LogRecord lr = new LogRecord(Level.WARNING, errorMessage);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Fatal Error.  Unable to parse " + domainXml, e);
        }
        Long l = System.nanoTime() - startNano;
        LogRecord lr = new LogRecord(Level.FINE, "NCLS-CFGAPI-00092" + l.toString());
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
    }

    protected abstract DomDocument getDomDocument();
}

