/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.api.admin.config.Container;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.config.support.datatypes.NonNegativeInteger;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface HttpService
extends ConfigBeanProxy,
PropertyBag,
ConfigExtension {
    @Element
    @NotNull
    public AccessLog getAccessLog();

    public void setAccessLog(AccessLog var1) throws PropertyVetoException;

    @Element(required=true)
    public List<VirtualServer> getVirtualServer();

    @DuckTyped
    public VirtualServer getVirtualServerByName(String var1);

    @DuckTyped
    public List<String> getNonAdminVirtualServerList();

    @Attribute(defaultValue="false")
    @Pattern(regexp="(false|true|on|off)")
    public String getAccessLoggingEnabled();

    public void setAccessLoggingEnabled(String var1);

    @Attribute(defaultValue="false")
    @Pattern(regexp="(true|false|on|off)")
    public String getSsoEnabled();

    public void setSsoEnabled(String var1);

    @PropertiesDesc(props={@PropertyDesc(name="monitoring-cache-enabled", defaultValue="true", dataType=Boolean.class, description="Enables the monitoring cache"), @PropertyDesc(name="monitoring-cache-refresh-in-millis", defaultValue="5000", dataType=NonNegativeInteger.class, description="Specifies the interval between refreshes of the monitoring cache"), @PropertyDesc(name="ssl-cache-entries", defaultValue="10000", dataType=NonNegativeInteger.class, description="Specifies the number of SSL sessions to be cached"), @PropertyDesc(name="ssl3-session-timeout", defaultValue="86400", dataType=NonNegativeInteger.class, description="Specifies the interval at which SSL3 sessions are cached"), @PropertyDesc(name="ssl-session-timeout", defaultValue="100", dataType=NonNegativeInteger.class, description="Specifies the interval at which SSL2 sessions are cached"), @PropertyDesc(name="recycle-objects", defaultValue="true", dataType=Boolean.class, description="Whether to recycle internal objects instead of using the VM garbage collector"), @PropertyDesc(name="reader-threads", defaultValue="0", dataType=NonNegativeInteger.class, description="Specifies the number of reader threads, which read bytes from the non-blocking socket"), @PropertyDesc(name="acceptor-queue-length", defaultValue="4096", dataType=NonNegativeInteger.class, description="Specifies the length of the acceptor thread queue. Once full, connections are rejected"), @PropertyDesc(name="reader-queue-length", defaultValue="4096", dataType=NonNegativeInteger.class, description="Specifies the length of the reader thread queue. Once full, connections are rejected"), @PropertyDesc(name="use-nio-direct-bytebuffer", defaultValue="true", dataType=Boolean.class, description="Controls whether the NIO direct ByteBuffer is used. In a limited resource environment, it might be faster to use non-direct Java's ByteBuffer by setting a value of false"), @PropertyDesc(name="authPassthroughEnabled", defaultValue="false", dataType=Boolean.class, description="Indicates that the http-listeners receive traffic from an SSL-terminating proxy server, which is responsible for forwarding any information about the original client request (such as client IP address, SSL keysize, and authenticated client certificate chain) to the HTTP listeners using custom request headers. Each  subelement can override this setting for itself"), @PropertyDesc(name="proxyHandler", defaultValue="com.sun.enterprise.web.web.ProxyHandlerImpl", description="Specifies the fully qualified class name of a custom implementation of com.sun.appserv.ProxyHandler. Only used if authPassthroughEnabled is set to true. Each http-listener can override the setting for itself"), @PropertyDesc(name="bufferSize", defaultValue="4096", dataType=NonNegativeInteger.class, description="Size in bytes of the buffer to be provided for input streams created by HTTP listeners"), @PropertyDesc(name="connectionTimeout", defaultValue="30", dataType=NonNegativeInteger.class, description="Number of seconds HTTP listeners wait, after accepting a connection, for the request URI line to be presented"), @PropertyDesc(name="maxKeepAliveRequests", defaultValue="250", dataType=NonNegativeInteger.class, description="Maximum number of HTTP requests that can be pipelined until the connection is closed by the server. Set this property to 1 to disable HTTP/1.0 keep-alive, as well as HTTP/1.1 keep-alive and pipelining"), @PropertyDesc(name="traceEnabled", defaultValue="true", dataType=Boolean.class, description="Enables the TRACE operation. Set  to false to make the server less susceptible to cross-site scripting attacks"), @PropertyDesc(name="accessLoggingEnabled", defaultValue="false", dataType=Boolean.class, description="Controls access logging for all virtual-server that do not specify this property"), @PropertyDesc(name="disableUploadTimeout", defaultValue="true", dataType=Boolean.class, description="If false, the connection for a servlet that reads bytes slowly is closed after the 'connectionUploadTimeout' is reached"), @PropertyDesc(name="connectionUploadTimeout", defaultValue="5", dataType=NonNegativeInteger.class, description="Specifies the timeout for uploads. Applicable only if 'disableUploadTimeout' is set to false"), @PropertyDesc(name="uriEncoding", defaultValue="UTF-8", description="Specifies the character set used to decode the request URIs received on http-listeners that do not define this property. Must be a valid IANA character set name")})
    @Element(value="property")
    public List<Property> getProperty();

    public static class Duck {
        private static final Logger logger = ConfigApiLoggerInfo.getLogger();

        public static VirtualServer getVirtualServerByName(HttpService target, String name) {
            for (VirtualServer v : target.getVirtualServer()) {
                if (!v.getId().equals(name)) continue;
                return v;
            }
            return null;
        }

        public static List<String> getNonAdminVirtualServerList(HttpService target) {
            ArrayList<String> nonAdminVSList = new ArrayList<String>();
            for (VirtualServer v : target.getVirtualServer()) {
                if (v.getId().equals("__asadmin")) continue;
                nonAdminVSList.add(v.getId());
            }
            return Collections.unmodifiableList(nonAdminVSList);
        }

        public static HttpService createDefaultConfig(Config c) {
            Config param = c;
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                    public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                        HttpService httpService = (HttpService)param.createChild(HttpService.class);
                        AccessLog accessLog = (AccessLog)httpService.createChild(AccessLog.class);
                        List<VirtualServer> vsList = httpService.getVirtualServer();
                        httpService.setAccessLog(accessLog);
                        VirtualServer vs = (VirtualServer)httpService.createChild(VirtualServer.class);
                        vs.setId("server");
                        vs.setNetworkListeners("http-listener-1,http-listener-2");
                        VirtualServer vs1 = (VirtualServer)httpService.createChild(VirtualServer.class);
                        vs1.setId("__asadmin");
                        vs1.setNetworkListeners("admin-listener");
                        vsList.add(vs);
                        vsList.add(vs1);
                        param.getContainers().add((Container)httpService);
                        return httpService;
                    }
                }, (ConfigBeanProxy)param);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.INFO, "NCLS-CFGAPI-00009", ex);
            }
            return param.getExtensionByType(HttpService.class);
        }
    }
}

