/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Common {
    public static final int NONE = 0;
    public static final int MASK_USER = 65535;
    public static final int USE_DEFAULT_VALUES = 1;
    public static final int NO_DEFAULT_VALUES = 2;
    public static final int MASK_SEQUENCE = 15;
    public static final int SEQUENCE_AND = 1;
    public static final int SEQUENCE_OR = 2;
    public static final int MASK_INSTANCE = 240;
    public static final int TYPE_0_1 = 16;
    public static final int TYPE_1 = 32;
    public static final int TYPE_0_N = 48;
    public static final int TYPE_1_N = 64;
    public static final int MASK_TYPE = 65280;
    public static final int TYPE_STRING = 256;
    public static final int TYPE_BEAN = 512;
    public static final int TYPE_BOOLEAN = 768;
    public static final int TYPE_BYTE = 1024;
    public static final int TYPE_CHAR = 1280;
    public static final int TYPE_SHORT = 1536;
    public static final int TYPE_INT = 1792;
    public static final int TYPE_LONG = 2048;
    public static final int TYPE_FLOAT = 2304;
    public static final int TYPE_DOUBLE = 2560;
    public static final int TYPE_COMMENT = 3840;
    public static final int MASK_PROP = 983040;
    public static final int TYPE_KEY = 65536;
    public static final int TYPE_SHOULD_NOT_BE_EMPTY = 131072;
    public static final int TYPE_VETOABLE = 0x100000;
    public static final int COMMENT = 1;
    public static final int ELEMENT = 2;
    public static final int ATTLIST = 3;
    public static final String DTD_STRING = "#PCDATA";
    public static final String DTD_EMPTY = "EMPTY";
    public static final String CLASS_STRING = "String";
    public static final String CLASS_BOOLEAN = "Boolean";
    public static final String GENERATED_TAG = "Generated";
    private static String rbName = "org.netbeans.modules.schema2beans.Bundle";

    public static boolean isSequenceOr(int n) {
        return (n & 0xF) == 2;
    }

    public static boolean isArray(int n) {
        int n2 = n & 0xF0;
        return n2 == 48 || n2 == 64;
    }

    public static boolean isBean(int n) {
        return (n & 0xFF00) == 512;
    }

    public static boolean isString(int n) {
        return (n & 0xFF00) == 256;
    }

    public static boolean isBoolean(int n) {
        return (n & 0xFF00) == 768;
    }

    public static boolean isKey(int n) {
        return (n & 0x10000) == 65536;
    }

    public static boolean shouldNotBeEmpty(int n) {
        return (n & 0x20000) == 131072;
    }

    public static boolean isVetoable(int n) {
        return (n & 0x100000) == 0x100000;
    }

    public static boolean isScalar(int n) {
        switch (n & 0xFF00) {
            case 256: 
            case 512: 
            case 3840: {
                return false;
            }
            case 768: 
            case 1024: 
            case 1280: 
            case 1536: 
            case 1792: 
            case 2048: 
            case 2304: 
            case 2560: {
                return true;
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(n)));
    }

    public static String wrapperGetMethod(int n) {
        switch (n & 0xFF00) {
            case 768: {
                return "booleanValue";
            }
            case 1024: {
                return "byteValue";
            }
            case 1280: {
                return "charValue";
            }
            case 1536: {
                return "shortValue";
            }
            case 1792: {
                return "intValue";
            }
            case 2048: {
                return "longValue";
            }
            case 2304: {
                return "floatValue";
            }
            case 2560: {
                return "doubleValue";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(n)));
    }

    public static String wrapperClass(int n) {
        switch (n & 0xFF00) {
            case 768: {
                return CLASS_BOOLEAN;
            }
            case 1024: {
                return "Byte";
            }
            case 1280: {
                return "Character";
            }
            case 1536: {
                return "Short";
            }
            case 1792: {
                return "Integer";
            }
            case 2048: {
                return "Long";
            }
            case 2304: {
                return "Float";
            }
            case 2560: {
                return "Double";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(n)));
    }

    public static int wrapperToType(String string) {
        if (string == null) {
            return 0;
        }
        String string2 = string.trim();
        if (string2.endsWith("boolean")) {
            return 768;
        }
        if (string2.endsWith("byte")) {
            return 1024;
        }
        if (string2.endsWith("char")) {
            return 1280;
        }
        if (string2.endsWith("short")) {
            return 1536;
        }
        if (string2.endsWith("int")) {
            return 1792;
        }
        if (string2.endsWith("long")) {
            return 2048;
        }
        if (string2.endsWith("float")) {
            return 2304;
        }
        if (string2.endsWith("double")) {
            return 2560;
        }
        if (string2.equals(CLASS_STRING) || string2.equals("java.lang.String")) {
            return 256;
        }
        return 0;
    }

    public static String scalarType(int n) {
        switch (n & 0xFF00) {
            case 768: {
                return "boolean";
            }
            case 1024: {
                return "byte";
            }
            case 1280: {
                return "char";
            }
            case 1536: {
                return "short";
            }
            case 1792: {
                return "int";
            }
            case 2048: {
                return "long";
            }
            case 2304: {
                return "float";
            }
            case 2560: {
                return "double";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(n)));
    }

    public static String typeToString(int n) {
        switch (n & 0xFF00) {
            case 256: {
                return "TYPE_STRING";
            }
            case 3840: {
                return "TYPE_COMMENT";
            }
            case 512: {
                return "TYPE_BEAN";
            }
            case 768: {
                return "TYPE_BOOLEAN";
            }
            case 1024: {
                return "TYPE_BYTE";
            }
            case 1280: {
                return "TYPE_CHAR";
            }
            case 1536: {
                return "TYPE_SHORT";
            }
            case 1792: {
                return "TYPE_INT";
            }
            case 2048: {
                return "TYPE_LONG";
            }
            case 2304: {
                return "TYPE_FLOAT";
            }
            case 2560: {
                return "TYPE_DOUBLE";
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(n)));
    }

    public static String dumpHex(String string) {
        String string2;
        if (string != null) {
            string2 = "hex[ ";
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                string2 = string2 + Integer.toHexString(byArray[i]) + " ";
            }
            string2 = string2 + "]";
        } else {
            string2 = "<null>";
        }
        return string2;
    }

    public static String constName(String string) {
        return string.replace('-', '_').replace('#', '_').replace('.', '_').replace(':', '_').toUpperCase();
    }

    public static String convertName(String string) {
        return Common.convertName(string, true);
    }

    public static String convertNameInstance(String string) {
        return Common.convertName(string, false);
    }

    private static String convertName(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                bl2 = true;
                break;
            }
            c = stringCharacterIterator.next();
        }
        c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_' || !Character.isJavaIdentifierPart(c)) {
                bl = true;
            } else {
                if (bl) {
                    c = Character.toUpperCase(c);
                } else if (!bl2) {
                    c = Character.toLowerCase(c);
                }
                stringBuffer.append(c);
                bl = false;
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static Object getComparableObject(Object object) {
        Object object2 = object;
        if (object instanceof String) {
            String string = (String)object;
            object2 = string.trim();
        }
        return object2;
    }

    public static Object defaultScalarValue(int n) {
        switch (n & 0xFF00) {
            case 256: {
                return "";
            }
            case 3840: {
                return "";
            }
            case 768: {
                return Boolean.FALSE;
            }
            case 1024: {
                return new Byte(0);
            }
            case 1280: {
                return new Character('\u0000');
            }
            case 1536: {
                return new Short(0);
            }
            case 1792: {
                return new Integer(0);
            }
            case 2048: {
                return new Long(0L);
            }
            case 2304: {
                return new Float(0.0);
            }
            case 2560: {
                return new Double(0.0);
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType_msg", new Integer(n)));
    }

    public static String getMessage(String string) {
        return Common.getMessage(string, null);
    }

    public static String getMessage(String string, Object object) {
        return Common.getMessage(string, new Object[]{object});
    }

    public static String getMessage(String string, int n) {
        return Common.getMessage(string, new Object[]{new Integer(n)});
    }

    public static String getMessage(String string, Object object, Object object2) {
        return Common.getMessage(string, new Object[]{object, object2});
    }

    public static String getMessage(String string, Object object, Object object2, Object object3) {
        return Common.getMessage(string, new Object[]{object, object2, object3});
    }

    public static String getMessage(String string, Object[] objectArray) {
        ResourceBundle resourceBundle = null;
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(rbName, Locale.getDefault(), Common.class.getClassLoader());
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println("Couldn't find the bundle " + rbName + " for the locale " + Locale.getDefault());
            }
        }
        if (resourceBundle != null) {
            if (objectArray != null) {
                return MessageFormat.format(resourceBundle.getString(string), objectArray);
            }
            return resourceBundle.getString(string);
        }
        String string2 = " ";
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = objectArray[i] != null ? string2 + objectArray[i].toString() + " " : string2 + "null ";
            }
        }
        return string + string2;
    }

    public static String instanceToString(int n) {
        switch (n) {
            case 16: {
                return "optional";
            }
            case 48: {
                return "an array, possibly empty";
            }
            case 64: {
                return "an array containing at least one element";
            }
        }
        return "mandatory";
    }

    public static String instanceToCommonString(int n) {
        switch (n) {
            case 16: {
                return "TYPE_0_1";
            }
            case 48: {
                return "TYPE_0_N";
            }
            case 64: {
                return "TYPE_1_N";
            }
        }
        return "TYPE_1";
    }

    public static int widestInstance(int n, int n2) {
        if (n == 48 || n2 == 48) {
            return 48;
        }
        if (n == 64 || n2 == 64) {
            return 64;
        }
        if (n == 16 || n2 == 16) {
            return 16;
        }
        return n;
    }
}

