/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.freespace.FreespaceManagerIx;
import com.db4o.internal.freespace.FreespaceManagerRam;

public abstract class FreespaceManager {
    final LocalObjectContainer _file;
    public static final byte FM_DEFAULT = 0;
    public static final byte FM_LEGACY_RAM = 1;
    public static final byte FM_RAM = 2;
    public static final byte FM_IX = 3;
    public static final byte FM_DEBUG = 4;
    private static final int INTS_IN_SLOT = 12;

    public FreespaceManager(LocalObjectContainer localObjectContainer) {
        this._file = localObjectContainer;
    }

    public static byte checkType(byte by) {
        if (by == 0) {
            return 2;
        }
        return by;
    }

    public static FreespaceManager createNew(LocalObjectContainer localObjectContainer) {
        return FreespaceManager.createNew(localObjectContainer, localObjectContainer.systemData().freespaceSystem());
    }

    public abstract void onNew(LocalObjectContainer var1);

    public static FreespaceManager createNew(LocalObjectContainer localObjectContainer, byte by) {
        by = FreespaceManager.checkType(by);
        switch (by) {
            case 3: {
                return new FreespaceManagerIx(localObjectContainer);
            }
        }
        return new FreespaceManagerRam(localObjectContainer);
    }

    public static int initSlot(LocalObjectContainer localObjectContainer) {
        int n = localObjectContainer.getSlot(FreespaceManager.slotLength());
        FreespaceManager.slotEntryToZeroes(localObjectContainer, n);
        return n;
    }

    static void slotEntryToZeroes(LocalObjectContainer localObjectContainer, int n) {
        StatefulBuffer statefulBuffer = new StatefulBuffer(localObjectContainer.getSystemTransaction(), n, FreespaceManager.slotLength());
        for (int i = 0; i < 12; ++i) {
            statefulBuffer.writeInt(0);
        }
        statefulBuffer.writeEncrypt();
    }

    static final int slotLength() {
        return 48;
    }

    public abstract void beginCommit();

    final int blockSize() {
        return this._file.blockSize();
    }

    public abstract void debug();

    final int discardLimit() {
        return this._file.configImpl().discardFreeSpace();
    }

    public abstract void endCommit();

    public abstract int entryCount();

    public abstract void free(int var1, int var2);

    public abstract int freeSize();

    public abstract void freeSelf();

    public abstract int getSlot(int var1);

    public abstract void migrate(FreespaceManager var1);

    public abstract void read(int var1);

    public abstract void start(int var1);

    public abstract byte systemType();

    public abstract int write(boolean var1);

    public boolean requiresMigration(byte by, byte by2) {
        return (by != 0 || by2 == 1) && this.systemType() != by;
    }

    public static void migrate(FreespaceManager freespaceManager, FreespaceManager freespaceManager2) {
        freespaceManager.migrate(freespaceManager2);
        freespaceManager.freeSelf();
        freespaceManager2.beginCommit();
        freespaceManager2.endCommit();
    }
}

