/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.service.DBManager;
import org.rssowl.core.persist.service.AbstractPersistenceService;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.LongOperationMonitor;
import org.rssowl.core.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceServiceImpl
extends AbstractPersistenceService {
    @Override
    public void startup(LongOperationMonitor monitor, boolean emergency, boolean forRestore) {
        super.startup(monitor, emergency, forRestore);
        DBManager.getDefault().startup(monitor, emergency, forRestore);
        InternalOwl.getDefault().setStartLevel(Owl.StartLevel.DB_OPENED);
        if (!emergency) {
            this.getModelSearch().startup();
            InternalOwl.getDefault().setStartLevel(Owl.StartLevel.SEARCH_INDEX_OPENED);
        }
    }

    @Override
    public void shutdown(boolean emergency) throws PersistenceException {
        if (!emergency) {
            try {
                this.getIDGenerator().shutdown();
            }
            catch (Exception e) {
                Activator.safeLogError(e.getMessage(), e);
            }
            try {
                this.getModelSearch().shutdown(emergency);
            }
            catch (Exception e) {
                Activator.safeLogError(e.getMessage(), e);
            }
            DBManager.getDefault().shutdown();
        } else {
            try {
                DBManager.getDefault().shutdown();
            }
            catch (Exception e) {
                Activator.safeLogError(e.getMessage(), e);
            }
            this.getModelSearch().shutdown(emergency);
        }
    }

    @Override
    public void defragmentOnNextStartup() throws PersistenceException {
        try {
            DBManager.getDefault().getDefragmentFile().createNewFile();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public Pair<File, Long> getProfile() {
        return DBManager.getDefault().getProfile();
    }

    public List<File> getProfileBackups() {
        return DBManager.getDefault().getProfileBackups();
    }

    public void restoreProfile(File backup) throws PersistenceException {
        DBManager.getDefault().restoreProfile(backup);
    }

    public void recreateProfile(boolean needsEmergencyStartup) throws PersistenceException {
        File largeBlockSizeMarkerFile;
        Activator.safeLogInfo(needsEmergencyStartup ? "Start: Recreate Profile with OPML Import" : "Start: Start Over with Fresh Profile");
        File restoreDBFile = new File(DBManager.getDBRestoreFilePath());
        if (restoreDBFile.exists()) {
            restoreDBFile.delete();
        }
        if ((largeBlockSizeMarkerFile = DBManager.getLargeBlockSizeMarkerFile()).exists()) {
            largeBlockSizeMarkerFile.delete();
        }
        DBManager.getDefault().shutdown();
        if (!needsEmergencyStartup) {
            DBManager.getDefault().startup(new LongOperationMonitor((IProgressMonitor)new NullProgressMonitor()){}, true, true);
        } else {
            InternalOwl.getDefault().startup(new LongOperationMonitor((IProgressMonitor)new NullProgressMonitor()){}, true, true);
        }
        InternalOwl.getDefault().getPersistenceService().getModelSearch().reIndexOnNextStartup();
        Activator.safeLogInfo(needsEmergencyStartup ? "End: Recreate Profile with OPML Import" : "End: Start Over with Fresh Profile");
    }

    public void recreateSchemaForTests() throws PersistenceException {
        DBManager.getDefault().dropDatabaseForTests();
        DBManager.getDefault().startup(new LongOperationMonitor((IProgressMonitor)new NullProgressMonitor()){}, true, false);
        this.getModelSearch().clearIndex();
    }
}

