/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.ILinkHandler;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;
import org.rssowl.ui.internal.editors.browser.WebBrowserView;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.Messages;

public class CBrowser {
    private static final int IE_BROWSER_URL_DELAY = 800;
    private static final int MOZILLA_BROWSER_URL_DELAY = 2000;
    private static final String JAVA_SCRIPT_PRINT = "window.print();";
    private static final String XULRUNNER_PROXY_HOST = "network.proxy_host";
    private static final String XULRUNNER_PROXY_PORT = "network.proxy_port";
    private static final String DISABLE_XULRUNNER = "noXulrunner";
    private static final String XULRUNNER_PATH_PROPERTY = "org.eclipse.swt.browser.XULRunnerPath";
    private static final String XULRUNNER_DIR = "xulrunner";
    private static boolean fgXulrunnerRuntimeTested = false;
    private static final long REFRESH_NAVIGATION_DELAY = 3000L;
    private static final long URL_CHANGE_NAVIGATION_DELAY = 1000L;
    private static boolean fgMozillaAvailable = true;
    private static boolean fgMozillaRunningOnWindows;
    private static boolean fgCoInternetSetFeatureError;
    private static boolean fgNavigationSoundsDisabled;
    private static boolean fgPopupBlockerEnabled;
    private static final int FEATURE_WEBOC_POPUPMANAGEMENT = 5;
    private static final int FEATURE_SECURITYBAND = 9;
    private static final int FEATURE_DISABLE_NAVIGATION_SOUNDS = 21;
    private static final int SET_FEATURE_ON_PROCESS = 2;
    private static final List<String> EXTERNAL_BLACKLIST;
    private static final AtomicInteger FAILING_JS_COUNTER;
    private static final int MAX_FAILING_JS_LOGS = 5;
    private static final int MAX_FAILING_JS_LOG_LENGTH = 500;
    private Browser fBrowser;
    private boolean fAllowExternalNavigation;
    private boolean fDisableXulrunner;
    private boolean fCanOpenLinksInTabs;
    private long fLastRefresh;
    private long fLastUrlChange;
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();
    private IPreferenceScope fEclipsePreferences = Owl.getPreferenceService().getEclipseScope();
    private Map<String, ILinkHandler> fLinkHandler;
    private String fLastSetUrl;

    static {
        EXTERNAL_BLACKLIST = Arrays.asList("ipv6/exp/iframe.html", "/plugins/like.php", "scribd.com/embeds", "youtube.com/embed/");
        FAILING_JS_COUNTER = new AtomicInteger();
    }

    public CBrowser(Composite parent, int style) {
        this.fDisableXulrunner = System.getProperty(DISABLE_XULRUNNER) != null;
        try {
            this.fBrowser = this.createBrowser(parent, style);
        }
        catch (SWTError e) {
            MessageBox box = new MessageBox(parent.getShell(), 289);
            box.setText(Messages.CBrowser_ERROR_CREATE_BROWSER);
            box.setMessage(Messages.CBrowser_ERROR_CREATE_BROWSER_MSG);
            if (box.open() == 32) {
                BrowserUtils.openLinkExternal("http://www.rssowl.org/help#item_6j");
            }
            throw e;
        }
        this.fLinkHandler = new HashMap<String, ILinkHandler>();
        this.hookListeners();
        if (Application.IS_LINUX || this.useMozillaOnWindows()) {
            this.hookMenu();
        }
    }

    private boolean useMozillaOnWindows() {
        return Application.IS_WINDOWS && fgMozillaAvailable && !this.fDisableXulrunner;
    }

    public void setCanOpenLinksInTabs(boolean canOpenLinksInTabs) {
        this.fCanOpenLinksInTabs = canOpenLinksInTabs;
    }

    public void addLinkHandler(String commandId, ILinkHandler handler) {
        this.fLinkHandler.put(commandId, handler);
    }

    private Browser createBrowser(Composite parent, int style) {
        boolean prefEnablePopupBlocker;
        Browser browser;
        block20: {
            browser = null;
            if (Application.IS_LINUX || this.useMozillaOnWindows()) {
                String proxyHost = this.fEclipsePreferences.getString(DefaultPreferences.ECLIPSE_PROXY_HOST);
                String proxyPort = this.fEclipsePreferences.getString(DefaultPreferences.ECLIPSE_PROXY_PORT);
                if (this.useProxy() && StringUtils.isSet((String)proxyHost) && StringUtils.isSet((String)proxyPort)) {
                    System.setProperty(XULRUNNER_PROXY_HOST, proxyHost);
                    System.setProperty(XULRUNNER_PROXY_PORT, proxyPort);
                }
            }
            if (this.useMozillaOnWindows()) {
                try {
                    browser = new Browser(parent, style | 0x8000);
                    fgMozillaRunningOnWindows = true;
                }
                catch (SWTError e) {
                    fgMozillaAvailable = false;
                    if ("No more handles [Could not detect registered XULRunner to use]".equals(e.getMessage())) break block20;
                    Activator.getDefault().getLog().log(Activator.getDefault().createInfoStatus(e.getMessage(), null));
                }
            }
        }
        if (Application.IS_LINUX && !fgXulrunnerRuntimeTested) {
            File xulRunnerRuntimeDir;
            boolean xulrunnerPathSpecified;
            boolean bl = xulrunnerPathSpecified = System.getProperty(XULRUNNER_PATH_PROPERTY) != null;
            if (xulrunnerPathSpecified) {
                try {
                    browser = new Browser(parent, this.styleForLinux(style));
                }
                catch (SWTError sWTError) {
                    Activator.safeLogInfo(NLS.bind((String)"Error loading XULRunner from system property (''{0}'')", (Object)System.getProperty(XULRUNNER_PATH_PROPERTY)));
                }
            }
            if (browser == null) {
                if (xulrunnerPathSpecified) {
                    System.clearProperty(XULRUNNER_PATH_PROPERTY);
                }
                try {
                    browser = new Browser(parent, this.styleForLinux(style));
                }
                catch (SWTError sWTError) {
                    Activator.safeLogInfo("Error loading system default XULRunner");
                }
            }
            if (browser == null && (xulRunnerRuntimeDir = this.getXULRunnerRuntimeDir()) != null) {
                System.setProperty(XULRUNNER_PATH_PROPERTY, xulRunnerRuntimeDir.toString());
                try {
                    browser = new Browser(parent, this.styleForLinux(style));
                }
                catch (SWTError sWTError) {
                    Activator.safeLogInfo("Error loading XULRunner from bundled version");
                }
            }
            fgXulrunnerRuntimeTested = true;
        }
        if (browser == null) {
            browser = new Browser(parent, this.styleForLinux(style));
        }
        if (Application.IS_WINDOWS) {
            browser.setData("org.rssowl.ui.internal.FocuslessScrollHook", (Object)true);
        }
        Method method = null;
        if (!fgNavigationSoundsDisabled) {
            method = this.callCoInternetSetFeatureEnabled(method, 21, 2, true);
            fgNavigationSoundsDisabled = true;
        }
        if (Application.IS_WINDOWS && (prefEnablePopupBlocker = this.fPreferences.getBoolean(DefaultPreferences.ENABLE_IE_POPUP_BLOCKER)) != fgPopupBlockerEnabled) {
            method = this.callCoInternetSetFeatureEnabled(method, 5, 2, prefEnablePopupBlocker);
            this.callCoInternetSetFeatureEnabled(method, 9, 2, prefEnablePopupBlocker);
            fgPopupBlockerEnabled = prefEnablePopupBlocker;
        }
        browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CBrowser.this.fLinkHandler.clear();
            }
        });
        return browser;
    }

    private File getXULRunnerRuntimeDir() {
        Location installLocation = Platform.getInstallLocation();
        if (installLocation == null || installLocation.getURL() == null) {
            return null;
        }
        File programDir = this.toFile(installLocation.getURL());
        if (programDir == null || !programDir.isDirectory() || !programDir.exists()) {
            return null;
        }
        File xulrunnerDir = new File(programDir, XULRUNNER_DIR);
        if (!xulrunnerDir.exists() || !xulrunnerDir.isDirectory()) {
            return null;
        }
        return xulrunnerDir;
    }

    private File toFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(url.getPath());
        }
    }

    private int styleForLinux(int style) {
        if (Application.IS_LINUX && SWT.getVersion() >= 3700) {
            return style | 0x8000;
        }
        return style;
    }

    private Method callCoInternetSetFeatureEnabled(Method method, int feature, int scope, boolean enable) {
        if (!fgCoInternetSetFeatureError && Application.IS_WINDOWS && !this.useMozillaOnWindows()) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.win32.OS");
                if (method == null) {
                    method = clazz.getMethod("CoInternetSetFeatureEnabled", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                }
                method.invoke(clazz, feature, scope, enable);
                return method;
            }
            catch (Throwable t) {
                Activator.getDefault().logError(t.getMessage(), t);
                fgCoInternetSetFeatureError = true;
            }
        }
        return null;
    }

    private boolean useProxy() {
        boolean useProxy = this.fEclipsePreferences.getBoolean(DefaultPreferences.ECLIPSE_USE_PROXY);
        boolean useSystemProxy = this.fEclipsePreferences.getBoolean(DefaultPreferences.ECLIPSE_USE_SYSTEM_PROXY);
        return useProxy && !useSystemProxy;
    }

    private void hookMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new Action(Messages.CBrowser_BACK){

                    public void run() {
                        CBrowser.this.fBrowser.back();
                    }

                    public boolean isEnabled() {
                        return CBrowser.this.fBrowser.isBackEnabled();
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.getImageDescriptor("icons/etool16/backward.gif");
                    }
                });
                manager.add((IAction)new Action(Messages.CBrowser_FORWARD){

                    public void run() {
                        CBrowser.this.fBrowser.forward();
                    }

                    public boolean isEnabled() {
                        return CBrowser.this.fBrowser.isForwardEnabled();
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.getImageDescriptor("icons/etool16/forward.gif");
                    }
                });
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new Action(Messages.CBrowser_RELOAD){

                    public void run() {
                        CBrowser.this.refresh();
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.getImageDescriptor("icons/elcl16/reload.gif");
                    }
                });
                manager.add((IAction)new Action(Messages.CBrowser_STOP){

                    public void run() {
                        CBrowser.this.fBrowser.stop();
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.getImageDescriptor("icons/etool16/cancel.gif");
                    }
                });
            }
        });
        Menu menu = manager.createContextMenu((Control)this.fBrowser);
        this.fBrowser.setMenu(menu);
    }

    public Browser getControl() {
        return this.fBrowser;
    }

    public void refresh() {
        this.fLastRefresh = System.currentTimeMillis();
        this.fBrowser.refresh();
    }

    public void setUrl(String url) {
        this.setUrl(url, false);
    }

    private boolean supportExternalNavigation() {
        return OwlUI.useExternalBrowser() || this.fCanOpenLinksInTabs && this.fPreferences.getBoolean(DefaultPreferences.OPEN_LINKS_IN_NEW_TAB);
    }

    public void setUrl(String url, boolean allowExternalNavigation) {
        this.fLastSetUrl = url;
        if (allowExternalNavigation) {
            if (StringUtils.isSet((String)url) && !"about:blank".equals(url) && !ApplicationServer.getDefault().isNewsServerUrl(url) && this.supportExternalNavigation()) {
                this.fAllowExternalNavigation = true;
            } else {
                this.fLastUrlChange = System.currentTimeMillis();
            }
        } else {
            this.fAllowExternalNavigation = false;
            this.fLastUrlChange = System.currentTimeMillis();
        }
        this.fBrowser.setUrl(url);
    }

    public void blockExternalNavigationWhile(Runnable runnable) {
        this.fAllowExternalNavigation = false;
        try {
            runnable.run();
        }
        finally {
            this.fAllowExternalNavigation = true;
        }
    }

    public boolean back() {
        this.fAllowExternalNavigation = false;
        this.fLastUrlChange = System.currentTimeMillis();
        return this.fBrowser.back();
    }

    public boolean forward() {
        this.fAllowExternalNavigation = false;
        this.fLastUrlChange = System.currentTimeMillis();
        return this.fBrowser.forward();
    }

    public boolean print() {
        return this.execute(JAVA_SCRIPT_PRINT, null);
    }

    public boolean execute(String js, String context) {
        return this.execute(js, true, context);
    }

    public boolean execute(String js, boolean handleJSEnablement, String context) {
        if (this.fBrowser.isDisposed()) {
            return false;
        }
        if (handleJSEnablement && this.shouldDisableScript()) {
            this.setScriptDisabled(false);
        }
        try {
            boolean bl = this.internalExecute(js, context);
            return bl;
        }
        finally {
            if (handleJSEnablement && this.shouldDisableScript()) {
                this.setScriptDisabled(true);
            }
        }
    }

    private boolean internalExecute(String js, String context) {
        boolean res = this.fBrowser.execute(js);
        if (!res && FAILING_JS_COUNTER.incrementAndGet() < 5) {
            boolean isMozilla;
            if (!StringUtils.isSet((String)context)) {
                context = "Unknown Context";
            }
            if (js.length() > 500) {
                js = js.substring(0, 500);
            }
            if (!(isMozilla = CBrowser.isMozillaRunningOnWindows())) {
                Activator.getDefault().logError(NLS.bind((String)"Failed to execute JavaScript ({0}): {1}", (Object)context, (Object)js), null);
            } else {
                Activator.getDefault().logError(NLS.bind((String)"Failed to execute JavaScript ({0}, XULRunner): {1}", (Object)context, (Object)js), null);
            }
        }
        return res;
    }

    private OpenWindowListener getOpenWindowListener() {
        return new OpenWindowListener(){

            public void open(WindowEvent event) {
                boolean useMozilla = CBrowser.this.useMozillaOnWindows();
                if (OwlUI.useExternalBrowser()) {
                    final Browser tempBrowser = new Browser((Composite)CBrowser.this.fBrowser.getShell(), useMozilla ? 32768 : CBrowser.this.styleForLinux(0));
                    tempBrowser.setVisible(false);
                    event.browser = tempBrowser;
                    tempBrowser.getDisplay().timerExec(useMozilla ? 2000 : 800, new Runnable(){

                        public void run() {
                            if (!tempBrowser.isDisposed() && PlatformUI.isWorkbenchRunning()) {
                                String url = tempBrowser.getUrl();
                                tempBrowser.dispose();
                                if (StringUtils.isSet((String)url)) {
                                    BrowserUtils.openLinkExternal(URIUtils.toUnManaged((String)url));
                                }
                            }
                        }
                    });
                    return;
                }
                if (CBrowser.this.fEclipsePreferences.getBoolean(DefaultPreferences.ECLIPSE_MULTIPLE_TABS)) {
                    WebBrowserView browserView = BrowserUtils.openLinkInternal(null, WebBrowserContext.createFrom(Messages.CBrowser_LOADING));
                    if (browserView != null) {
                        event.browser = browserView.getBrowser().getControl();
                    }
                } else {
                    final Browser tempBrowser = new Browser((Composite)CBrowser.this.fBrowser.getShell(), useMozilla ? 32768 : CBrowser.this.styleForLinux(0));
                    tempBrowser.setVisible(false);
                    event.browser = tempBrowser;
                    tempBrowser.getDisplay().timerExec(useMozilla ? 2000 : 800, new Runnable(){

                        public void run() {
                            if (!tempBrowser.isDisposed() && PlatformUI.isWorkbenchRunning()) {
                                String url = tempBrowser.getUrl();
                                tempBrowser.dispose();
                                if (StringUtils.isSet((String)url)) {
                                    CBrowser.this.setUrl(url);
                                }
                            }
                        }
                    });
                }
            }
        };
    }

    public boolean isIE() {
        return Application.IS_WINDOWS && !this.fBrowser.isDisposed() && (this.fBrowser.getStyle() & 0x8000) == 0;
    }

    public static boolean isMozillaRunningOnWindows() {
        return Application.IS_WINDOWS && fgMozillaRunningOnWindows;
    }

    public void setScriptDisabled(Boolean disabled) {
        if (CBrowser.isMozillaRunningOnWindows()) {
            return;
        }
        if (Application.IS_WINDOWS) {
            try {
                Method method = this.fBrowser.getClass().getMethod("setScriptDisabled", Boolean.class);
                if (method != null) {
                    method.invoke((Object)this.fBrowser, disabled);
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                Method method = this.fBrowser.getClass().getMethod("setJavascriptEnabled", Boolean.TYPE);
                if (method != null) {
                    method.invoke((Object)this.fBrowser, disabled == false);
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean shouldDisableScript() {
        return this.fPreferences.getBoolean(DefaultPreferences.DISABLE_JAVASCRIPT);
    }

    private boolean shouldDisableScript(String location) {
        if (!this.shouldDisableScript()) {
            return false;
        }
        if (!StringUtils.isSet((String)location)) {
            return true;
        }
        String[] websites = this.fPreferences.getStrings(DefaultPreferences.DISABLE_JAVASCRIPT_EXCEPTIONS);
        if (websites != null) {
            String[] stringArray = websites;
            int n = websites.length;
            int n2 = 0;
            while (n2 < n) {
                String website = stringArray[n2];
                if (location.contains(website)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private void hookListeners() {
        this.fBrowser.addOpenWindowListener(this.getOpenWindowListener());
        this.fBrowser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                if (event.top && StringUtils.isSet((String)event.location) && event.location.equals(CBrowser.this.fLastSetUrl)) {
                    CBrowser.this.fAllowExternalNavigation = true;
                }
            }

            public void changing(LocationEvent event) {
                block16: {
                    if (StringUtils.isSet((String)event.location) && !"about:blank".equals(event.location) && !event.location.startsWith("javascript:")) {
                        CBrowser.this.setScriptDisabled(CBrowser.this.shouldDisableScript(event.location));
                    }
                    if (event.location != null && event.location.contains("rssowl://")) {
                        try {
                            URI link = new URI(event.location);
                            String host = URIUtils.safeGetHost((URI)link);
                            if (!StringUtils.isSet((String)host) || !CBrowser.this.fLinkHandler.containsKey(host)) break block16;
                            try {
                                ((ILinkHandler)CBrowser.this.fLinkHandler.get(host)).handle(host, link);
                            }
                            finally {
                                event.doit = false;
                            }
                            return;
                        }
                        catch (URISyntaxException e) {
                            Activator.getDefault().getLog().log(Activator.getDefault().createErrorStatus(e.getMessage(), e));
                        }
                    }
                }
                if (CBrowser.this.supportExternalNavigation()) {
                    if (!StringUtils.isSet((String)event.location) || "about:blank".equals(event.location)) {
                        return;
                    }
                    if (ApplicationServer.getDefault().isNewsServerUrl(event.location)) {
                        return;
                    }
                    boolean isManaged = URIUtils.isManaged((String)event.location);
                    if (!CBrowser.this.fAllowExternalNavigation && !isManaged) {
                        return;
                    }
                    long currentTimeMillis = System.currentTimeMillis();
                    if (!isManaged && currentTimeMillis - CBrowser.this.fLastRefresh < 3000L) {
                        return;
                    }
                    if (Application.IS_MAC && !isManaged && currentTimeMillis - CBrowser.this.fLastUrlChange < 1000L) {
                        return;
                    }
                    for (String blacklistItem : EXTERNAL_BLACKLIST) {
                        if (!event.location.contains(blacklistItem)) continue;
                        return;
                    }
                    event.doit = false;
                    if (CBrowser.this.fCanOpenLinksInTabs && CBrowser.this.fPreferences.getBoolean(DefaultPreferences.OPEN_LINKS_IN_NEW_TAB)) {
                        BrowserUtils.openLinkInternal(URIUtils.toUnManaged((String)event.location), null);
                    } else {
                        BrowserUtils.openLinkExternal(URIUtils.toUnManaged((String)event.location));
                    }
                }
            }
        });
    }
}

