/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.undo.IUndoOperation;
import org.rssowl.ui.internal.undo.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsStateOperation
implements IUndoOperation {
    private static final EnumSet<INews.State> SUPPORTED_STATES = EnumSet.of(INews.State.HIDDEN, INews.State.READ, INews.State.UNREAD);
    private static final int LONG_RUNNING_LIMIT = 50;
    private final Map<INews.State, List<NewsReference>> fOldStates;
    private final INews.State fNewState;
    private final int fNewsCount;
    private final boolean fOnlyNewNewsAffected;
    private final boolean fAffectEquivalentNews;
    private final INewsDAO fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);

    public NewsStateOperation(Collection<INews> news, INews.State newState, boolean affectEquivalentNews) {
        Assert.isTrue((boolean)SUPPORTED_STATES.contains(newState), (String)Messages.NewsStateOperation_UNSUPPORTED);
        this.fOldStates = CoreUtils.toStateMap(news);
        this.fNewState = newState;
        this.fAffectEquivalentNews = affectEquivalentNews;
        this.fNewsCount = news.size();
        this.fOnlyNewNewsAffected = this.fOldStates.containsKey(INews.State.NEW) && this.fOldStates.get(INews.State.NEW).size() == this.fNewsCount;
    }

    @Override
    public String getName() {
        switch (this.fNewState) {
            case HIDDEN: {
                return NLS.bind((String)Messages.NewsStateOperation_DELETE_N_NEWS, (Object)this.fNewsCount);
            }
            case READ: {
                return NLS.bind((String)Messages.NewsStateOperation_MARK_N_READ, (Object)this.fNewsCount);
            }
            case UNREAD: {
                if (this.fOnlyNewNewsAffected) {
                    return NLS.bind((String)Messages.NewsStateOperation_MARK_N_NEW_UNREAD, (Object)this.fNewsCount);
                }
                return NLS.bind((String)Messages.NewsStateOperation_MARK_N_UNREAD, (Object)this.fNewsCount);
            }
        }
        return Messages.NewsStateOperation_UNSUPPORTED;
    }

    @Override
    public void undo() {
        Set<Map.Entry<INews.State, List<NewsReference>>> entries = this.fOldStates.entrySet();
        for (Map.Entry<INews.State, List<NewsReference>> entry : entries) {
            INews.State oldState = entry.getKey();
            List<NewsReference> newsRefs = entry.getValue();
            ArrayList<INews> resolvedNews = new ArrayList<INews>(newsRefs.size());
            for (NewsReference newsRef : newsRefs) {
                INews news = newsRef.resolve();
                if (news == null || news.getState() != this.fNewState) continue;
                resolvedNews.add(news);
            }
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            this.fNewsDao.setState(resolvedNews, oldState, this.fAffectEquivalentNews, false);
        }
    }

    @Override
    public void redo() {
        Set<Map.Entry<INews.State, List<NewsReference>>> entries = this.fOldStates.entrySet();
        for (Map.Entry<INews.State, List<NewsReference>> entry : entries) {
            INews.State oldState = entry.getKey();
            List<NewsReference> newsRefs = entry.getValue();
            ArrayList<INews> resolvedNews = new ArrayList<INews>(newsRefs.size());
            for (NewsReference newsRef : newsRefs) {
                INews news = newsRef.resolve();
                if (news == null || news.getState() != oldState) continue;
                resolvedNews.add(news);
            }
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            this.fNewsDao.setState(resolvedNews, this.fNewState, this.fAffectEquivalentNews, false);
        }
    }

    @Override
    public boolean isLongRunning() {
        return this.fNewsCount > 50;
    }
}

