/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.PerformAfterInputSet;

public class FeedViewInput
implements IEditorInput {
    private static final String FACTORY_ID = "org.rssowl.ui.FeedViewFactory";
    private static final String RESTORE_QUALIFIER = "/instance/org.eclipse.ui.workbench/";
    private static final String RESTORE_KEY = "USE_IPERSISTABLE_EDITORS";
    static final String MARK_INPUT_CLASS = "org.rssowl.ui.internal.editors.feed.MarkInputClass";
    static final String MARK_INPUT_ID = "org.rssowl.ui.internal.editors.feed.MarkInputId";
    private final INewsMark fMark;
    private boolean fIsDeleted;
    private final PerformAfterInputSet fPerformOnInputSet;

    public FeedViewInput(INewsMark mark) {
        this(mark, null);
    }

    public FeedViewInput(INewsMark mark, PerformAfterInputSet performOnInputSet) {
        Assert.isNotNull((Object)mark);
        this.fMark = mark;
        this.fPerformOnInputSet = performOnInputSet;
    }

    public boolean exists() {
        return !this.fIsDeleted;
    }

    public void setDeleted() {
        this.fIsDeleted = true;
    }

    public PerformAfterInputSet getPerformOnInputSet() {
        return this.fPerformOnInputSet;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fMark instanceof IBookMark) {
            IBookMark bookmark = (IBookMark)this.fMark;
            ImageDescriptor favicon = OwlUI.getFavicon(bookmark);
            if (favicon != null) {
                return favicon;
            }
            return OwlUI.BOOKMARK;
        }
        if (this.fMark instanceof ISearchMark) {
            return OwlUI.SEARCHMARK;
        }
        if (this.fMark instanceof INewsBin) {
            if (this.fMark.getProperty(DefaultPreferences.ARCHIVE_BIN_MARKER) != null) {
                return OwlUI.ARCHIVE;
            }
            return OwlUI.NEWSBIN;
        }
        if (this.fMark instanceof FolderNewsMark) {
            return OwlUI.FOLDER;
        }
        return OwlUI.UNKNOWN;
    }

    public String getName() {
        return this.fMark.getName();
    }

    public IPersistableElement getPersistable() {
        boolean restore = Platform.getPreferencesService().getBoolean(RESTORE_QUALIFIER, RESTORE_KEY, true, null);
        if (!restore) {
            return null;
        }
        return new IPersistableElement(){

            public String getFactoryId() {
                return FeedViewInput.FACTORY_ID;
            }

            public void saveState(IMemento memento) {
                memento.putString(FeedViewInput.MARK_INPUT_CLASS, FeedViewInput.this.fMark.getClass().getName());
                memento.putString(FeedViewInput.MARK_INPUT_ID, String.valueOf(FeedViewInput.this.fMark.getId()));
            }
        };
    }

    public String getToolTipText() {
        return this.fMark.getName();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public INewsMark getMark() {
        return this.fMark;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fMark.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FeedViewInput type = (FeedViewInput)obj;
        return this.fMark.equals(type.fMark);
    }
}

