/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DAOService;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ReparentInfo;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.properties.Messages;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.util.UIBackgroundJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralPropertyPage
implements IEntityPropertyPage {
    private static final long DAY_IN_SECONDS = 86400L;
    private static final long HOUR_IN_SECONDS = 3600L;
    private static final long MINUTE_IN_SECONDS = 60L;
    private static final int SECONDS_SCOPE = 0;
    private static final int MINUTES_SCOPE = 1;
    private static final int HOURS_SCOPE = 2;
    private static final int DAYS_SCOPE = 3;
    private Composite fParent;
    private IPropertyDialogSite fSite;
    private List<IEntity> fEntities;
    private Text fNameInput;
    private Text fFeedInput;
    private FolderChooser fFolderChooser;
    private Button fOpenOnStartupCheck;
    private Button fReloadOnStartupCheck;
    private boolean fReloadRequired;
    private boolean fSettingsChanged;
    private boolean fIsSingleBookMark;
    private boolean fIsSingleSynchronizedBookMark;
    private List<IPreferenceScope> fEntityPreferences;
    private boolean fPrefUpdateIntervalState;
    private long fPrefUpdateInterval;
    private boolean fPrefOpenOnStartup;
    private boolean fPrefReloadOnStartup;
    private Spinner fReloadSpinner;
    private int fUpdateIntervalScope;
    private Button fUpdateCheck;
    private Combo fReloadCombo;

    @Override
    public void init(IPropertyDialogSite site, List<IEntity> entities) {
        Assert.isTrue((!entities.isEmpty() ? 1 : 0) != 0);
        this.fSite = site;
        this.fEntities = entities;
        this.fEntityPreferences = new ArrayList<IPreferenceScope>(this.fEntities.size());
        for (IEntity entity : entities) {
            this.fEntityPreferences.add(Owl.getPreferenceService().getEntityScope(entity));
        }
        this.loadInitialSettings();
        if (this.fEntities.size() == 1 && this.fEntities.get(0) instanceof IBookMark) {
            this.fIsSingleBookMark = true;
            this.fIsSingleSynchronizedBookMark = SyncUtils.isSynchronized((IBookMark)((IBookMark)this.fEntities.get(0)));
        }
    }

    private void loadInitialSettings() {
        IPreferenceScope firstScope = this.fEntityPreferences.get(0);
        this.fPrefUpdateIntervalState = firstScope.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE);
        this.fPrefUpdateInterval = firstScope.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
        this.fPrefOpenOnStartup = firstScope.getBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP);
        this.fPrefReloadOnStartup = firstScope.getBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP);
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        int i = 1;
        while (i < this.fEntityPreferences.size()) {
            IPreferenceScope otherScope = this.fEntityPreferences.get(i);
            if (otherScope.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE) != this.fPrefUpdateIntervalState) {
                this.fPrefUpdateIntervalState = defaultScope.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE);
            }
            if (otherScope.getLong(DefaultPreferences.BM_UPDATE_INTERVAL) != this.fPrefUpdateInterval) {
                this.fPrefUpdateInterval = defaultScope.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
            }
            if (otherScope.getBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP) != this.fPrefOpenOnStartup) {
                this.fPrefOpenOnStartup = defaultScope.getBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP);
            }
            if (otherScope.getBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP) != this.fPrefReloadOnStartup) {
                this.fPrefReloadOnStartup = defaultScope.getBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP);
            }
            ++i;
        }
        this.fUpdateIntervalScope = this.getUpdateIntervalScope();
    }

    @Override
    public Control createContents(Composite parent) {
        IFolder sameParent;
        this.fParent = parent;
        boolean separateFromTop = false;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        if (this.fEntities.size() == 1) {
            IEntity entity = this.fEntities.get(0);
            separateFromTop = true;
            if (entity instanceof IBookMark) {
                Label feedLabel = new Label(container, 0);
                feedLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                feedLabel.setText(Messages.GeneralPropertyPage_LINK);
                this.fFeedInput = this.fIsSingleSynchronizedBookMark ? new Text(container, 2056) : new Text(container, 2048);
                this.fFeedInput.setLayoutData((Object)new GridData(4, 1, true, false));
                String feedLink = ((IBookMark)entity).getFeedLinkReference().getLinkAsText();
                this.fFeedInput.setText(this.fIsSingleSynchronizedBookMark ? URIUtils.toHTTP((String)feedLink) : feedLink);
                ((GridData)this.fFeedInput.getLayoutData()).widthHint = this.fSite.getHorizontalPixels(200);
                Label nameLabel = new Label(container, 0);
                nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                nameLabel.setText(Messages.GeneralPropertyPage_NAME);
                Composite nameContainer = new Composite(container, Application.IS_MAC ? 0 : 2048);
                nameContainer.setLayoutData((Object)new GridData(4, 1, true, false));
                nameContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
                if (!Application.IS_MAC) {
                    nameContainer.setBackground(container.getDisplay().getSystemColor(25));
                }
                this.fNameInput = new Text(nameContainer, Application.IS_MAC ? 2048 : 0);
                OwlUI.makeAccessible((Control)this.fNameInput, (Control)nameLabel);
                this.fNameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
                this.fNameInput.setText(this.getName(entity));
                ToolBar grabTitleBar = new ToolBar(nameContainer, 0x800000);
                OwlUI.makeAccessible((Control)grabTitleBar, Messages.GeneralPropertyPage_LOAD_NAME);
                if (!Application.IS_MAC) {
                    grabTitleBar.setBackground(container.getDisplay().getSystemColor(25));
                }
                ToolItem grabTitleItem = new ToolItem(grabTitleBar, 8);
                grabTitleItem.setImage(OwlUI.getImage(this.fSite.getResourceManager(), "icons/etool16/info.gif"));
                grabTitleItem.setToolTipText(Messages.GeneralPropertyPage_LOAD_NAME);
                grabTitleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GeneralPropertyPage.this.onGrabTitle();
                    }
                });
            } else {
                Label nameLabel = new Label(container, 0);
                nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                nameLabel.setText(Messages.GeneralPropertyPage_NAME);
                this.fNameInput = new Text(container, 2048);
                OwlUI.makeAccessible((Control)this.fNameInput, (Control)nameLabel);
                this.fNameInput.setLayoutData((Object)new GridData(4, 1, true, false));
                this.fNameInput.setText(this.getName(entity));
            }
        }
        if ((sameParent = this.getSameParent(this.fEntities)) != null) {
            separateFromTop = true;
            Label locationLabel = new Label(container, 0);
            locationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            locationLabel.setText(Messages.GeneralPropertyPage_LOCATION);
            ArrayList<IFolder> excludes = new ArrayList<IFolder>();
            for (IEntity entity : this.fEntities) {
                if (!(entity instanceof IFolder)) continue;
                excludes.add((IFolder)entity);
            }
            this.fFolderChooser = new FolderChooser(container, sameParent, excludes, 2048, true);
            this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
            this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
            this.fFolderChooser.setBackground(container.getDisplay().getSystemColor(25));
        }
        Composite otherSettingsContainer = new Composite(container, 0);
        otherSettingsContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        otherSettingsContainer.setLayoutData((Object)new GridData(4, 1, true, true, 2, 1));
        if (separateFromTop) {
            ((GridLayout)otherSettingsContainer.getLayout()).marginTop = 10;
        }
        if (!this.containsNewsBin(this.fEntities)) {
            Composite autoReloadContainer = new Composite(otherSettingsContainer, 0);
            autoReloadContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
            autoReloadContainer.setLayoutData((Object)new GridData(4, 1, true, true));
            this.fUpdateCheck = new Button(autoReloadContainer, 32);
            if (this.fIsSingleBookMark) {
                this.fUpdateCheck.setText(Messages.GeneralPropertyPage_UPDATE_FEED);
            } else {
                this.fUpdateCheck.setText(Messages.GeneralPropertyPage_UPDATE_FEEDS);
            }
            this.fUpdateCheck.setSelection(this.fPrefUpdateIntervalState);
            this.fUpdateCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GeneralPropertyPage.this.fReloadSpinner.setEnabled(GeneralPropertyPage.this.fUpdateCheck.getSelection());
                    GeneralPropertyPage.this.fReloadCombo.setEnabled(GeneralPropertyPage.this.fUpdateCheck.getSelection());
                }
            });
            this.fReloadSpinner = new Spinner(autoReloadContainer, 2048);
            this.fReloadSpinner.setMinimum(1);
            this.fReloadSpinner.setMaximum(999);
            this.fReloadSpinner.setEnabled(this.fPrefUpdateIntervalState);
            if (this.fUpdateIntervalScope == 0) {
                this.fReloadSpinner.setSelection((int)this.fPrefUpdateInterval);
            } else if (this.fUpdateIntervalScope == 1) {
                this.fReloadSpinner.setSelection((int)(this.fPrefUpdateInterval / 60L));
            } else if (this.fUpdateIntervalScope == 2) {
                this.fReloadSpinner.setSelection((int)(this.fPrefUpdateInterval / 3600L));
            } else if (this.fUpdateIntervalScope == 3) {
                this.fReloadSpinner.setSelection((int)(this.fPrefUpdateInterval / 86400L));
            }
            this.fReloadCombo = new Combo(autoReloadContainer, 8);
            this.fReloadCombo.add(Messages.GeneralPropertyPage_SECONDS);
            this.fReloadCombo.add(Messages.GeneralPropertyPage_MINUTES);
            this.fReloadCombo.add(Messages.GeneralPropertyPage_HOURS);
            this.fReloadCombo.add(Messages.GeneralPropertyPage_DAYS);
            this.fReloadCombo.select(this.fUpdateIntervalScope);
            this.fReloadCombo.setEnabled(this.fPrefUpdateIntervalState);
            this.fReloadOnStartupCheck = new Button(otherSettingsContainer, 32);
            this.fReloadOnStartupCheck.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fReloadOnStartupCheck.setText(this.fEntities.size() == 1 ? Messages.GeneralPropertyPage_AUTO_UPDATE_FEED_STARTUP : Messages.GeneralPropertyPage_AUTO_UPDATE_FEEDS_STARTUP);
            this.fReloadOnStartupCheck.setSelection(this.fPrefReloadOnStartup);
        }
        this.fOpenOnStartupCheck = new Button(otherSettingsContainer, 32);
        this.fOpenOnStartupCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fOpenOnStartupCheck.setText(this.getOpenOnStartupSettingName());
        this.fOpenOnStartupCheck.setSelection(this.fPrefOpenOnStartup);
        return container;
    }

    @Override
    public ImageDescriptor getImage() {
        return null;
    }

    private String getOpenOnStartupSettingName() {
        if (this.fEntities.size() == 1) {
            if (this.fEntities.get(0) instanceof INewsBin) {
                return Messages.GeneralPropertyPage_DISPLAY_BIN_ONSTARTUP;
            }
            if (this.fEntities.get(0) instanceof IBookMark) {
                return Messages.GeneralPropertyPage_DISPLAY_FEED_ONSTARTUP;
            }
            return Messages.GeneralPropertyPage_DISPLAY_FEEDS_ONSTARTUP;
        }
        boolean containsBin = false;
        boolean containsBookMarkOrFolder = false;
        for (IEntity entity : this.fEntities) {
            if (entity instanceof IFolder || entity instanceof IBookMark) {
                containsBookMarkOrFolder = true;
                continue;
            }
            if (!(entity instanceof INewsBin)) continue;
            containsBin = true;
        }
        if (containsBin && containsBookMarkOrFolder) {
            return Messages.GeneralPropertyPage_DISPLAY_ELEMENTS_ONSTARTUP;
        }
        if (containsBin) {
            return Messages.GeneralPropertyPage_DISPLAY_BINS_ONSTARTUP;
        }
        return Messages.GeneralPropertyPage_DISPLAY_FEEDS_ONSTARTUP;
    }

    private boolean containsNewsBin(List<IEntity> entities) {
        for (IEntity entity : entities) {
            if (!(entity instanceof INewsBin)) continue;
            return true;
        }
        return false;
    }

    private void onGrabTitle() {
        if (StringUtils.isSet((String)this.fFeedInput.getText())) {
            this.fFeedInput.getShell().setCursor(this.fFeedInput.getDisplay().getSystemCursor(3));
            final String linkText = this.fFeedInput.getText();
            JobRunner.runUIUpdater(new UIBackgroundJob((Control)this.fFeedInput.getShell()){
                private String fLabel;

                protected void runInBackground(IProgressMonitor monitor) {
                    try {
                        URI link = new URI(URIUtils.fastEncode((String)linkText));
                        this.fLabel = Owl.getConnectionService().getLabel(link, monitor);
                    }
                    catch (ConnectionException connectionException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }

                protected void runInUI(IProgressMonitor monitor) {
                    if (StringUtils.isSet((String)this.fLabel)) {
                        GeneralPropertyPage.this.fNameInput.setText(this.fLabel);
                    }
                    GeneralPropertyPage.this.fFeedInput.getShell().setCursor(null);
                }
            });
        }
    }

    @Override
    public void setFocus() {
        if (this.fFeedInput != null && !this.fIsSingleSynchronizedBookMark) {
            this.fFeedInput.setFocus();
            this.fFeedInput.selectAll();
        } else if (this.fNameInput != null) {
            this.fNameInput.setFocus();
            this.fNameInput.selectAll();
        }
    }

    private IFolder getSameParent(List<IEntity> entities) {
        IFolder parent = null;
        for (IEntity entity : entities) {
            if (!(entity instanceof IFolderChild)) {
                return null;
            }
            IFolderChild folderChild = (IFolderChild)entity;
            IFolder folder = folderChild.getParent();
            if (parent == null) {
                parent = folder;
                continue;
            }
            if (parent == folder) continue;
            return null;
        }
        return parent;
    }

    private int getUpdateIntervalScope() {
        if (this.fPrefUpdateInterval % 86400L == 0L) {
            return 3;
        }
        if (this.fPrefUpdateInterval % 3600L == 0L) {
            return 2;
        }
        if (this.fPrefUpdateInterval % 60L == 0L) {
            return 1;
        }
        return 0;
    }

    private String getName(IEntity entity) {
        if (entity instanceof IFolder) {
            return ((IFolder)entity).getName();
        }
        if (entity instanceof IMark) {
            return ((IMark)entity).getName();
        }
        return "";
    }

    @Override
    public boolean performOk(Set<IEntity> entitiesToSave) {
        boolean proceed;
        if (this.fEntities.size() == 1 && !(proceed = this.internalPerformSingle(entitiesToSave))) {
            return false;
        }
        for (IPreferenceScope scope : this.fEntityPreferences) {
            if (!this.updatePreferences(scope)) continue;
            IEntity entityToSave = this.fEntities.get(this.fEntityPreferences.indexOf(scope));
            entitiesToSave.add(entityToSave);
            this.fSettingsChanged = true;
        }
        for (IEntity entity : this.fEntities) {
            if (!this.fSettingsChanged || !(entity instanceof IFolder)) continue;
            this.updateChildPreferences((IFolder)entity);
        }
        return true;
    }

    private boolean internalPerformSingle(Set<IEntity> entitiesToSave) {
        INewsBin newsbin;
        IEntity entity = this.fEntities.get(0);
        if (entity instanceof IBookMark && this.fFeedInput.getText().length() == 0) {
            this.fSite.select(this);
            this.fFeedInput.setFocus();
            this.fSite.setMessage(Messages.GeneralPropertyPage_ENTER_LINK, IPropertyDialogSite.MessageType.ERROR);
            return false;
        }
        if (this.fNameInput.getText().length() == 0) {
            this.fSite.select(this);
            this.fNameInput.setFocus();
            if (entity instanceof IFolder) {
                this.fSite.setMessage(Messages.GeneralPropertyPage_ENTER_NAME_FOLDER, IPropertyDialogSite.MessageType.ERROR);
            } else if (entity instanceof IBookMark) {
                this.fSite.setMessage(Messages.GeneralPropertyPage_ENTER_NAME_BOOKMARK, IPropertyDialogSite.MessageType.ERROR);
            } else if (entity instanceof INewsBin) {
                this.fSite.setMessage(Messages.GeneralPropertyPage_ENTER_NAME_BIN, IPropertyDialogSite.MessageType.ERROR);
            }
            return false;
        }
        if (entity instanceof IFolder) {
            IFolder folder = (IFolder)entity;
            if (!folder.getName().equals(this.fNameInput.getText())) {
                folder.setName(this.fNameInput.getText());
                entitiesToSave.add((IEntity)folder);
            }
        } else if (entity instanceof IBookMark) {
            String uriAsString;
            IBookMark bookmark = (IBookMark)entity;
            if (!bookmark.getName().equals(this.fNameInput.getText())) {
                bookmark.setName(this.fNameInput.getText());
                entitiesToSave.add((IEntity)bookmark);
            }
            if (URIUtils.looksLikeLink((String)(uriAsString = URIUtils.fastEncode((String)this.fFeedInput.getText())))) {
                uriAsString = URIUtils.ensureProtocol((String)uriAsString);
            }
            if (!this.fIsSingleSynchronizedBookMark && !bookmark.getFeedLinkReference().getLinkAsText().equals(uriAsString)) {
                boolean containsNews;
                boolean bl = containsNews = ModelUtils.countNews(bookmark) > 0;
                if (containsNews) {
                    String msg = Messages.GeneralPropertyPage_CHANGE_LINK_WARNING;
                    MessageDialog dialog = new MessageDialog(this.fParent.getShell(), Messages.GeneralPropertyPage_WARNING, null, msg, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                    if (dialog.open() == 1) {
                        return false;
                    }
                }
                try {
                    DAOService daoService = Owl.getPersistenceService().getDAOService();
                    URI newFeedLink = new URI(uriAsString.trim());
                    this.fReloadRequired = true;
                    if (!daoService.getFeedDAO().exists(newFeedLink)) {
                        IFeed feed = Owl.getModelFactory().createFeed(null, newFeedLink);
                        feed = (IFeed)DynamicDAO.save((IPersistable)feed);
                    }
                    FeedLinkReference oldFeedRef = bookmark.getFeedLinkReference();
                    if (daoService.getBookMarkDAO().loadAll(oldFeedRef).size() == 1) {
                        DynamicDAO.delete((IPersistable)oldFeedRef.resolve());
                    }
                    bookmark.setFeedLinkReference(new FeedLinkReference(newFeedLink));
                    entitiesToSave.add((IEntity)bookmark);
                    OwlUI.deleteImage(bookmark.getId());
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.fSite.select(this);
                    this.fFeedInput.selectAll();
                    this.fFeedInput.setFocus();
                    this.fSite.setMessage(Messages.GeneralPropertyPage_INVALID_LINK, IPropertyDialogSite.MessageType.ERROR);
                    return false;
                }
            }
        } else if (entity instanceof INewsBin && !(newsbin = (INewsBin)entity).getName().equals(this.fNameInput.getText())) {
            newsbin.setName(this.fNameInput.getText());
            entitiesToSave.add((IEntity)newsbin);
        }
        return true;
    }

    @Override
    public void finish() {
        IFolder sameParent;
        if (this.fReloadRequired && this.fEntities.size() == 1) {
            Controller.getDefault().reloadQueued((IBookMark)this.fEntities.get(0), null, this.getWorkbenchShell());
        }
        if ((sameParent = this.getSameParent(this.fEntities)) != null && sameParent != this.fFolderChooser.getFolder()) {
            ArrayList<ReparentInfo> reparenting = new ArrayList<ReparentInfo>();
            for (IEntity entity : this.fEntities) {
                if (!(entity instanceof IFolderChild)) continue;
                IFolderChild folderChild = (IFolderChild)entity;
                reparenting.add(ReparentInfo.create((Object)folderChild, (Object)this.fFolderChooser.getFolder(), null, null));
            }
            CoreUtils.reparentWithProperties(reparenting);
        }
    }

    private Shell getWorkbenchShell() {
        IWorkbenchWindow wWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wWindow != null) {
            return wWindow.getShell();
        }
        return null;
    }

    private boolean updatePreferences(IPreferenceScope scope) {
        boolean bVal;
        boolean changed = false;
        if (this.fUpdateCheck != null && this.fPrefUpdateIntervalState != (bVal = this.fUpdateCheck.getSelection())) {
            scope.putBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE, bVal);
            changed = true;
        }
        if (this.fReloadCombo != null) {
            this.fUpdateIntervalScope = this.fReloadCombo.getSelectionIndex();
            long lVal = this.fUpdateIntervalScope == 0 ? (long)this.fReloadSpinner.getSelection() : (this.fUpdateIntervalScope == 1 ? (long)this.fReloadSpinner.getSelection() * 60L : (this.fUpdateIntervalScope == 2 ? (long)this.fReloadSpinner.getSelection() * 3600L : (long)this.fReloadSpinner.getSelection() * 86400L));
            if (this.fPrefUpdateInterval != lVal) {
                scope.putLong(DefaultPreferences.BM_UPDATE_INTERVAL, lVal);
                changed = true;
            }
        }
        if (this.fOpenOnStartupCheck != null && this.fPrefOpenOnStartup != (bVal = this.fOpenOnStartupCheck.getSelection())) {
            scope.putBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP, bVal);
            changed = true;
        }
        if (this.fReloadOnStartupCheck != null && this.fPrefReloadOnStartup != (bVal = this.fReloadOnStartupCheck.getSelection())) {
            scope.putBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP, bVal);
            changed = true;
        }
        return changed;
    }

    private void updateChildPreferences(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark)) continue;
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)mark);
            this.updatePreferences(scope);
        }
        List folders = folder.getFolders();
        for (IFolder childFolder : folders) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)childFolder);
            this.updatePreferences(scope);
            this.updateChildPreferences(childFolder);
        }
    }
}

