/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

public class AddCredentialsDialog
extends Dialog {
    private Text fSiteInput;
    private Text fUsernameInput;
    private Text fPasswordInput;
    private String fSiteValue;
    private String fUsernameValue;
    private String fPasswordValue;
    private Set<String> fFeedLinks;
    private Label fInfoImg;
    private Label fInfoText;
    private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

    public AddCredentialsDialog(Shell parentShell) {
        super(parentShell);
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void okPressed() {
        if (this.fFeedLinks == null || !this.fFeedLinks.contains(this.fSiteInput.getText())) {
            this.showError();
            this.fSiteInput.setFocus();
            this.fSiteInput.selectAll();
            return;
        }
        this.fSiteValue = this.fSiteInput.getText();
        this.fUsernameValue = this.fUsernameInput.getText();
        this.fPasswordValue = this.fPasswordInput.getText();
        super.okPressed();
    }

    public String getSite() {
        return this.fSiteValue;
    }

    public String getUsername() {
        return this.fUsernameValue;
    }

    public String getPassword() {
        return this.fPasswordValue;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label siteLabel = new Label(composite, 0);
        siteLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        siteLabel.setText(Messages.AddCredentialsDialog_LINK);
        this.fSiteInput = new Text(composite, 2052);
        this.fSiteInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fSiteInput.setText("http://");
        this.fSiteInput.setSelection("http://".length());
        this.fSiteInput.setFocus();
        this.fSiteInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddCredentialsDialog.this.updateOkButton();
            }
        });
        final Pair<SimpleContentProposalProvider, ContentProposalAdapter> pair = OwlUI.hookAutoComplete(this.fSiteInput, null, true, false);
        JobRunner.runInBackgroundThread(100, new Runnable(){

            public void run() {
                if (!AddCredentialsDialog.this.fSiteInput.isDisposed()) {
                    TreeSet<String> values = new TreeSet<String>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                    values.addAll(CoreUtils.getFeedLinks());
                    values.add("https://www.google.com/accounts/ClientLogin");
                    AddCredentialsDialog.this.fFeedLinks = new HashSet<String>(values);
                    if (!AddCredentialsDialog.this.fSiteInput.isDisposed()) {
                        OwlUI.applyAutoCompleteProposals(values, (SimpleContentProposalProvider)pair.getFirst(), (ContentProposalAdapter)pair.getSecond(), false);
                    }
                }
            }
        });
        Label usernameLabel = new Label(composite, 0);
        usernameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        usernameLabel.setText(Messages.AddCredentialsDialog_USERNAME);
        this.fUsernameInput = new Text(composite, 2052);
        this.fUsernameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fUsernameInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddCredentialsDialog.this.updateOkButton();
            }
        });
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        passwordLabel.setText(Messages.AddCredentialsDialog_PASSWORD);
        this.fPasswordInput = new Text(composite, 0x400804);
        this.fPasswordInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fPasswordInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddCredentialsDialog.this.updateOkButton();
            }
        });
        Composite infoContainer = new Composite(composite, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)infoContainer.getLayout()).marginTop = 15;
        this.fInfoImg = new Label(infoContainer, 0);
        this.fInfoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fInfoImg.setImage(OwlUI.getImage(this.fResources, "icons/obj16/info.gif"));
        this.fInfoText = new Label(infoContainer, 64);
        this.fInfoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fInfoText.setText(Messages.AddCredentialsDialog_ENTER_EXISTING_FEED_LINK);
        AddCredentialsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddCredentialsDialog_ADD_PASSWORD);
    }

    private void updateOkButton() {
        this.getButton(0).setEnabled(StringUtils.isSet((String)this.fSiteInput.getText()) && (StringUtils.isSet((String)this.fUsernameInput.getText()) || StringUtils.isSet((String)this.fPasswordInput.getText())));
    }

    private void showError() {
        this.fInfoImg.setImage(OwlUI.getImage(this.fResources, "icons/obj16/error.gif"));
        this.fInfoImg.getParent().getParent().layout();
    }

    protected int getShellStyle() {
        int style = 0x10870 | AddCredentialsDialog.getDefaultOrientation();
        return style;
    }

    protected Control createButtonBar(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }
}

