/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.ITheme;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.MonitorCanceledException;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.dao.IPreferenceDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.FolderReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationWorkbenchAdvisor;
import org.rssowl.ui.internal.ApplicationWorkbenchWindowAdvisor;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.dialogs.CustomWizardDialog;
import org.rssowl.ui.internal.dialogs.LoginDialog;
import org.rssowl.ui.internal.editors.browser.WebBrowserInput;
import org.rssowl.ui.internal.editors.browser.WebBrowserView;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.PerformAfterInputSet;
import org.rssowl.ui.internal.util.ContentAssistAdapter;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwlUI {
    public static final String M_TOOLS = "tools";
    public static final String M_MARK = "mark";
    public static final String M_OPEN = "open";
    public static final ImageDescriptor UNKNOWN = Activator.getImageDescriptor("icons/obj16/default.gif");
    public static final ImageDescriptor FOLDER = Activator.getImageDescriptor("icons/obj16/folder.gif");
    public static final ImageDescriptor FOLDER_NEW = Activator.getImageDescriptor("icons/obj16/folder_new.gif");
    public static final ImageDescriptor BOOKMARK_SET = Activator.getImageDescriptor("icons/obj16/bkmrk_set.gif");
    public static final ImageDescriptor BOOKMARK = Activator.getImageDescriptor("icons/obj16/bookmark.gif");
    public static final ImageDescriptor BOOKMARK_ERROR = Activator.getImageDescriptor("icons/obj16/bkmrk_error.gif");
    public static final ImageDescriptor NEWSBIN = Activator.getImageDescriptor("icons/obj16/newsbin.gif");
    public static final ImageDescriptor NEWSBIN_NEW = Activator.getImageDescriptor("icons/obj16/newsbin_new.gif");
    public static final ImageDescriptor NEWSBIN_EMPTY = Activator.getImageDescriptor("icons/obj16/newsbin_empty.gif");
    public static final ImageDescriptor SEARCHMARK = Activator.getImageDescriptor("icons/obj16/searchmark.gif");
    public static final ImageDescriptor SEARCHMARK_NEW = Activator.getImageDescriptor("icons/obj16/searchmark_new.gif");
    public static final ImageDescriptor SEARCHMARK_EMPTY = Activator.getImageDescriptor("icons/obj16/searchmark_empty.gif");
    public static final ImageDescriptor GROUP = Activator.getImageDescriptor("icons/obj16/group.gif");
    public static final ImageDescriptor NEWS_STATE_UNREAD = Activator.getImageDescriptor("icons/obj16/news_unread.gif");
    public static final ImageDescriptor NEWS_STATE_READ = Activator.getImageDescriptor("icons/obj16/news_read.gif");
    public static final ImageDescriptor NEWS_STATE_NEW = Activator.getImageDescriptor("icons/obj16/news_new.gif");
    public static final ImageDescriptor NEWS_STATE_UPDATED = Activator.getImageDescriptor("icons/obj16/news_updated.gif");
    public static final ImageDescriptor NEWS_PIN = Activator.getImageDescriptor("icons/obj16/news_pin.gif");
    public static final ImageDescriptor NEWS_PINNED = Activator.getImageDescriptor("icons/obj16/news_pinned.gif");
    public static final ImageDescriptor TRAY_OWL = Activator.getImageDescriptor("icons/elcl16/trayowl.png");
    public static final ImageDescriptor TRAY_OWL_TEASING = Activator.getImageDescriptor("icons/elcl16/trayowl_tease.png");
    public static final ImageDescriptor INFO = Activator.getImageDescriptor("icons/obj16/info.gif");
    public static final ImageDescriptor WARNING = Activator.getImageDescriptor("icons/obj16/warning.gif");
    public static final ImageDescriptor ERROR = Activator.getImageDescriptor("icons/obj16/error.gif");
    public static final ImageDescriptor ATTACHMENT = Activator.getImageDescriptor("icons/obj16/attachment.gif");
    public static final ImageDescriptor COLUMNS = Activator.getImageDescriptor("icons/etool16/columns.gif");
    public static final ImageDescriptor SHARE = Activator.getImageDescriptor("icons/elcl16/share.gif");
    public static final ImageDescriptor FILTER = Activator.getImageDescriptor("icons/etool16/filter.gif");
    public static final ImageDescriptor ARCHIVE = Activator.getImageDescriptor("icons/etool16/archive.gif");
    public static final ImageDescriptor ARCHIVE_NEW = Activator.getImageDescriptor("icons/obj16/archive_new.gif");
    public static final ImageDescriptor ARCHIVE_DISABLED = Activator.getImageDescriptor("icons/dtool16/archive.gif");
    public static final RGB GROUP_FG_COLOR = new RGB(0, 0, 128);
    public static final RGB GROUP_BG_COLOR = new RGB(235, 235, 235);
    public static final RGB GROUP_GRADIENT_FG_COLOR = new RGB(250, 250, 250);
    public static final RGB GROUP_GRADIENT_BG_COLOR = new RGB(220, 220, 220);
    public static final RGB GROUP_GRADIENT_END_COLOR = new RGB(200, 200, 200);
    public static final int MIN_DIALOG_WIDTH_DLU = 320;
    public static final String NEWS_TEXT_FONT_ID = "org.rssowl.ui.NewsTextFont";
    public static final String HEADLINES_FONT_ID = "org.rssowl.ui.HeadlinesFont";
    public static final String BKMRK_EXPLORER_FONT_ID = "org.rssowl.ui.BookmarkExplorerFont";
    public static final String NOTIFICATION_POPUP_FONT_ID = "org.rssowl.ui.NotificationPopupFont";
    public static final String DIALOG_FONT_ID = "org.eclipse.jface.dialogfont";
    public static final String STICKY_BG_COLOR_ID = "org.rssowl.ui.StickyBGColor";
    public static final String SEARCH_HIGHLIGHT_BG_COLOR_ID = "org.rssowl.ui.SearchHighlightBGColor";
    public static final String NEWS_LIST_BG_COLOR_ID = "org.rssowl.ui.NewsListBackgroundColor";
    public static final String LINK_FG_COLOR_ID = "org.rssowl.ui.LinkFGColor";
    private static final String HIGH_CONTRAST_THEME = "org.eclipse.ui.ide.systemDefault";
    private static final Map<Long, ImageDescriptor> FAVICO_CACHE = new HashMap<Long, ImageDescriptor>();
    private static final Map<String, ImageDescriptor> DESCRIPTOR_CACHE = new HashMap<String, ImageDescriptor>();
    private static final Map<String, String> fgImageUriMap = new ConcurrentHashMap<String, String>();
    private static final String ICONS_FOLDER = "icons";
    private static Clipboard fgClipboard;
    private static OSTheme fgCachedOSTheme;
    private static int DATE_WIDTH;
    private static int STATE_WIDTH;
    private static final int DEFAULT_NEWS_TEXT_FONT_HEIGHT = 10;
    private static final String SHORT_DATE_FORMAT_PROPERTY = "shortDateFormat";
    private static final String LONG_DATE_FORMAT_PROPERTY = "longDateFormat";
    private static final String SHORT_TIME_FORMAT_PROPERTY = "shortTimeFormat";
    private static final int WINDOWS_PACKED_WIZARD_WIDTH = 380;
    private static final int LINUX_PACKED_WIZARD_WIDTH = 370;
    private static final int MAC_PACKED_WIZARD_WIDTH = 300;
    private static final Map<String, RGB> fgMapCommonColorToRGB;
    private static final Map<String, String> fgMapMimeToExtension;

    static {
        DATE_WIDTH = -1;
        STATE_WIDTH = -1;
        fgMapCommonColorToRGB = new HashMap<String, RGB>();
        fgMapMimeToExtension = new HashMap<String, String>();
        fgMapMimeToExtension.put("audio/mpeg", "mp3");
        fgMapMimeToExtension.put("audio/mpeg3", "mp3");
        fgMapMimeToExtension.put("audio/x-mpeg3", "mp3");
        fgMapMimeToExtension.put("audio/mpeg4", "mp4");
        fgMapMimeToExtension.put("audio/x-mpeg4", "mp4");
        fgMapMimeToExtension.put("audio/aac", "aac");
        fgMapMimeToExtension.put("audio/aacp", "aac");
        fgMapMimeToExtension.put("image/bmp", "bmp");
        fgMapMimeToExtension.put("image/x-windows-bmp", "bmp");
        fgMapMimeToExtension.put("image/gif", "gif");
        fgMapMimeToExtension.put("image/jpeg", "jpg");
        fgMapMimeToExtension.put("image/pjpeg", "jpg");
        fgMapMimeToExtension.put("image/png", "png");
        fgMapMimeToExtension.put("image/x-quicktime", "qti");
        fgMapMimeToExtension.put("video/x-ms-asf", "asd");
        fgMapMimeToExtension.put("application/x-troff-msvideo", "avi");
        fgMapMimeToExtension.put("video/avi", "avi");
        fgMapMimeToExtension.put("video/msvideo", "avi");
        fgMapMimeToExtension.put("video/x-msvideo", "avi");
        fgMapMimeToExtension.put("video/x-flv", "flv");
        fgMapMimeToExtension.put("video/quicktime", "mov");
        fgMapMimeToExtension.put("application/msword", "doc");
        fgMapMimeToExtension.put("application/pdf", "pdf");
        fgMapMimeToExtension.put("application/rtf", "rtf");
        fgMapMimeToExtension.put("text/richtext", "rtf");
        fgMapMimeToExtension.put("application/x-rtf", "rtf");
        fgMapCommonColorToRGB.put("0,0,0", new RGB(0, 0, 0));
        fgMapCommonColorToRGB.put("124,10,2", new RGB(124, 10, 2));
        fgMapCommonColorToRGB.put("163,21,2", new RGB(163, 21, 2));
        fgMapCommonColorToRGB.put("214,148,99", new RGB(214, 148, 99));
        fgMapCommonColorToRGB.put("200,118,10", new RGB(200, 118, 10));
        fgMapCommonColorToRGB.put("240,177,12", new RGB(240, 177, 12));
        fgMapCommonColorToRGB.put("209,161,17", new RGB(209, 161, 17));
        fgMapCommonColorToRGB.put("136,128,54", new RGB(136, 128, 54));
        fgMapCommonColorToRGB.put("129,150,93", new RGB(129, 150, 93));
        fgMapCommonColorToRGB.put("82,92,58", new RGB(82, 92, 58));
        fgMapCommonColorToRGB.put("126,135,130", new RGB(126, 135, 130));
        fgMapCommonColorToRGB.put("111,121,174", new RGB(111, 121, 174));
        fgMapCommonColorToRGB.put("92,101,126", new RGB(92, 101, 126));
        fgMapCommonColorToRGB.put("144,152,163", new RGB(144, 152, 163));
        fgMapCommonColorToRGB.put("25,16,17", new RGB(25, 16, 17));
        fgMapCommonColorToRGB.put("82,66,41", new RGB(82, 66, 41));
        fgMapCommonColorToRGB.put("82,16,0", new RGB(82, 16, 0));
        fgMapCommonColorToRGB.put("255,0,0", new RGB(255, 0, 0));
        fgMapCommonColorToRGB.put("0,255,0", new RGB(0, 255, 0));
        fgMapCommonColorToRGB.put("0,0,255", new RGB(0, 0, 255));
    }

    public static OSTheme getOSTheme(Display display) {
        if (fgCachedOSTheme != null) {
            return fgCachedOSTheme;
        }
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (HIGH_CONTRAST_THEME.equals(currentTheme.getId())) {
            fgCachedOSTheme = OSTheme.HIGH_CONTRAST;
            return fgCachedOSTheme;
        }
        RGB widgetBackground = display.getSystemColor(22).getRGB();
        RGB listSelection = display.getSystemColor(26).getRGB();
        fgCachedOSTheme = widgetBackground.equals((Object)new RGB(236, 233, 216)) && listSelection.equals((Object)new RGB(49, 106, 197)) ? OSTheme.WINDOWS_BLUE : (widgetBackground.equals((Object)new RGB(212, 208, 200)) && listSelection.equals((Object)new RGB(10, 36, 106)) ? OSTheme.WINDOWS_CLASSIC : (widgetBackground.equals((Object)new RGB(224, 223, 227)) && listSelection.equals((Object)new RGB(178, 180, 191)) ? OSTheme.WINDOWS_SILVER : (widgetBackground.equals((Object)new RGB(236, 233, 216)) && listSelection.equals((Object)new RGB(147, 160, 112)) ? OSTheme.WINDOWS_OLIVE : OSTheme.OTHER)));
        return fgCachedOSTheme;
    }

    public static boolean isHighContrast() {
        return OwlUI.getOSTheme(Display.getDefault()) == OSTheme.HIGH_CONTRAST;
    }

    public static Clipboard getClipboard() {
        return OwlUI.getClipboard(PlatformUI.getWorkbench().getDisplay());
    }

    public static Clipboard getClipboard(Display display) {
        if (fgClipboard == null) {
            fgClipboard = new Clipboard(display);
        }
        return fgClipboard;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return OwlUI.getImageDescriptor("org.rssowl.ui", path);
    }

    public static ImageDescriptor getImageDescriptor(String pluginId, String path) {
        ImageDescriptor desc = DESCRIPTOR_CACHE.get(String.valueOf(pluginId) + path);
        if (desc == null) {
            desc = Activator.getImageDescriptor(pluginId, path);
            DESCRIPTOR_CACHE.put(String.valueOf(pluginId) + path, desc);
        }
        return desc;
    }

    public static Image getImage(ResourceManager manager, ImageDescriptor descriptor) {
        try {
            return manager.createImage(descriptor);
        }
        catch (DeviceResourceException deviceResourceException) {
            return OwlUI.getDefaultImage(manager);
        }
        catch (SWTException sWTException) {
            return OwlUI.getDefaultImage(manager);
        }
    }

    private static Image getDefaultImage(ResourceManager manager) {
        try {
            return manager.createImage(UNKNOWN);
        }
        catch (DeviceResourceException deviceResourceException) {
            return null;
        }
    }

    public static Image getImage(ResourceManager manager, String path) {
        return OwlUI.getImage(manager, OwlUI.getImageDescriptor(path));
    }

    public static Image getImage(Control owner, String path) {
        LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources(), owner);
        return OwlUI.getImage((ResourceManager)manager, path);
    }

    public static Image getImage(Control owner, ImageDescriptor descriptor) {
        LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources(), owner);
        return OwlUI.getImage((ResourceManager)manager, descriptor);
    }

    public static String getImageUri(String path, String name) {
        String imgUri = fgImageUriMap.get(path);
        if (imgUri != null) {
            return imgUri;
        }
        File imgFile = OwlUI.getImageFile(name);
        if (imgFile.exists()) {
            imgUri = OwlUI.getImageUri(imgFile);
            fgImageUriMap.put(path, imgUri);
            return imgUri;
        }
        try {
            CoreUtils.copy((InputStream)OwlUI.class.getResourceAsStream(path), (OutputStream)new FileOutputStream(imgFile));
            imgUri = OwlUI.getImageUri(imgFile);
            fgImageUriMap.put(path, imgUri);
            return imgUri;
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    private static String getImageUri(File file) {
        URI uri = file.toURI();
        String s = uri.toString();
        return s.replaceFirst("/", "///");
    }

    public static Color getColor(ResourceManager manager, RGB rgb) {
        try {
            return manager.createColor(rgb);
        }
        catch (DeviceResourceException deviceResourceException) {
            return manager.getDevice().getSystemColor(2);
        }
    }

    public static Color getColor(ResourceManager manager, ColorDescriptor descriptor) {
        try {
            return manager.createColor(descriptor);
        }
        catch (DeviceResourceException deviceResourceException) {
            return manager.getDevice().getSystemColor(2);
        }
    }

    public static Color getColor(ResourceManager resources, ILabel label) {
        RGB rgb = OwlUI.getRGB(label);
        return OwlUI.getColor(resources, rgb);
    }

    public static RGB getRGB(ILabel label) {
        return OwlUI.getRGB(label.getColor());
    }

    public static RGB getRGB(String rgb) {
        if (!StringUtils.isSet((String)rgb)) {
            return null;
        }
        RGB commonRGB = fgMapCommonColorToRGB.get(rgb);
        if (commonRGB != null) {
            return commonRGB;
        }
        String[] color = rgb.split(",");
        return new RGB(Integer.parseInt(color[0]), Integer.parseInt(color[1]), Integer.parseInt(color[2]));
    }

    public static String toString(RGB rgb) {
        return String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue;
    }

    public static Font getFont(String key) {
        return JFaceResources.getFontRegistry().get(key);
    }

    public static Font getBold(String key) {
        return JFaceResources.getFontRegistry().getBold(key);
    }

    public static Font getItalic(String key) {
        return JFaceResources.getFontRegistry().getItalic(key);
    }

    public static Font getThemeFont(String key, int style) {
        FontRegistry fontRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        if (fontRegistry != null) {
            if (style == 0) {
                return fontRegistry.get(key);
            }
            if ((style & 1) != 0) {
                return fontRegistry.getBold(key);
            }
            if ((style & 2) != 0) {
                return fontRegistry.getItalic(key);
            }
        }
        return OwlUI.getFont(key);
    }

    public static Color getThemeColor(String key, ResourceManager manager, RGB defaultColor) {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        if (colorRegistry != null) {
            return OwlUI.getColor(manager, colorRegistry.getColorDescriptor(key));
        }
        return OwlUI.getColor(manager, defaultColor);
    }

    public static RGB getThemeRGB(String key, RGB defaultRGB) {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        if (colorRegistry != null) {
            return colorRegistry.getRGB(key);
        }
        return defaultRGB;
    }

    public static Point getTextSize(Drawable drawable, Font font, String text) {
        GC gc = new GC(drawable);
        gc.setFont(font);
        Point p = gc.textExtent(text);
        gc.dispose();
        return p;
    }

    public static ImageDescriptor getFavicon(IBookMark bookmark) {
        if (bookmark.getId() == null) {
            return null;
        }
        ImageDescriptor descriptor = FAVICO_CACHE.get(bookmark.getId());
        if (descriptor != null) {
            return descriptor;
        }
        File favicon = OwlUI.getImageFile(bookmark.getId());
        if (favicon != null && favicon.exists()) {
            try {
                descriptor = new FavIconImageDescriptor(favicon, ImageDescriptor.createFromURL((URL)favicon.toURI().toURL()));
                FAVICO_CACHE.put(bookmark.getId(), descriptor);
                return descriptor;
            }
            catch (MalformedURLException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return null;
    }

    public static void deleteImage(long id) {
        FAVICO_CACHE.remove(id);
        File file = OwlUI.getImageFile(id);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public static void clearFavicons() {
        File[] files;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return;
        }
        Path path = new Path(activator.getStateLocation().toOSString());
        File iconsFolder = new File((path = path.append(ICONS_FOLDER)).toOSString());
        if (!iconsFolder.exists()) {
            return;
        }
        File[] fileArray = files = iconsFolder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".ico")) {
                file.delete();
            }
            ++n2;
        }
    }

    public static void storeImage(long id, byte[] bytes, ImageDescriptor defaultImage, int wHint, int hHint) {
        ImageData imgData;
        block29: {
            Assert.isNotNull((Object)defaultImage);
            Assert.isLegal((wHint > 0 ? 1 : 0) != 0);
            Assert.isLegal((hHint > 0 ? 1 : 0) != 0);
            imgData = null;
            if (bytes != null && bytes.length > 0) {
                ByteArrayInputStream inS = null;
                try {
                    try {
                        inS = new ByteArrayInputStream(bytes);
                        ImageLoader loader = new ImageLoader();
                        ImageData[] imageDatas = loader.load((InputStream)inS);
                        if (imageDatas != null) {
                            imgData = OwlUI.getBestQuality(imageDatas, wHint, hHint);
                        }
                    }
                    catch (SWTException sWTException) {
                        if (inS != null) {
                            try {
                                inS.close();
                            }
                            catch (IOException e) {
                                if (!(e instanceof MonitorCanceledException)) {
                                    Activator.getDefault().logError(e.getMessage(), e);
                                }
                            }
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    block30: {
                        if (inS != null) {
                            try {
                                inS.close();
                            }
                            catch (IOException e) {
                                if (e instanceof MonitorCanceledException) break block30;
                                Activator.getDefault().logError(e.getMessage(), e);
                            }
                        }
                    }
                    throw throwable;
                }
                if (inS != null) {
                    try {
                        inS.close();
                    }
                    catch (IOException e) {
                        if (e instanceof MonitorCanceledException) break block29;
                        Activator.getDefault().logError(e.getMessage(), e);
                    }
                }
            }
        }
        if (imgData == null) {
            imgData = defaultImage.getImageData();
        }
        if (imgData != null) {
            int[] formats;
            File imageFile = OwlUI.getImageFile(id);
            if (imageFile == null) {
                return;
            }
            if (imgData.width != 16 || imgData.height != 16) {
                imgData = imgData.scaledTo(16, 16);
            }
            try {
                if (OwlUI.storeImage(imgData, imageFile, imgData.type)) {
                    return;
                }
            }
            catch (SWTException sWTException) {}
            int[] nArray = new int[4];
            nArray[0] = 5;
            nArray[1] = 3;
            nArray[2] = 2;
            int[] nArray2 = formats = nArray;
            int n = formats.length;
            int n2 = 0;
            while (n2 < n) {
                int format = nArray2[n2];
                if (format != imgData.type) {
                    try {
                        if (OwlUI.storeImage(imgData, imageFile, format)) {
                            return;
                        }
                    }
                    catch (SWTException sWTException) {}
                }
                ++n2;
            }
        }
    }

    private static ImageData getBestQuality(ImageData[] datas, int wHint, int hHint) {
        ImageData data;
        ImageData bestSize = null;
        ImageData bestDepth = null;
        int maxDepth = -1;
        int maxSize = -1;
        ImageData[] imageDataArray = datas;
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            data = imageDataArray[n2];
            if (data.depth > maxDepth) {
                maxDepth = data.depth;
                bestDepth = data;
            }
            ++n2;
        }
        imageDataArray = datas;
        n = datas.length;
        n2 = 0;
        while (n2 < n) {
            data = imageDataArray[n2];
            if (data.depth == maxDepth) {
                if (data.width == wHint && data.height == hHint) {
                    return data;
                }
                if (data.width * data.height > maxSize) {
                    maxSize = data.width * data.height;
                    bestSize = data;
                }
            }
            ++n2;
        }
        return bestDepth != null ? bestDepth : bestSize;
    }

    private static boolean storeImage(ImageData imgData, File file, int format) {
        block12: {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{imgData};
            FileOutputStream fOs = null;
            try {
                try {
                    fOs = new FileOutputStream(file);
                    loader.save((OutputStream)fOs, format);
                }
                catch (FileNotFoundException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                    if (fOs == null) break block12;
                    try {
                        fOs.close();
                    }
                    catch (IOException e2) {
                        Activator.getDefault().logError(e2.getMessage(), e2);
                    }
                }
            }
            finally {
                if (fOs != null) {
                    try {
                        fOs.close();
                    }
                    catch (IOException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                    }
                }
            }
        }
        return true;
    }

    private static File getImageFile(String fileName) {
        boolean res = false;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        Path path = new Path(activator.getStateLocation().toOSString());
        File root = new File((path = path.append(ICONS_FOLDER)).toOSString());
        res = !root.exists() ? root.mkdir() : true;
        path = path.append(fileName);
        if (!res) {
            return null;
        }
        return new File(path.toOSString());
    }

    private static File getImageFile(long id) {
        return OwlUI.getImageFile(String.valueOf(id) + ".ico");
    }

    public static IWorkbenchWindow getPrimaryWindow() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    public static IWorkbenchWindow getWindow() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    public static IWorkbenchWindow getWindowAtCursor() {
        IWorkbenchWindow[] windows;
        Control cursorControl = Display.getDefault().getCursorControl();
        if (cursorControl == null) {
            return null;
        }
        Shell cursorShell = cursorControl.getShell();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            if (workbenchWindow.getShell().equals(cursorShell)) {
                return workbenchWindow;
            }
            ++n2;
        }
        return null;
    }

    public static IWorkbenchPage getPage() {
        IWorkbenchWindow window = OwlUI.getWindow();
        return OwlUI.getPage(window);
    }

    public static IWorkbenchPage getPage(IWorkbenchWindow window) {
        if (window != null) {
            if (window.getActivePage() != null) {
                return window.getActivePage();
            }
            IWorkbenchPage[] pages = window.getPages();
            if (pages.length > 0) {
                return pages[0];
            }
        }
        return null;
    }

    public static IWorkbenchPart getActivePart(IWorkbenchWindow window) {
        if (window != null) {
            IWorkbenchPage[] pages;
            if (window.getActivePage() != null) {
                return window.getActivePage().getActivePart();
            }
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                if (page.getActivePart() != null) {
                    return page.getActivePart();
                }
                ++n2;
            }
        }
        return null;
    }

    public static int getWindowIndex(IWorkbenchWindow window) {
        if (window != null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                if (windows[i].equals(window)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public static IWorkbenchPage getPageAtCursor() {
        IWorkbenchWindow window = OwlUI.getWindowAtCursor();
        if (window != null) {
            if (window.getActivePage() != null) {
                return window.getActivePage();
            }
            IWorkbenchPage[] pages = window.getPages();
            if (pages.length > 0) {
                return pages[0];
            }
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static List<IEditorReference> getEditorReferences() {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            IEditorReference[] references = page.getEditorReferences();
            return Arrays.asList(references);
        }
        return Collections.emptyList();
    }

    public static int getOpenFeedViewCount() {
        int count = 0;
        List<IEditorReference> editors = OwlUI.getEditorReferences();
        for (IEditorReference reference : editors) {
            if (!"org.rssowl.ui.FeedView".equals(reference.getId())) continue;
            ++count;
        }
        return count;
    }

    public static FeedView getActiveFeedView() {
        IEditorPart activeEditor;
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null && (activeEditor = page.getActiveEditor()) != null && activeEditor instanceof FeedView) {
            return (FeedView)activeEditor;
        }
        return null;
    }

    public static INewsMark getActiveFeedViewNewsMark() {
        try {
            FeedView activeFeedView = OwlUI.getActiveFeedView();
            if (activeFeedView != null) {
                FeedViewInput input = (FeedViewInput)activeFeedView.getEditorInput();
                return input.getMark();
            }
        }
        catch (Error error) {}
        return null;
    }

    public static IPreferenceScope getActiveFeedViewPreferences() {
        FeedViewInput feedViewInput;
        IEditorInput input;
        FeedView feedView = OwlUI.getActiveFeedView();
        if (feedView != null && (input = feedView.getEditorInput()) instanceof FeedViewInput && (feedViewInput = (FeedViewInput)input).getMark() != null) {
            INewsMark mark = feedViewInput.getMark();
            if (mark instanceof FolderNewsMark) {
                return Owl.getPreferenceService().getEntityScope((IEntity)((FolderNewsMark)mark).getFolder());
            }
            return Owl.getPreferenceService().getEntityScope((IEntity)feedViewInput.getMark());
        }
        return null;
    }

    public static List<FeedView> getFeedViews() {
        ArrayList<FeedView> feedViews = new ArrayList<FeedView>();
        List<IEditorReference> references = OwlUI.getEditorReferences();
        for (IEditorReference reference : references) {
            IEditorPart editor;
            if (!"org.rssowl.ui.FeedView".equals(reference.getId()) || !((editor = reference.getEditor(true)) instanceof FeedView)) continue;
            feedViews.add((FeedView)editor);
        }
        return feedViews;
    }

    public static IStructuredSelection getActiveFeedViewSelection() {
        FeedView feedview = OwlUI.getActiveFeedView();
        if (feedview == null) {
            return StructuredSelection.EMPTY;
        }
        ISelectionProvider selectionProvider = feedview.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return StructuredSelection.EMPTY;
        }
        return (IStructuredSelection)selectionProvider.getSelection();
    }

    public static IStructuredSelection getActiveSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part;
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null && (part = page.getActivePart()) != null && part.getSite() != null && (selectionProvider = part.getSite().getSelectionProvider()) != null && !(selection = selectionProvider.getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static FeedView getFirstActiveFeedView() {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            IEditorReference[] editorReferences;
            IEditorPart activeEditor = page.getActiveEditor();
            if (activeEditor instanceof FeedView) {
                return (FeedView)activeEditor;
            }
            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if ("org.rssowl.ui.FeedView".equals(editorReference.getId())) {
                    return (FeedView)editorReference.getEditor(true);
                }
                ++n2;
            }
        }
        return null;
    }

    public static WebBrowserView getFirstActiveBrowser() {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    if (editorReference.getEditorInput() instanceof WebBrowserInput) {
                        return (WebBrowserView)editorReference.getEditor(true);
                    }
                }
                catch (PartInitException partInitException) {}
                ++n2;
            }
        }
        return null;
    }

    public static BookMarkExplorer getOpenedBookMarkExplorer() {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            IViewReference[] viewReferences;
            IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewPart view;
                IViewReference viewRef = iViewReferenceArray[n2];
                if (viewRef.getId().equals("org.rssowl.ui.BookMarkExplorer") && (view = viewRef.getView(true)) instanceof BookMarkExplorer) {
                    return (BookMarkExplorer)view;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Shell getPrimaryShell() {
        IWorkbenchWindow window = OwlUI.getPrimaryWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow window = OwlUI.getWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void updateWindowTitle(IMark input) {
        if (input != null) {
            OwlUI.updateWindowTitle(input.getName());
        }
    }

    public static void updateWindowTitle(String title) {
        IWorkbenchWindow window = OwlUI.getWindow();
        if (window != null) {
            String appTitle = "RSSOwl";
            title = StringUtils.isSet((String)title) ? NLS.bind((String)Messages.OwlUI_TITLE, (Object)title, (Object)appTitle) : appTitle;
            String shellText = window.getShell().getText();
            if (shellText == null || !shellText.equals(title)) {
                window.getShell().setText(title);
            }
        }
    }

    public static void restoreWindow(IWorkbenchPage page) {
        Shell applicationShell = page.getWorkbenchWindow().getShell();
        OwlUI.restoreWindow(applicationShell);
    }

    public static void restoreWindow(Shell applicationShell) {
        ApplicationWorkbenchWindowAdvisor advisor = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
        if (advisor != null && advisor.isMinimizedToTray()) {
            advisor.restoreFromTray(applicationShell);
        } else if (applicationShell.getMinimized()) {
            applicationShell.setMinimized(false);
            applicationShell.forceActive();
        } else {
            applicationShell.forceActive();
        }
    }

    public static IFolder getBookMarkExplorerSelection() {
        IStructuredSelection selection;
        IViewPart viewPart;
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null && (viewPart = page.findView("org.rssowl.ui.BookMarkExplorer")) != null && !(selection = (IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection()).isEmpty()) {
            Object selectedEntity = selection.iterator().next();
            if (selectedEntity instanceof IFolder) {
                return (IFolder)selectedEntity;
            }
            if (selectedEntity instanceof IMark) {
                return ((IMark)selectedEntity).getParent();
            }
        }
        return null;
    }

    public static void openInFeedView(IWorkbenchPage page, IStructuredSelection selection) {
        OwlUI.openInFeedView(page, selection, false);
    }

    public static void openInFeedView(IWorkbenchPage page, IStructuredSelection selection, boolean forceActivate) {
        OwlUI.openInFeedView(page, selection, forceActivate, false);
    }

    public static void openInFeedView(IWorkbenchPage page, IStructuredSelection selection, boolean forceActivate, boolean ignoreAlreadyOpened) {
        OwlUI.openInFeedView(page, selection, forceActivate, ignoreAlreadyOpened, null);
    }

    public static void openInFeedView(IWorkbenchPage page, IStructuredSelection selection, boolean forceActivate, boolean ignoreAlreadyOpened, PerformAfterInputSet perform) {
        try {
            OwlUI.internalOpenInFeedView(page, selection, forceActivate, ignoreAlreadyOpened, false, perform);
        }
        finally {
            FeedView.setBlockFeedChangeEvent(false);
        }
    }

    public static void openInFeedView(IWorkbenchPage page, IStructuredSelection selection, EnumSet<FeedViewOpenMode> openModes) {
        boolean forceActivate = openModes.contains((Object)FeedViewOpenMode.FORCE_ACTIVATE);
        boolean ignoreAlreadyOpened = openModes.contains((Object)FeedViewOpenMode.IGNORE_ALREADY_OPENED);
        boolean ignoreReuse = openModes.contains((Object)FeedViewOpenMode.IGNORE_REUSE);
        try {
            OwlUI.internalOpenInFeedView(page, selection, forceActivate, ignoreAlreadyOpened, ignoreReuse, null);
        }
        finally {
            FeedView.setBlockFeedChangeEvent(false);
        }
    }

    private static void internalOpenInFeedView(IWorkbenchPage page, IStructuredSelection selection, boolean forceActivate, boolean ignoreAlreadyOpened, boolean ignoreReuse, PerformAfterInputSet perform) {
        List list = selection.toList();
        boolean activateEditor = forceActivate || OpenStrategy.activateOnOpen();
        int openedEditors = 0;
        int maxOpenEditors = EditorUtils.getOpenEditorLimit();
        boolean reuseFeedView = !ignoreReuse && Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.ALWAYS_REUSE_FEEDVIEW);
        int i = 0;
        while (i < list.size() && openedEditors < maxOpenEditors) {
            Object object = list.get(i);
            if (object instanceof IFolder) {
                object = new FolderNewsMark((IFolder)object);
            }
            if (object instanceof INewsMark) {
                INewsMark mark = (INewsMark)object;
                FeedViewInput input = new FeedViewInput(mark, perform);
                if (i == 1) {
                    FeedView.setBlockFeedChangeEvent(true);
                }
                if (reuseFeedView) {
                    IEditorPart existingEditor = page.findEditor((IEditorInput)input);
                    if (existingEditor != null) {
                        if (activateEditor) {
                            page.activate((IWorkbenchPart)existingEditor);
                        } else {
                            page.bringToTop((IWorkbenchPart)existingEditor);
                        }
                        if (perform == null || !(existingEditor instanceof FeedView)) break;
                        ((FeedView)existingEditor).perform(perform);
                        break;
                    }
                    FeedView activeFeedView = OwlUI.getFirstActiveFeedView();
                    if (activeFeedView != null) {
                        activeFeedView.setInput(input);
                        if (activateEditor) {
                            page.activate((IWorkbenchPart)activeFeedView);
                            break;
                        }
                        page.bringToTop((IWorkbenchPart)activeFeedView);
                        break;
                    }
                }
                try {
                    boolean explicitPerform = false;
                    IEditorPart existingEditor = null;
                    if (perform != null) {
                        existingEditor = page.findEditor((IEditorInput)input);
                        boolean bl = explicitPerform = existingEditor != null;
                    }
                    if (!ignoreAlreadyOpened || page.findEditor((IEditorInput)input) == null) {
                        page.openEditor((IEditorInput)input, "org.rssowl.ui.FeedView", activateEditor);
                    }
                    ++openedEditors;
                    if (explicitPerform && existingEditor instanceof FeedView) {
                        ((FeedView)existingEditor).perform(perform);
                    }
                    if (reuseFeedView) {
                        break;
                    }
                }
                catch (PartInitException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++i;
        }
    }

    public static void setAllChecked(Tree tree, boolean state) {
        OwlUI.setAllChecked(state, tree.getItems());
    }

    private static void setAllChecked(boolean state, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(state);
            TreeItem[] children = items[i].getItems();
            OwlUI.setAllChecked(state, children);
            ++i;
        }
    }

    public static void closeOtherEditors() {
        IEditorReference[] refArray;
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null && (refArray = page.getEditorReferences()) != null && refArray.length > 1) {
            IEditorReference[] otherEditors = new IEditorReference[refArray.length - 1];
            IEditorReference activeEditor = (IEditorReference)page.getReference((IWorkbenchPart)page.getActiveEditor());
            int i = 0;
            while (i < refArray.length) {
                if (refArray[i] == activeEditor) {
                    System.arraycopy(refArray, 0, otherEditors, 0, i);
                    System.arraycopy(refArray, i + 1, otherEditors, i, refArray.length - 1 - i);
                    break;
                }
                ++i;
            }
            page.closeEditors(otherEditors, true);
        }
    }

    public static Pair<SimpleContentProposalProvider, ContentProposalAdapter> hookAutoComplete(Text text, Collection<String> values, boolean decorate, boolean autoActivate) {
        return OwlUI.hookAutoComplete((Control)text, new ContentAssistAdapter((Control)text, ' ', false), values, decorate, autoActivate);
    }

    public static Pair<SimpleContentProposalProvider, ContentProposalAdapter> hookAutoComplete(Combo combo, Collection<String> values, boolean decorate) {
        return OwlUI.hookAutoComplete((Control)combo, new ContentAssistAdapter((Control)combo, ' ', false), values, decorate, true);
    }

    public static Pair<SimpleContentProposalProvider, ContentProposalAdapter> hookAutoComplete(final Control control, IControlContentAdapter contentAdapter, Collection<String> values, boolean decorate, boolean autoActivate) {
        if (decorate) {
            ControlDecoration controlDeco = new ControlDecoration(control, 16512);
            controlDeco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
            controlDeco.setDescriptionText(Messages.OwlUI_CONTENT_ASSIST);
            controlDeco.setShowOnlyOnFocus(true);
        }
        KeyStroke activationKey = KeyStroke.getInstance((int)0x1000002);
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(new String[0]){

            public IContentProposal[] getProposals(String contents, int position) {
                if (Display.getCurrent() != null && !control.isVisible()) {
                    return new IContentProposal[0];
                }
                return super.getProposals(contents, position);
            }
        };
        proposalProvider.setFiltering(true);
        final ContentProposalAdapter adapter = new ContentProposalAdapter(control, contentAdapter, (IContentProposalProvider)proposalProvider, activationKey, null);
        adapter.setPropagateKeys(true);
        adapter.setAutoActivationDelay(1500);
        adapter.setProposalAcceptanceStyle(1);
        if (values != null) {
            OwlUI.applyAutoCompleteProposals(values, proposalProvider, adapter, autoActivate);
        }
        control.getDisplay().timerExec(100, new Runnable(){

            public void run() {
                if (!control.isDisposed()) {
                    adapter.setPopupSize(new Point(control.getSize().x, 120));
                }
            }
        });
        return Pair.create((Object)proposalProvider, (Object)adapter);
    }

    public static void applyAutoCompleteProposals(Collection<String> values, SimpleContentProposalProvider provider, ContentProposalAdapter adapter, boolean autoActivate) {
        String[] proposals = new String[values.size()];
        HashSet<Character> charSet = new HashSet<Character>();
        int i = 0;
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String value;
            proposals[i] = value = iterator.next();
            char c = value.charAt(0);
            charSet.add(Character.valueOf(Character.toLowerCase(c)));
            charSet.add(Character.valueOf(Character.toUpperCase(c)));
            ++i;
        }
        char[] activationChars = new char[charSet.size()];
        i = 0;
        Iterator iterator2 = charSet.iterator();
        while (iterator2.hasNext()) {
            char c;
            activationChars[i] = c = ((Character)iterator2.next()).charValue();
            ++i;
        }
        provider.setProposals(proposals);
        if (autoActivate) {
            adapter.setAutoActivationCharacters(activationChars);
        }
    }

    public static Image createColorImage(Display display, RGB rgb) {
        Color color = new Color((Device)display, rgb);
        Image image = new Image((Device)display, 12, 12);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, 12, 12);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 0, 11, 11);
        gc.dispose();
        color.dispose();
        return image;
    }

    public static int getDateWidth() {
        if (DATE_WIDTH > 0) {
            return DATE_WIDTH;
        }
        DateFormat dF = OwlUI.getShortDateFormat();
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 11, 12, 12, 12, 12);
        String sampleDate = dF.format(cal.getTime());
        DATE_WIDTH = OwlUI.getTextSize((Drawable)Display.getDefault(), (Font)OwlUI.getBold((String)HEADLINES_FONT_ID), (String)sampleDate).x;
        return DATE_WIDTH += Application.IS_WINDOWS ? 15 : 30;
    }

    public static int getStateWidth() {
        if (STATE_WIDTH > 0) {
            return STATE_WIDTH;
        }
        String sampleState = Messages.OwlUI_UPDATED;
        STATE_WIDTH = OwlUI.getTextSize((Drawable)Display.getDefault(), (Font)OwlUI.getBold((String)HEADLINES_FONT_ID), (String)sampleState).x;
        return STATE_WIDTH += Application.IS_WINDOWS ? 25 : 30;
    }

    public static void codDrawGradient(Event event, Color fg, Color bg, Color end) {
        Scrollable scrollable = (Scrollable)event.widget;
        GC gc = event.gc;
        Rectangle area = scrollable.getClientArea();
        Rectangle rect = event.getBounds();
        OwlUI.codExpandRegion(event, scrollable, gc, area);
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        gc.setForeground(fg);
        gc.setBackground(bg);
        gc.fillGradientRectangle(0, rect.y, area.width, rect.height, true);
        gc.setForeground(end);
        gc.drawLine(0, rect.y + rect.height - 1, area.width, rect.y + rect.height - 1);
        gc.setForeground(oldForeground);
        gc.setBackground(oldBackground);
        event.detail &= 0xFFFFFFF7;
    }

    public static void codExpandRegion(Event event, Scrollable scrollable, GC gc, Rectangle area) {
        int width;
        int columnCount = scrollable instanceof Table ? ((Table)scrollable).getColumnCount() : ((Tree)scrollable).getColumnCount();
        if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
            Region region = new Region();
            gc.getClipping(region);
            region.add(event.x, event.y, width, event.height);
            gc.setClipping(region);
            region.dispose();
        }
    }

    public static void openWizard(Shell shell, Wizard wizard, boolean modal, boolean needsProgressPart, String dialogSettingsKey) {
        OwlUI.openWizard(shell, wizard, modal, needsProgressPart, dialogSettingsKey, false, null);
    }

    public static void openWizard(Shell shell, Wizard wizard, final boolean modal, final boolean needsProgressPart, final String dialogSettingsKey, final boolean pack, final String finishLabel) {
        CustomWizardDialog dialog = new CustomWizardDialog(shell, (IWizard)wizard){
            private ProgressMonitorPart progressMonitorPart;

            protected boolean isResizable() {
                return true;
            }

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                if (this.progressMonitorPart != null && !needsProgressPart) {
                    ((GridData)this.progressMonitorPart.getLayoutData()).exclude = true;
                }
                return control;
            }

            public boolean close() {
                this.progressMonitorPart = null;
                return super.close();
            }

            protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
                this.progressMonitorPart = super.createProgressMonitorPart(composite, pmlayout);
                return this.progressMonitorPart;
            }

            protected IDialogSettings getDialogBoundsSettings() {
                if (dialogSettingsKey != null) {
                    IDialogSettings settings = Activator.getDefault().getDialogSettings();
                    IDialogSettings section = settings.getSection(dialogSettingsKey);
                    if (section != null) {
                        return section;
                    }
                    return settings.addNewSection(dialogSettingsKey);
                }
                return super.getDialogBoundsSettings();
            }

            protected int getShellStyle() {
                if (modal) {
                    return super.getShellStyle();
                }
                return 0x8F0 | 3.getDefaultOrientation();
            }

            protected int getDialogBoundsStrategy() {
                return 2;
            }

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                if (16 == id && StringUtils.isSet((String)finishLabel)) {
                    label = finishLabel;
                }
                return super.createButton(parent, id, label, defaultButton);
            }

            protected Point getInitialSize() {
                if (pack) {
                    int width = Application.IS_WINDOWS ? 380 : (Application.IS_LINUX ? 370 : 300);
                    return this.getShell().computeSize(this.convertHorizontalDLUsToPixels(width), -1, true);
                }
                return super.getInitialSize();
            }
        };
        dialog.setMinimumPageSize(0, 0);
        dialog.create();
        dialog.open();
    }

    public static IFolder getSelectedParent(IFolder folder) throws PersistenceException {
        String selectedBookMarkSetPref = BookMarkExplorer.getSelectedBookMarkSetPref(OwlUI.getWindow());
        IPreference preference = ((IPreferenceDAO)DynamicDAO.getDAO(IPreferenceDAO.class)).load(selectedBookMarkSetPref);
        if (preference != null) {
            Long selectedRootFolderID = preference.getLong();
            if (folder != null && OwlUI.hasParent(folder, new FolderReference(selectedRootFolderID.longValue()))) {
                return folder;
            }
            return new FolderReference(selectedRootFolderID.longValue()).resolve();
        }
        Set roots = CoreUtils.loadRootFolders();
        if (!roots.isEmpty()) {
            return (IFolder)roots.iterator().next();
        }
        return null;
    }

    private static boolean hasParent(IFolder folder, FolderReference folderRef) {
        if (folder == null) {
            return false;
        }
        if (folderRef.references((IEntity)folder)) {
            return true;
        }
        return OwlUI.hasParent(folder.getParent(), folderRef);
    }

    public static void adjustSizeForScrollbar(Shell shell, ScrollBar verticalBar, boolean wasScrollbarShowing) {
        if (verticalBar == null) {
            return;
        }
        if (shell.getParent() == null) {
            return;
        }
        int barWidth = verticalBar.getSize().x;
        if (Application.IS_MAC && barWidth == 0) {
            barWidth = 16;
        }
        if (wasScrollbarShowing != verticalBar.isVisible()) {
            Rectangle shellBounds = shell.getBounds();
            if (!wasScrollbarShowing) {
                shell.setBounds(shellBounds.x, shellBounds.y, shellBounds.width + barWidth, shellBounds.height);
            } else {
                shell.setBounds(shellBounds.x, shellBounds.y, shellBounds.width - barWidth, shellBounds.height);
            }
        }
    }

    public static ImageDescriptor getAttachmentImage(String name, String mimeType) {
        ImageDescriptor descriptor = OwlUI.getImageForMime(mimeType);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = OwlUI.getImageForFile(name);
        if (descriptor != null) {
            return descriptor;
        }
        return ATTACHMENT;
    }

    private static ImageDescriptor getImageForFile(String file) {
        int lastIndexOfDot;
        if (StringUtils.isSet((String)file) && (lastIndexOfDot = file.lastIndexOf(46)) != -1 && !file.endsWith(".")) {
            String extension = file.substring(lastIndexOfDot + 1);
            return OwlUI.getImageForExtension(extension.toLowerCase());
        }
        return null;
    }

    private static ImageDescriptor getImageForMime(String mime) {
        if (StringUtils.isSet((String)mime)) {
            String extension = OwlUI.getExtensionForMime(mime);
            return OwlUI.getImageForExtension(extension);
        }
        return null;
    }

    public static String getExtensionForMime(String mime) {
        if (StringUtils.isSet((String)mime)) {
            return fgMapMimeToExtension.get(mime.toLowerCase());
        }
        return null;
    }

    private static ImageDescriptor getImageForExtension(String extension) {
        Program p;
        if (StringUtils.isSet((String)extension) && (p = Program.findProgram((String)extension)) != null) {
            return new ExternalProgramImageDescriptor(p);
        }
        return null;
    }

    public static String getPeriod(int seconds) {
        if (seconds > 0) {
            int hours = seconds / 3600;
            int minutes = seconds / 60 % 60;
            if (hours > 0 && minutes > 0) {
                if (hours == 1) {
                    if (minutes == 1) {
                        return NLS.bind((String)Messages.OwlUI_HOUR_MINUTE, (Object)hours, (Object)minutes);
                    }
                    return NLS.bind((String)Messages.OwlUI_HOUR_MINUTES, (Object)hours, (Object)minutes);
                }
                if (minutes == 1) {
                    return NLS.bind((String)Messages.OwlUI_HOURS_MINUTE, (Object)hours, (Object)minutes);
                }
                return NLS.bind((String)Messages.OwlUI_HOURS_MINUTES, (Object)hours, (Object)minutes);
            }
            if (hours > 0) {
                return hours == 1 ? NLS.bind((String)Messages.OwlUI_HOUR, (Object)hours) : NLS.bind((String)Messages.OwlUI_HOURS, (Object)hours);
            }
            if (hours == 0 && minutes > 0) {
                return minutes == 1 ? NLS.bind((String)Messages.OwlUI_MINUTE, (Object)minutes) : NLS.bind((String)Messages.OwlUI_MINUTES, (Object)minutes);
            }
            if (seconds < 60) {
                return seconds == 1 ? NLS.bind((String)Messages.OwlUI_SECOND, (Object)seconds) : NLS.bind((String)Messages.OwlUI_SECONDS, (Object)seconds);
            }
        }
        return null;
    }

    public static String getSize(long bytes) {
        if (bytes > 0L) {
            double gb = (double)bytes / 1.073741824E9;
            double mb = (double)bytes / 1048576.0;
            double kb = (double)bytes / 1024.0;
            DecimalFormat format = new DecimalFormat(Messages.OwlUI_SIZE_FORMAT);
            if (gb >= 1.0) {
                return NLS.bind((String)Messages.OwlUI_OwlUI_N_GB, (Object)format.format(gb));
            }
            if (mb >= 1.0) {
                return NLS.bind((String)Messages.OwlUI_N_MB, (Object)format.format(mb));
            }
            if (kb >= 1.0) {
                return NLS.bind((String)Messages.OwlUI_N_KB, (Object)format.format(kb));
            }
            return NLS.bind((String)Messages.OwlUI_N_BYTES, (Object)bytes);
        }
        return null;
    }

    public static Point getFirstMonitorSize() {
        Monitor[] monitors;
        Display display = Display.getDefault();
        if (display != null && (monitors = display.getMonitors()).length == 1) {
            Rectangle clientArea = monitors[0].getClientArea();
            return new Point(clientArea.width, clientArea.height);
        }
        return null;
    }

    public static void toggleFullScreen() {
        Shell shell = OwlUI.getActiveShell();
        if (shell != null) {
            shell.setFullScreen(!shell.getFullScreen());
            if (!shell.getFullScreen()) {
                ApplicationWorkbenchWindowAdvisor configurer = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                configurer.setStatusVisible(Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.SHOW_STATUS), false);
                shell.layout();
            } else {
                ApplicationWorkbenchWindowAdvisor configurer = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                configurer.setStatusVisible(false, true);
            }
        }
    }

    public static void toggleBookmarks() {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            IViewPart explorerView = page.findView("org.rssowl.ui.BookMarkExplorer");
            if (explorerView != null) {
                page.hideView(explorerView);
            } else {
                try {
                    page.showView("org.rssowl.ui.BookMarkExplorer");
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
            }
        }
    }

    public static void positionDropDownMenu(Action action, ToolBarManager manager) {
        Menu menu = action.getMenuCreator().getMenu((Control)manager.getControl());
        if (menu != null) {
            Widget widget;
            IContributionItem contributionItem = manager.find(action.getId());
            if (contributionItem != null && contributionItem instanceof ActionContributionItem && (widget = ((ActionContributionItem)contributionItem).getWidget()) != null && widget instanceof ToolItem) {
                ToolItem item = (ToolItem)widget;
                Rectangle rect = item.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = manager.getControl().toDisplay(pt);
                if (Application.IS_MAC) {
                    pt.y += 5;
                }
                menu.setLocation(pt.x, pt.y);
            }
            menu.setVisible(true);
        }
    }

    public static void zoomNewsText(boolean zoomIn, boolean reset) {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        FontRegistry registry = theme.getFontRegistry();
        FontData[] oldFontDatas = registry.getFontData(NEWS_TEXT_FONT_ID);
        FontData[] newFontDatas = new FontData[oldFontDatas.length];
        int i = 0;
        while (i < oldFontDatas.length) {
            FontData oldFontData = oldFontDatas[i];
            int oldHeight = oldFontData.getHeight();
            newFontDatas[i] = reset ? new FontData(oldFontData.getName(), 10, oldFontData.getStyle()) : new FontData(oldFontData.getName(), zoomIn ? oldHeight + 1 : Math.max(oldHeight - 1, 0), oldFontData.getStyle());
            ++i;
        }
        registry.put(NEWS_TEXT_FONT_ID, newFontDatas);
        String key = ThemeElementHelper.createPreferenceKey((ITheme)theme, (String)NEWS_TEXT_FONT_ID);
        String fdString = PreferenceConverter.getStoredRepresentation((FontData[])newFontDatas);
        String storeString = PrefUtil.getInternalPreferenceStore().getString(key);
        if (!fdString.equals(storeString)) {
            PrefUtil.getInternalPreferenceStore().setValue(key, fdString);
        }
    }

    public static void runOnSelection(final Runnable run, Control ... control) {
        Control[] controlArray = control;
        int n = control.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Button) {
                Button button = (Button)c;
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        run.run();
                    }
                });
            } else if (c instanceof Combo) {
                Combo combo = (Combo)c;
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        run.run();
                    }
                });
            } else if (c instanceof Tree) {
                Tree tree = (Tree)c;
                tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((e.detail & 0x20) != 0) {
                            run.run();
                        }
                    }
                });
                tree.addDragDetectListener(new DragDetectListener(){

                    public void dragDetected(DragDetectEvent e) {
                        run.run();
                    }
                });
            } else if (c instanceof Table) {
                Table table = (Table)c;
                table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((e.detail & 0x20) != 0) {
                            run.run();
                        }
                    }
                });
                table.addDragDetectListener(new DragDetectListener(){

                    public void dragDetected(DragDetectEvent e) {
                        run.run();
                    }
                });
            } else if (c instanceof Spinner) {
                Spinner spinner = (Spinner)c;
                spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        run.run();
                    }
                });
            } else if (c instanceof Text) {
                Text text = (Text)c;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        run.run();
                    }
                });
            } else if (c instanceof Composite) {
                Composite composite = (Composite)c;
                OwlUI.runOnSelection(run, composite.getChildren());
            }
            ++n2;
        }
    }

    public static DateFormat getShortDateFormat() {
        String format = System.getProperty(SHORT_DATE_FORMAT_PROPERTY);
        if (StringUtils.isSet((String)format)) {
            try {
                return new SimpleDateFormat(format);
            }
            catch (Exception exception) {}
        }
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public static DateFormat getLongDateFormat() {
        String format = System.getProperty(LONG_DATE_FORMAT_PROPERTY);
        if (StringUtils.isSet((String)format)) {
            try {
                return new SimpleDateFormat(format);
            }
            catch (Exception exception) {}
        }
        return DateFormat.getDateTimeInstance(0, 3);
    }

    public static DateFormat getShortTimeFormat() {
        String format = System.getProperty(SHORT_TIME_FORMAT_PROPERTY);
        if (StringUtils.isSet((String)format)) {
            try {
                return new SimpleDateFormat(format);
            }
            catch (Exception exception) {}
        }
        return DateFormat.getTimeInstance(3);
    }

    public static void makeAccessible(Control control, Control label) {
        if (label == null || label.isDisposed()) {
            return;
        }
        if (label instanceof Button) {
            OwlUI.makeAccessible(control, ((Button)label).getText());
        } else if (label instanceof Label) {
            OwlUI.makeAccessible(control, ((Label)label).getText());
        } else if (label instanceof CLabel) {
            OwlUI.makeAccessible(control, ((CLabel)label).getText());
        }
    }

    public static void makeAccessible(final Control control, String name) {
        final String accessibleName = name.contains("&") ? StringUtils.replaceAll((String)name, (String)"&", (String)"") : name;
        if (control != null && !control.isDisposed()) {
            control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (control instanceof Tree || control instanceof Table) {
                        Widget widget;
                        if (e.childID == -1) {
                            e.result = accessibleName;
                        } else if (!control.isDisposed() && (widget = control.getDisplay().findWidget((Widget)control, e.childID)) != null && widget instanceof Item) {
                            e.result = NLS.bind((String)Messages.OwlUI_ACCESSIBLE_NAME, (Object)((Item)widget).getText());
                        }
                    } else {
                        e.result = accessibleName;
                    }
                }
            });
        }
    }

    public static boolean isTabbedBrowsingEnabled() {
        IPreferenceScope preferences = Owl.getPreferenceService().getEclipseScope();
        boolean autoCloseTabs = preferences.getBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS);
        int autoCloseTabsThreshold = preferences.getInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD);
        return !autoCloseTabs || autoCloseTabsThreshold > 1;
    }

    public static boolean isMinimized() {
        ApplicationWorkbenchWindowAdvisor advisor = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
        return advisor != null && (advisor.isMinimizedToTray() || advisor.isMinimized());
    }

    public static boolean useExternalBrowser() {
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        return preferences.getBoolean(DefaultPreferences.USE_DEFAULT_EXTERNAL_BROWSER) || preferences.getBoolean(DefaultPreferences.USE_CUSTOM_EXTERNAL_BROWSER);
    }

    public static IFolder getSelectedBookMarkSet() {
        String selectedBookMarkSetPref;
        long selectedFolderID;
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        IFolderDAO folderDAO = (IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class);
        IFolder selectedSet = (IFolder)folderDAO.load(selectedFolderID = preferences.getLong(selectedBookMarkSetPref = BookMarkExplorer.getSelectedBookMarkSetPref(OwlUI.getWindow())));
        if (selectedSet != null) {
            return selectedSet;
        }
        Set rootFolders = CoreUtils.loadRootFolders();
        if (!rootFolders.isEmpty()) {
            return (IFolder)rootFolders.iterator().next();
        }
        return null;
    }

    public static boolean markReadDuplicates() {
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        return preferences.getBoolean(DefaultPreferences.MARK_READ_DUPLICATES);
    }

    public static Layout getLayout(IPreferenceScope scope) {
        Layout[] layouts;
        int layoutOrdinal = scope.getInteger(DefaultPreferences.FV_LAYOUT);
        return layoutOrdinal < (layouts = Layout.values()).length ? layouts[layoutOrdinal] : Layout.CLASSIC;
    }

    public static PageSize getPageSize(IPreferenceScope scope) {
        int pageSize = scope.getInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE);
        return PageSize.from(pageSize);
    }

    public static void safeDispose(Menu menu) {
        try {
            menu.dispose();
        }
        catch (NegativeArraySizeException negativeArraySizeException) {}
    }

    public static void saveCrashReport(Shell shell) throws FileNotFoundException {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText(Messages.OwlUI_SAVE_CRASH_REPORT);
        dialog.setFilterExtensions(new String[]{"*.log"});
        dialog.setFileName("rssowl.log");
        dialog.setOverwrite(true);
        String file = dialog.open();
        if (StringUtils.isSet((String)file)) {
            String logMessages = CoreUtils.getAndFlushLogMessages();
            if (logMessages != null && logMessages.length() > 0) {
                Activator.safeLogError(logMessages, null);
            }
            Activator.safeLogInfo("Crash Report Exported");
            File logFile = Platform.getLogFileLocation().toFile();
            InputStream inS = logFile.exists() ? new FileInputStream(logFile) : new ByteArrayInputStream(new byte[0]);
            FileOutputStream outS = new FileOutputStream(new File(file));
            CoreUtils.copy((InputStream)inS, (OutputStream)outS);
        }
    }

    public static int openSyncLogin(Shell shell) {
        if (shell == null) {
            shell = OwlUI.getActiveShell();
        }
        if (shell != null) {
            URI googleLoginUri = URI.create("https://www.google.com/accounts/ClientLogin");
            LoginDialog dialog = new LoginDialog(shell, googleLoginUri, null, true);
            dialog.setHeader(Messages.OwlUI_SYNC_LOGIN);
            dialog.setSubline(Messages.OwlUI_SYNC_LOGIN_TEXT);
            dialog.setTitleImageDescriptor(OwlUI.getImageDescriptor("icons/wizban/reader_wiz.png"));
            return dialog.open();
        }
        return 1;
    }

    public static boolean needsCancelControl() {
        if (Application.IS_WINDOWS) {
            return true;
        }
        if (Application.IS_MAC) {
            return false;
        }
        return SWT.getVersion() < 3700;
    }

    private static class FavIconImageDescriptor
    extends ImageDescriptor {
        private final ImageDescriptor fDescriptor;
        private final File fFaviconFile;

        private FavIconImageDescriptor(File faviconFile, ImageDescriptor descriptor) {
            Assert.isNotNull((Object)faviconFile);
            Assert.isNotNull((Object)descriptor);
            this.fFaviconFile = faviconFile;
            this.fDescriptor = descriptor;
        }

        public ImageData getImageData() {
            return this.fDescriptor.getImageData();
        }

        public Image createImage(boolean returnMissingImageOnError, Device device) {
            try {
                return this.internalCreateImage(returnMissingImageOnError, device);
            }
            catch (SWTException sWTException) {
            }
            catch (SWTError sWTError) {}
            return BOOKMARK.createImage(returnMissingImageOnError, device);
        }

        private Image internalCreateImage(boolean returnMissingImageOnError, Device device) {
            try {
                if (Application.IS_LINUX) {
                    return new Image(device, this.fFaviconFile.toString());
                }
                ImageLoader loader = new ImageLoader();
                ImageData[] datas = loader.load(this.fFaviconFile.toString());
                if (datas != null && datas.length > 0) {
                    return new Image(device, datas[0]);
                }
            }
            catch (SWTException sWTException) {
            }
            catch (SWTError sWTError) {}
            return this.fDescriptor.createImage(returnMissingImageOnError, device);
        }

        public boolean equals(Object obj) {
            return this.fDescriptor.equals(obj);
        }

        public int hashCode() {
            return this.fDescriptor.hashCode();
        }

        public void destroyResource(Object previouslyCreatedObject) {
            this.fDescriptor.destroyResource(previouslyCreatedObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FeedViewOpenMode {
        FORCE_ACTIVATE,
        IGNORE_ALREADY_OPENED,
        IGNORE_REUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        CLASSIC(Messages.OwlUI_CLASSIC_LAYOUT),
        VERTICAL(Messages.OwlUI_VERTICAL_LAYOUT),
        LIST(Messages.OwlUI_LIST_LAYOUT),
        NEWSPAPER(Messages.OwlUI_NEWSPAPER_LAYOUT),
        HEADLINES(Messages.OwlUI_HEADLINES_LAYOUT);

        private final String fName;

        private Layout(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSTheme {
        WINDOWS_BLUE,
        WINDOWS_SILVER,
        WINDOWS_OLIVE,
        WINDOWS_CLASSIC,
        HIGH_CONTRAST,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageSize {
        TEN(Messages.OwlUI_T_ARTICLES, 10),
        TWENTY_FIVE(Messages.OwlUI_TF_ARTICLES, 25),
        FIFTY(Messages.OwlUI_F_ARTICLES, 50),
        HUNDRED(Messages.OwlUI_H_ARTICLES, 100),
        NO_PAGING(Messages.OwlUI_ALL_ARTICLES, 0);

        private final String fName;
        private final int fPageSize;

        private PageSize(String name, int pageSize) {
            this.fName = name;
            this.fPageSize = pageSize;
        }

        public String getName() {
            return this.fName;
        }

        public int getPageSize() {
            return this.fPageSize;
        }

        public static PageSize from(int pageSize) {
            switch (pageSize) {
                case 10: {
                    return TEN;
                }
                case 25: {
                    return TWENTY_FIVE;
                }
                case 50: {
                    return FIFTY;
                }
                case 100: {
                    return HUNDRED;
                }
            }
            return NO_PAGING;
        }
    }
}

