/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.TagContent;

class BinaryFrame {
    protected ID3v2 id3v2;
    protected String type;
    protected TagContent content;
    protected boolean use_compression;
    protected ID3v2Frame frame;

    public BinaryFrame(ID3v2 id3v2, String type, TagContent content, boolean use_compression) {
        this.id3v2 = id3v2;
        this.type = type;
        this.content = content;
        this.use_compression = use_compression;
        byte[] v2cont = content.getBinaryContent();
        try {
            this.frame = new ID3v2Frame(type, v2cont, false, false, false, use_compression ? (byte)2 : 0, 0, 0, false);
        }
        catch (ID3v2DecompressionException iD3v2DecompressionException) {
            // empty catch block
        }
    }

    public void write() {
        try {
            this.id3v2.removeFrame(this.type);
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        this.id3v2.addFrame(this.frame);
    }

    public static TagContent read(ID3v2 id3v2, String type) throws FrameDamagedException {
        TagContent ret = new TagContent();
        try {
            byte[] v2cont = ((ID3v2Frame)id3v2.getFrame(type).elementAt(0)).getContent();
            ret.setContent(v2cont);
        }
        catch (ID3v2Exception v2cont) {
        }
        catch (Exception e) {
            throw new FrameDamagedException();
        }
        return ret;
    }
}

