/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.MusicTree;
import com.pugh.sockso.gui.PlaylistManager;
import com.pugh.sockso.gui.SitePlaylists;
import com.pugh.sockso.gui.UserPlaylists;
import com.pugh.sockso.gui.action.ImportPlaylist;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class MusicPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(MusicPanel.class);
    DefaultListModel playlistModel;
    private final JFrame parent;
    private final Resources r;
    private final Database db;
    private final CollectionManager cm;

    public MusicPanel(JFrame parent, Database db, CollectionManager cm, Resources r) {
        this.parent = parent;
        this.r = r;
        this.db = db;
        this.cm = cm;
    }

    protected void init() {
        SitePlaylists sitePlaylists = new SitePlaylists(this.db, this.cm, this.r);
        sitePlaylists.refresh();
        UserPlaylists userPlaylists = new UserPlaylists(this.db, this.cm, this.r);
        userPlaylists.refresh();
        ImportPlaylist importPlaylistAction = new ImportPlaylist(this.parent, this.db, this.cm, this.r);
        MusicTree musicTree = new MusicTree(this.db, this.cm, this.r);
        JSplitPane playlistsPanel = new JSplitPane(0, this.getSitePlaylistsPanel(sitePlaylists, importPlaylistAction), this.getUserPlaylistsPanel(userPlaylists));
        JTabbedPane tabbedPane = this.getTabbedPane(musicTree, playlistsPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)new JSplitPane(1, tabbedPane, new PlaylistManager(this.parent, this.db, this.cm, this.r)), "Center");
    }

    protected JTabbedPane getTabbedPane(MusicTree musicTree, JSplitPane playlistsPanel) {
        Locale locale = this.r.getCurrentLocale();
        JTabbedPane pane = new JTabbedPane();
        pane.addTab(locale.getString("gui.label.tracks"), new ImageIcon(this.r.getImage("icons/16x16/tracks.png")), new JScrollPane(musicTree), "Tracks in the collection");
        pane.addTab(locale.getString("gui.label.playlists"), new ImageIcon(this.r.getImage("icons/16x16/playlists.png")), new JScrollPane(playlistsPanel), "Your playlists");
        pane.setMinimumSize(new Dimension(170, 100));
        return pane;
    }

    protected JPanel getSitePlaylistsPanel(SitePlaylists sitePlaylists, ActionListener importPlaylistAction) {
        Locale locale = this.r.getCurrentLocale();
        JPanel buttons = new JPanel(new FlowLayout(0));
        JButton importPlaylist = new JButton(locale.getString("gui.label.import"), new ImageIcon(this.r.getImage("icons/16x16/import.png")));
        importPlaylist.addActionListener(importPlaylistAction);
        buttons.add(importPlaylist);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(sitePlaylists), "Center");
        panel.add((Component)buttons, "South");
        return panel;
    }

    protected JPanel getUserPlaylistsPanel(UserPlaylists userPlaylists) {
        Locale locale = this.r.getCurrentLocale();
        JLabel userPlaylistsLabel = new JLabel(locale.getString("gui.label.userPlaylists"), new ImageIcon(this.r.getImage("icons/16x16/playlists.png")), 2);
        userPlaylistsLabel.setBorder(BorderFactory.createEmptyBorder(4, 7, 4, 7));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)userPlaylistsLabel, "North");
        panel.add((Component)new JScrollPane(userPlaylists), "Center");
        return panel;
    }
}

