/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTable;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.FileItem;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;

public class IconLabelRenderer
extends DefaultLimeTableCellRenderer {
    private final Provider<IconManager> iconManager;
    private final CategoryIconManager categoryIconManager;
    private final boolean showAudioArtist;
    @Resource
    private Icon spamIcon;
    @Resource
    private Icon downloadingIcon;
    @Resource
    private Icon libraryIcon;
    @Resource
    private Icon warningIcon;
    @Resource
    private Color disabledForegroundColor;
    @Resource
    private Font font;

    @Inject
    public IconLabelRenderer(Provider<IconManager> iconManager, CategoryIconManager categoryIconManager, @Assisted boolean showAudioArtist) {
        GuiUtils.assignResources(this);
        this.iconManager = iconManager;
        this.categoryIconManager = categoryIconManager;
        this.showAudioArtist = showAudioArtist;
        this.setIconTextGap(5);
        this.setFont(this.font);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text;
        Icon icon;
        Color foreground;
        Color background;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table.getSelectedRow() == row) {
            background = table.getSelectionBackground();
            foreground = table.getSelectionForeground();
        } else {
            background = table.getBackground();
            foreground = table.getForeground();
        }
        if (value instanceof FileItem) {
            FileItem item = (FileItem)value;
            if (item instanceof LocalFileItem) {
                icon = this.iconManager.get().getIconForFile(((LocalFileItem)item).getFile());
                LocalFileItem localFileItem = (LocalFileItem)item;
                text = localFileItem.isIncomplete() ? I18n.tr("{0} (downloading)", item.getFileName()) : item.getFileName();
            } else {
                icon = null;
                text = item.getFileName();
            }
        } else if (value instanceof VisualSearchResult) {
            VisualSearchResult vsr = (VisualSearchResult)value;
            text = vsr.getNameProperty(this.showAudioArtist);
            icon = this.getIcon(vsr);
            foreground = vsr.isSpam() ? this.disabledForegroundColor : table.getForeground();
        } else {
            if (value != null) {
                throw new IllegalArgumentException(value + " must be a FileItem or VisualSearchResult, not a " + value.getClass().getCanonicalName());
            }
            icon = null;
            text = "";
        }
        this.setBackground(background);
        this.setForeground(foreground);
        this.setIcon(icon);
        this.setText(text);
        return this;
    }

    @Override
    protected void setValue(Object value) {
    }

    @Override
    public String getToolTipText() {
        return this.getText();
    }

    private Icon getIcon(VisualSearchResult vsr) {
        if (vsr.isSpam()) {
            return this.spamIcon;
        }
        switch (vsr.getDownloadState()) {
            case DOWNLOADING: {
                return this.downloadingIcon;
            }
            case DOWNLOADED: 
            case LIBRARY: {
                return this.libraryIcon;
            }
            case REMOVED: {
                return this.warningIcon;
            }
        }
        return this.categoryIconManager.getIcon(vsr);
    }
}

