/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.ui.swing.mainframe.MainPanel;
import org.limewire.ui.swing.search.ProgramsNotAllowedPanel;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.search.SearchInfo;

@Singleton
class SearchHandlerImpl
implements SearchHandler {
    private final SearchHandler textSearch;
    private final MainPanel mainPanel;

    @Inject
    public SearchHandlerImpl(@Named(value="text") SearchHandler textSearch, MainPanel mainPanel) {
        this.textSearch = textSearch;
        this.mainPanel = mainPanel;
    }

    @Override
    public boolean doSearch(SearchInfo info) {
        if (info.getSearchCategory() == SearchCategory.PROGRAM && !LibrarySettings.ALLOW_PROGRAMS.getValue()) {
            this.mainPanel.showTemporaryPanel(new ProgramsNotAllowedPanel());
            return false;
        }
        return this.textSearch.doSearch(info);
    }
}

