/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.friend.api.Friend;
import org.limewire.ui.swing.components.YesNoCheckBoxDialog;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.settings.QuestionsHandler;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class BlockUserMenuFactory {
    private final SpamManager spamManager;

    @Inject
    public BlockUserMenuFactory(SpamManager spamManager, DownloadMediator downloadMediator) {
        this.spamManager = spamManager;
    }

    public JMenu createDownloadBlockMenu(Collection<RemoteHost> allHosts) {
        return this.createBlockMenu(allHosts, new DownloadBlockHandler(allHosts));
    }

    public JMenu createSearchBlockMenu(Collection<RemoteHost> allHosts, Collection<VisualSearchResult> searchResults) {
        return this.createBlockMenu(allHosts, new SearchBlockHandler());
    }

    public Action createBlockUserAction(String actionName, final Friend friend) {
        return new AbstractAction(actionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBlockHandler blockHandler = new SearchBlockHandler();
                if (blockHandler.confirmBlock(friend.getRenderName())) {
                    BlockUserMenuFactory.this.spamManager.addToBlackList(friend.getName());
                    blockHandler.handleSideEffects();
                }
            }
        };
    }

    private JMenu createBlockMenu(Collection<RemoteHost> allHosts, final BlockHandler blockHandler) {
        final TreeMap<String, Friend> p2pUsers = new TreeMap<String, Friend>();
        for (RemoteHost host : allHosts) {
            Friend friend = host.getFriendPresence().getFriend();
            if (!friend.isAnonymous()) continue;
            p2pUsers.put(friend.getRenderName(), friend);
        }
        if (p2pUsers.size() == 0) {
            return null;
        }
        JMenu blockMenu = new JMenu(I18n.tr("Block User"));
        if (p2pUsers.size() > 1) {
            blockMenu.add(new AbstractAction(I18n.tr("All P2P Users")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (blockHandler.confirmBlockAll(p2pUsers.size())) {
                        for (Friend user : p2pUsers.values()) {
                            BlockUserMenuFactory.this.spamManager.addToBlackList(user.getName());
                        }
                        blockHandler.handleSideEffects();
                    }
                }
            });
            blockMenu.addSeparator();
        }
        for (final Friend user : p2pUsers.values()) {
            blockMenu.add(new AbstractAction(user.getRenderName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (blockHandler.confirmBlock(user.getRenderName())) {
                        BlockUserMenuFactory.this.spamManager.addToBlackList(user.getName());
                        blockHandler.handleSideEffects();
                    }
                }
            });
        }
        return blockMenu;
    }

    private boolean confirm(String message) {
        if (!QuestionsHandler.CONFIRM_BLOCK_HOST.getValue()) {
            return true;
        }
        YesNoCheckBoxDialog yesNoCheckBoxDialog = new YesNoCheckBoxDialog(message, I18n.tr("Don't ask me again"), !QuestionsHandler.CONFIRM_BLOCK_HOST.getValue());
        yesNoCheckBoxDialog.setLocationRelativeTo(GuiUtils.getMainFrame());
        yesNoCheckBoxDialog.setVisible(true);
        QuestionsHandler.CONFIRM_BLOCK_HOST.setValue(!yesNoCheckBoxDialog.isCheckBoxSelected());
        return yesNoCheckBoxDialog.isConfirmed();
    }

    private class SearchBlockHandler
    implements BlockHandler {
        private SearchBlockHandler() {
        }

        @Override
        public boolean confirmBlock(String name) {
            return BlockUserMenuFactory.this.confirm(I18n.tr("Block P2P User {0}?", name));
        }

        @Override
        public boolean confirmBlockAll(int hostCount) {
            return BlockUserMenuFactory.this.confirm(I18n.tr("Block {0} P2P Users?", hostCount));
        }

        @Override
        public void handleSideEffects() {
        }
    }

    private class DownloadBlockHandler
    implements BlockHandler {
        public DownloadBlockHandler(Collection<RemoteHost> allHosts) {
        }

        @Override
        public boolean confirmBlock(String name) {
            return BlockUserMenuFactory.this.confirm(I18n.tr("Block P2P User {0}?", name));
        }

        @Override
        public boolean confirmBlockAll(int hostCount) {
            return BlockUserMenuFactory.this.confirm(I18n.tr("Block P2P uUers?"));
        }

        @Override
        public void handleSideEffects() {
        }
    }

    private static interface BlockHandler {
        public boolean confirmBlock(String var1);

        public boolean confirmBlockAll(int var1);

        public void handleSideEffects();
    }
}

