/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.pro;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.net.URL;
import java.util.Date;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.color.ColorUtil;
import org.limewire.activation.api.ActivationError;
import org.limewire.activation.api.ActivationItem;
import org.limewire.activation.api.ActivationManager;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.core.api.Application;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.activation.ActivationPanel;
import org.limewire.ui.swing.components.HTMLPane;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.util.EncodingUtils;

class ProNag
extends JXPanel {
    private NagContainer container;
    private final Application application;
    private final ActivationManager activationManager;
    private final HTMLPane editorPane;
    private long offlineShownAt = -1L;

    @Inject
    public ProNag(Application application, ActivationManager activationManager, final GnutellaConnectionManager connectionManager, final Provider<ActivationPanel> activationPanelProvider) {
        super(new BorderLayout());
        this.application = application;
        this.activationManager = activationManager;
        this.editorPane = new HTMLPane();
        this.editorPane.putClientProperty("html.base", "");
        this.setOpaque(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Object a = e.getSourceElement().getAttributes().getAttribute(HTML.Tag.A);
                    Object action = e.getSourceElement().getAttributes().getAttribute(HTML.Attribute.ACTION);
                    Object href = "";
                    if (a instanceof AttributeSet) {
                        href = ((AttributeSet)a).getAttribute(HTML.Attribute.HREF);
                    } else if (action instanceof String) {
                        href = action;
                    }
                    if (href != null && href.equals("_hide_nag_")) {
                        ProNag.this.container.dispose();
                    } else if (href != null && href.equals("_edit_license_")) {
                        ProNag.this.container.dispose();
                        ActivationPanel activationPanel = (ActivationPanel)activationPanelProvider.get();
                        activationPanel.show();
                    } else if (e.getURL() != null) {
                        String url = e.getURL().toExternalForm();
                        if (url.endsWith("?") && url.indexOf(63) != url.length() - 1) {
                            url = url.substring(0, url.length() - 1);
                        }
                        url = url + "&gs=" + connectionManager.getConnectionStrength().getStrengthId();
                        if (ProNag.this.offlineShownAt > 0L) {
                            long delay = System.currentTimeMillis() - ProNag.this.offlineShownAt;
                            url = url + "&offlineDelay=" + delay;
                        }
                        NativeLaunchUtils.openURL(url);
                        ProNag.this.container.dispose();
                    }
                }
            }
        });
        this.add(this.editorPane);
    }

    boolean isModal() {
        HTMLDocument html;
        Element element;
        Document document = this.editorPane.getDocument();
        return !(document instanceof HTMLDocument) || (element = (html = (HTMLDocument)document).getElement(html.getDefaultRootElement(), "modal", "false")) == null || !element.getName().equals("body");
    }

    boolean hasContent() {
        Document document = this.editorPane.getDocument();
        if (document != null) {
            return document.getLength() > 0;
        }
        return false;
    }

    void setContainer(NagContainer dialog) {
        this.container = dialog;
    }

    String getTitle() {
        Object title;
        Document document = this.editorPane.getDocument();
        if (document != null && (title = document.getProperty("title")) instanceof String) {
            return (String)title;
        }
        return null;
    }

    boolean isUndecorated() {
        HTMLDocument html;
        Element element;
        Document document = this.editorPane.getDocument();
        return document instanceof HTMLDocument && (element = (html = (HTMLDocument)document).getElement(html.getDefaultRootElement(), "decorated", "false")) != null && element.getName().equals("body");
    }

    int getDelay() {
        Object delay;
        HTMLDocument html;
        Element element;
        Document document = this.editorPane.getDocument();
        if (document instanceof HTMLDocument && (element = ProNag.getElement((html = (HTMLDocument)document).getDefaultRootElement(), HTML.Tag.BODY)) != null && (delay = element.getAttributes().getAttribute("delay")) != null) {
            try {
                int d = Integer.valueOf(delay.toString());
                if (d >= 0) {
                    return d;
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return 0;
    }

    private static Element getElement(Element e, HTML.Tag tag) {
        if (e.getName() != null && e.getName().equals(tag.toString())) {
            return e;
        }
        int maxCounter = e.getElementCount();
        for (int counter = 0; counter < maxCounter; ++counter) {
            Element retValue = ProNag.getElement(e.getElement(counter), tag);
            if (retValue == null) continue;
            return retValue;
        }
        return null;
    }

    public ListeningFuture<HTMLPane.LoadResult> loadContents(boolean firstLaunch) {
        String bgColor = ColorUtil.toHexString(GuiUtils.getMainFrame().getBackground());
        String url = this.application.addClientInfoToUrl("http://client-data.limewire.com/client_startup/modal_nag/?html32=true&fromFirstRun=" + firstLaunch + "&bgcolor=" + EncodingUtils.encode(bgColor));
        String backupUrl = this.createBackupPage(firstLaunch, bgColor);
        ListeningFuture<HTMLPane.LoadResult> future = this.editorPane.setPageAsynchronous(url, backupUrl);
        future.addFutureListener(new EventListener<FutureEvent<HTMLPane.LoadResult>>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FutureEvent<HTMLPane.LoadResult> event) {
                if (event.getResult() == HTMLPane.LoadResult.OFFLINE_PAGE) {
                    ProNag.this.offlineShownAt = System.currentTimeMillis();
                }
            }
        });
        return future;
    }

    private String createBackupPage(boolean firstLaunch, String bgColor) {
        if (this.activationManager.isProActive()) {
            if (!this.areModulesExpiringSoon()) {
                return "";
            }
            return this.createExpiredPage(firstLaunch, bgColor);
        }
        if (this.activationManager.getActivationError() == ActivationError.BLOCKED_KEY) {
            return this.createBlockedPage(firstLaunch, bgColor);
        }
        return this.createDefaultPage(firstLaunch, bgColor);
    }

    private boolean areModulesExpiringSoon() {
        Date today = new Date();
        double MILLSECS_PER_DAY = 8.64E7;
        for (ActivationItem item : this.activationManager.getActivationItems()) {
            Date expirationDate = item.getDateExpired();
            double deltaDays = ((double)expirationDate.getTime() - (double)today.getTime()) / MILLSECS_PER_DAY;
            if (!(deltaDays < 3.0)) continue;
            return true;
        }
        return false;
    }

    private String createDefaultPage(boolean firstLaunch, String bgColor) {
        URL bgImage = ProNag.class.getResource("/org/limewire/ui/swing/mainframe/resources/icons/static_pages/update_background.png");
        String outgoing = "http://www.limewire.com/download/pro/?rmnv=z&fromFirstRun=" + firstLaunch;
        outgoing = this.application.addClientInfoToUrl(outgoing);
        String yes = (outgoing + "&ref=lwn8").replace("&", "&amp;");
        String why = (outgoing + "&ref=lwn9").replace("&", "&amp;");
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"><html><head><title>" + I18n.tr("Upgrade to Pro!") + "</title></head>" + "<body>" + "<center>" + "<table cellspacing=\"0\" cellpadding=\"8\" border=\"0\" bgcolor=\"" + bgColor + "\">" + "<tr><td align=\"center\">" + "<table width=\"355\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" background=\"" + bgImage.toExternalForm() + "\">" + "<tr><td height=\"126\">" + "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">" + "<tr>" + "<td>" + "<table width=\"110\" cellpadding=\"0\" cellspacing\"0\" border=\"0\"></table>" + "</td>" + "<td align=\"left\" valign=\"center\">" + "<b>" + I18n.tr("Upgrade to PRO today!") + "</b>" + "<br/>" + I18n.tr("Turbo-charged downloads") + "<br/>" + I18n.tr("More search results") + "<br/>" + I18n.tr("Free tech support and upgrades") + "</td>" + "</tr>" + "</table>" + "</td></tr>" + "</table>" + "</tr></td>" + "<tr><td align=\"center\">" + I18n.tr("Upgrade to LimeWire PRO?") + "<br/>" + "<table cellspacing=\"3\" cellpadding=\"0\" border=\"0\"><tr>" + "<td><form action=\"" + yes + "\"><input type=\"submit\" value=\"" + I18n.tr("Yes") + "\"/></form></td>" + "<td><form action=\"" + why + "\"><input type=\"submit\" value=\"" + I18n.tr("Why") + "\"/></form></td>" + "<td><form action=\"_hide_nag_\"><input type=\"submit\" value=\"" + I18n.tr("Later") + "\"/></form></td>" + "</tr></table>" + "</td>" + "</tr>" + "</table>" + "</center>" + "</body>" + "</html>";
    }

    private String createBlockedPage(boolean firstLaunch, String bgColor) {
        String customerSupportURL = this.application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=proSupport").replace("&", "&amp;");
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"><html><head><title>LimeWire " + I18n.tr("License") + "</title></head>" + "<body   >" + "<center>" + "<table width=\"330\" height=\"125\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" bgcolor=\"" + bgColor + "\">" + "<tr>" + "<td width=\"15\"></td>" + "<td colspan=2 >" + "<table width=\"300\" height=\"90\" cellspacing=\"5\" cellpadding=\"0\" border=\"0\" bgcolor=\"" + bgColor + "\">" + "<tr><td valign=bottom height=\"25\">" + "<font size=4 color=\"#59762d\"><b>" + I18n.tr("Sorry, your license key has been blocked") + "</b></font>" + "</td></tr>" + "<tr ><td height=\"50\">" + "<font size=4>" + I18n.tr("Your license key has been used on too many installations. ") + I18n.tr("Please {0}contact support{1} to resolve the situation.", "<a href=\"" + customerSupportURL + "\">", "</a>") + "</font>" + "</td></tr>" + "</table>" + "</td>" + "<td width=\"15\"></td>" + "</tr>" + "<tr valign=top>" + "<td width=\"15\"></td>" + "<td align=left height=\"40\"><form action=\"_edit_license_\"><input type=\"submit\" name=\"edit_key\" value=\"" + I18n.tr("Edit License Key") + "\" id=\"\"></form></td>" + "<td align=right><form action=\"_hide_nag_\"><input type=\"submit\" value=\"" + I18n.tr("Later") + "\"/></form></td>" + "<td width=\"15\"></td>" + "</tr>" + "</table>" + "</center>" + "</body>";
    }

    private String createExpiredPage(boolean firstLaunch, String bgColor) {
        String renewURL = this.application.addClientInfoToUrl("http://www.limewire.com/client_redirect/?page=renewPro").replace("&", "&amp;");
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"><html><head><title>" + I18n.tr("Time to Renew Your LimeWire") + "</title></head>" + "<body   >" + "<center>" + "<table width=\"400\" height=\"115\" cellspacing=\"5\" cellpadding=\"0\" border=\"0\" bgcolor=\"" + bgColor + "\">" + "<tr>" + "<td width=\"15\"></td>" + "<td colspan=2 height=\"30\" valign=bottom><font size=4 color=\"#59762d\"><b>" + I18n.tr("Your LimeWire subscription will be expiring shortly.") + "</b></font></td>" + "<td width=\"15\"></td>" + "</tr>" + "<tr>" + "<td width=\"15\"></td>" + "<td colspan=2 height=\"30\" valign=top><font size=4 color=\"#59762d\"><b>" + I18n.tr("Don't miss a thing - act now for special renewal pricing!") + "</b></font></td>" + "<td width=\"15\"></td>" + "</tr>" + "<tr valign=top>" + "<td width=\"15\"></td>" + "<td align=right height=\"40\" width=\"290\"><form action=\"" + renewURL + "\" method=\"GET\" target=\"_blank\">" + "<input type=\"submit\" value=\"" + I18n.tr("Renew Now") + "\"/>" + "</form></td> " + "<td align=right><form action=\"_hide_nag_\"><input type=\"submit\" value=\"" + I18n.tr("Later") + "\"/></form></td>" + "<td width=\"15\"></td>" + "</tr>" + "</table>" + "</center>" + "</body>";
    }

    static interface NagContainer {
        public void dispose();
    }
}

