/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentSettingsAnnotation;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.UploadSettings;
import org.limewire.ui.swing.components.EmbeddedComponentLabel;
import org.limewire.ui.swing.components.PeriodicFieldValidator;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class TransferLimitsOptionPanel
extends OptionPanel {
    private final DownloadsPanel downloadsPanel;
    private final UploadsPanel uploadPanel;
    private final Provider<TorrentManager> torrentManager;
    private final TorrentManagerSettings torrentSettings;

    @Inject
    public TransferLimitsOptionPanel(Provider<TorrentManager> torrentManager, @TorrentSettingsAnnotation TorrentManagerSettings torrentSettings) {
        this.torrentManager = torrentManager;
        this.torrentSettings = torrentSettings;
        this.downloadsPanel = new DownloadsPanel();
        this.uploadPanel = new UploadsPanel();
        this.setLayout(new MigLayout("fill"));
        this.setOpaque(false);
        this.add((Component)this.downloadsPanel, "pushx, growx, wrap");
        this.add((Component)new JSeparator(), "growx, wrap");
        this.add((Component)this.uploadPanel, "pushx, growx, wrap");
        this.add((Component)new JButton(new OKDialogAction()), "tag ok, alignx right, split 2");
        this.add((Component)new JButton(new CancelDialogAction()), "tag cancel");
    }

    @Override
    boolean applyOptions() {
        boolean restart = this.downloadsPanel.applyOptions();
        restart |= this.uploadPanel.applyOptions();
        if (this.torrentManager.get().isInitialized() && this.torrentManager.get().isValid()) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ((TorrentManager)TransferLimitsOptionPanel.this.torrentManager.get()).setTorrentManagerSettings(TransferLimitsOptionPanel.this.torrentSettings);
                }
            });
        }
        return restart;
    }

    @Override
    boolean hasChanged() {
        return this.downloadsPanel.hasChanged() || this.uploadPanel.hasChanged();
    }

    @Override
    public void initOptions() {
        this.downloadsPanel.initOptions();
        this.uploadPanel.initOptions();
    }

    private static class CheckBoxListener
    implements ItemListener {
        private JComponent component;
        private JCheckBox checkBox;

        public CheckBoxListener(JComponent slider, JCheckBox checkBox) {
            this.component = slider;
            this.checkBox = checkBox;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.component.setVisible(this.checkBox.isSelected());
        }
    }

    private static class UploadsPanel
    extends OptionPanel {
        private static final int MIN_UPLOADS = 0;
        private static final int MAX_UPLOADS = 50;
        private JSpinner maxUploadSpinner;
        private JCheckBox limitBandwidthCheckBox;
        private JSpinner maxUploadSpeedSpinner;
        private final EmbeddedComponentLabel maxUploadSpeedController;

        public UploadsPanel() {
            this.setLayout(new MigLayout("insets 4, fill, nogrid"));
            this.setOpaque(false);
            this.maxUploadSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
            JFormattedTextField maxUploadField = ((JSpinner.DefaultEditor)this.maxUploadSpinner.getEditor()).getTextField();
            maxUploadField.addKeyListener(new PeriodicFieldValidator(maxUploadField));
            this.limitBandwidthCheckBox = new JCheckBox(I18n.tr("Limit your upload bandwidth"));
            this.limitBandwidthCheckBox.setContentAreaFilled(false);
            this.maxUploadSpeedSpinner = new JSpinner(new SpinnerNumberModel(UploadSettings.MAX_UPLOAD_SPEED.getValue() / 1024, (Integer)UploadSettings.MAX_UPLOAD_SPEED.getMinValue() / 1024, (Integer)UploadSettings.MAX_UPLOAD_SPEED.getMaxValue() / 1024, 1));
            JFormattedTextField maxUploadSpeedField = ((JSpinner.DefaultEditor)this.maxUploadSpeedSpinner.getEditor()).getTextField();
            maxUploadSpeedField.addKeyListener(new PeriodicFieldValidator(maxUploadSpeedField));
            this.maxUploadSpeedController = new EmbeddedComponentLabel("{c} KB/s", this.maxUploadSpeedSpinner);
            this.maxUploadSpeedController.setVisible(false);
            this.limitBandwidthCheckBox.addItemListener(new CheckBoxListener(this.maxUploadSpeedController, this.limitBandwidthCheckBox));
            this.add(new JLabel(I18n.tr("Maximum uploads at once:")));
            this.add((Component)this.maxUploadSpinner, "wrap");
            this.add(this.limitBandwidthCheckBox);
            this.add((Component)this.maxUploadSpeedController, "wrap");
        }

        @Override
        boolean applyOptions() {
            UploadSettings.HARD_MAX_UPLOADS.setValue((Integer)this.maxUploadSpinner.getModel().getValue());
            UploadSettings.MAX_UPLOAD_SPEED.setValue((Integer)this.maxUploadSpeedSpinner.getValue() * 1024);
            UploadSettings.LIMIT_MAX_UPLOAD_SPEED.setValue(this.limitBandwidthCheckBox.isSelected());
            return false;
        }

        @Override
        boolean hasChanged() {
            return UploadSettings.HARD_MAX_UPLOADS.getValue() != ((Integer)this.maxUploadSpinner.getModel().getValue()).intValue() || UploadSettings.MAX_UPLOAD_SPEED.getValue() != (Integer)this.maxUploadSpeedSpinner.getValue() * 1024 || UploadSettings.LIMIT_MAX_UPLOAD_SPEED.getValue() != this.limitBandwidthCheckBox.isSelected();
        }

        @Override
        public void initOptions() {
            this.maxUploadSpeedSpinner.setValue(UploadSettings.MAX_UPLOAD_SPEED.getValue() / 1024);
            this.maxUploadSpinner.getModel().setValue(UploadSettings.HARD_MAX_UPLOADS.getValue());
            this.limitBandwidthCheckBox.setSelected(UploadSettings.LIMIT_MAX_UPLOAD_SPEED.getValue());
        }
    }

    private class DownloadsPanel
    extends OptionPanel {
        private static final int MIN_DOWNLOADS = 1;
        private static final int MAX_DOWNLOADS = 999;
        private final JSpinner maxDownloadSpinner;
        private final JSpinner maxDownloadSpeedSpinner;
        private final JCheckBox limitBandWidthCheckBox;
        private final EmbeddedComponentLabel maxDownloadSpeedController;

        public DownloadsPanel() {
            this.setLayout(new MigLayout("insets 4, fill, nogrid"));
            this.setOpaque(false);
            this.maxDownloadSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
            JFormattedTextField maxDownloadField = ((JSpinner.DefaultEditor)this.maxDownloadSpinner.getEditor()).getTextField();
            maxDownloadField.addKeyListener(new PeriodicFieldValidator(maxDownloadField));
            this.maxDownloadSpeedSpinner = new JSpinner(new SpinnerNumberModel(DownloadSettings.MAX_DOWNLOAD_SPEED.getValue() / 1024, (Integer)DownloadSettings.MAX_DOWNLOAD_SPEED.getMinValue() / 1024, (Integer)DownloadSettings.MAX_DOWNLOAD_SPEED.getMaxValue() / 1024, 1));
            JFormattedTextField maxDownloadSpeedField = ((JSpinner.DefaultEditor)this.maxDownloadSpeedSpinner.getEditor()).getTextField();
            maxDownloadSpeedField.addKeyListener(new PeriodicFieldValidator(maxDownloadSpeedField));
            this.limitBandWidthCheckBox = new JCheckBox(I18n.tr("Limit your download bandwidth"));
            this.limitBandWidthCheckBox.setContentAreaFilled(false);
            this.maxDownloadSpeedController = new EmbeddedComponentLabel("{c} KB/s", this.maxDownloadSpeedSpinner);
            this.maxDownloadSpeedController.setVisible(false);
            this.limitBandWidthCheckBox.addItemListener(new CheckBoxListener(this.maxDownloadSpeedController, this.limitBandWidthCheckBox));
            this.add(new JLabel(I18n.tr("Maximum downloads at once:")));
            this.add((Component)this.maxDownloadSpinner, "wrap");
            this.add(this.limitBandWidthCheckBox);
            this.add((Component)this.maxDownloadSpeedController, "wrap");
        }

        @Override
        boolean applyOptions() {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue((Integer)this.maxDownloadSpinner.getModel().getValue());
            DownloadSettings.MAX_DOWNLOAD_SPEED.setValue((Integer)this.maxDownloadSpeedSpinner.getValue() * 1024);
            DownloadSettings.LIMIT_MAX_DOWNLOAD_SPEED.setValue(this.limitBandWidthCheckBox.isSelected());
            return false;
        }

        @Override
        boolean hasChanged() {
            return DownloadSettings.MAX_SIM_DOWNLOAD.getValue() != ((Integer)this.maxDownloadSpinner.getModel().getValue()).intValue() || DownloadSettings.MAX_DOWNLOAD_SPEED.getValue() != (Integer)this.maxDownloadSpeedSpinner.getValue() * 1024 || DownloadSettings.LIMIT_MAX_DOWNLOAD_SPEED.getValue() != this.limitBandWidthCheckBox.isSelected();
        }

        @Override
        public void initOptions() {
            this.maxDownloadSpeedSpinner.setValue(DownloadSettings.MAX_DOWNLOAD_SPEED.getValue() / 1024);
            this.limitBandWidthCheckBox.setSelected(DownloadSettings.LIMIT_MAX_DOWNLOAD_SPEED.getValue());
            this.maxDownloadSpinner.getModel().setValue(DownloadSettings.MAX_SIM_DOWNLOAD.getValue());
        }
    }
}

