/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.settings.UpdateSettings;
import org.limewire.setting.BooleanSetting;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.options.actions.DialogDisplayAction;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.settings.BugSettings;
import org.limewire.ui.swing.settings.StartupSettings;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.shell.LimeAssociationOption;
import org.limewire.ui.swing.shell.LimeAssociations;
import org.limewire.ui.swing.tray.TrayNotifier;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.MacOSXUtils;
import org.limewire.ui.swing.util.WindowsUtils;
import org.limewire.util.OSUtils;

public class SystemOptionPanel
extends OptionPanel {
    private final TrayNotifier trayNotifier;
    private final FileAssociationPanel fileAssociationPanel;
    private final StartupShutdownPanel startupShutdownPanel;
    private final BugsAndUpdatesPanel bugsAndUpdatesPanel;

    @Inject
    public SystemOptionPanel(TrayNotifier trayNotifier) {
        this.trayNotifier = trayNotifier;
        this.setLayout(new MigLayout("hidemode 3, insets 15, fillx, wrap"));
        this.setOpaque(false);
        this.fileAssociationPanel = new FileAssociationPanel();
        this.startupShutdownPanel = new StartupShutdownPanel();
        this.bugsAndUpdatesPanel = new BugsAndUpdatesPanel();
        this.add((Component)this.fileAssociationPanel, "pushx, growx");
        this.add((Component)this.startupShutdownPanel, "pushx, growx");
        this.add((Component)this.bugsAndUpdatesPanel, "pushx, growx");
    }

    @Override
    boolean applyOptions() {
        boolean restart = this.fileAssociationPanel.applyOptions();
        restart |= this.startupShutdownPanel.applyOptions();
        return restart |= this.bugsAndUpdatesPanel.applyOptions();
    }

    @Override
    boolean hasChanged() {
        return this.fileAssociationPanel.hasChanged() || this.startupShutdownPanel.hasChanged() || this.bugsAndUpdatesPanel.hasChanged();
    }

    @Override
    public void initOptions() {
        this.fileAssociationPanel.initOptions();
        this.startupShutdownPanel.initOptions();
        this.bugsAndUpdatesPanel.initOptions();
    }

    private static class BugsPanel
    extends OptionPanel {
        private JRadioButton showBugsBeforeSendingButton;
        private JRadioButton alwaysSendBugsButton;
        private JRadioButton neverSendBugsButton;

        public BugsPanel() {
            this.setLayout(new MigLayout("fill"));
            this.setOpaque(false);
            this.showBugsBeforeSendingButton = new JRadioButton(I18n.tr("Let me know about bugs before sending them"));
            this.showBugsBeforeSendingButton.setContentAreaFilled(false);
            this.alwaysSendBugsButton = new JRadioButton(I18n.tr("Always send bugs to Lime Wire"));
            this.alwaysSendBugsButton.setContentAreaFilled(false);
            this.neverSendBugsButton = new JRadioButton(I18n.tr("Never send bugs to Lime Wire"));
            this.neverSendBugsButton.setContentAreaFilled(false);
            ButtonGroup bugsButtonGroup = new ButtonGroup();
            bugsButtonGroup.add(this.showBugsBeforeSendingButton);
            bugsButtonGroup.add(this.alwaysSendBugsButton);
            bugsButtonGroup.add(this.neverSendBugsButton);
            this.add((Component)this.showBugsBeforeSendingButton, "wrap");
            this.add((Component)this.alwaysSendBugsButton, "wrap");
            this.add((Component)this.neverSendBugsButton, "gapbottom 5, wrap");
            this.add((Component)new JButton(new OKDialogAction()), "tag ok, alignx right, split 2");
            this.add((Component)new JButton(new CancelDialogAction()), "tag cancel");
        }

        @Override
        boolean applyOptions() {
            if (this.showBugsBeforeSendingButton.isSelected()) {
                BugSettings.SHOW_BUGS.setValue(true);
                BugSettings.REPORT_BUGS.setValue(true);
            } else if (this.alwaysSendBugsButton.isSelected()) {
                BugSettings.SHOW_BUGS.setValue(false);
                BugSettings.REPORT_BUGS.setValue(true);
            } else {
                BugSettings.SHOW_BUGS.setValue(false);
                BugSettings.REPORT_BUGS.setValue(false);
            }
            return false;
        }

        @Override
        boolean hasChanged() {
            return this.hasChanged(this.alwaysSendBugsButton, BugSettings.REPORT_BUGS) || this.hasChanged(this.showBugsBeforeSendingButton, BugSettings.SHOW_BUGS);
        }

        private boolean hasChanged(JRadioButton radioButton, BooleanSetting setting) {
            return setting.getValue() != radioButton.isSelected();
        }

        @Override
        public void initOptions() {
            if (BugSettings.SHOW_BUGS.getValue()) {
                this.showBugsBeforeSendingButton.setSelected(true);
            } else if (BugSettings.REPORT_BUGS.getValue()) {
                this.alwaysSendBugsButton.setSelected(true);
            } else {
                this.neverSendBugsButton.setSelected(true);
            }
        }
    }

    private static class BugsAndUpdatesPanel
    extends OptionPanel {
        private final BugsPanel bugsPanel;
        private final JCheckBox betaCheckBox = new JCheckBox(I18n.tr("Tell me about Beta updates"));

        public BugsAndUpdatesPanel() {
            super(I18n.tr("Bugs and Updates"));
            this.betaCheckBox.setContentAreaFilled(false);
            this.bugsPanel = new BugsPanel();
            this.add((Component)this.betaCheckBox, "wrap");
            this.add((Component)new JButton(new DialogDisplayAction(this, this.bugsPanel, I18n.tr("Bug Reports"), I18n.tr("Bug Reports..."), I18n.tr("Configure bug report settings."))), "wrap");
        }

        @Override
        public boolean applyOptions() {
            boolean restart = this.bugsPanel.applyOptions();
            if (this.betaCheckBox.isSelected()) {
                UpdateSettings.UPDATE_STYLE.setValue(0);
            } else {
                UpdateSettings.UPDATE_STYLE.setValue(1);
            }
            return restart;
        }

        @Override
        public boolean hasChanged() {
            int expectedUpdateStyle = this.betaCheckBox.isSelected() ? 0 : 1;
            return this.bugsPanel.hasChanged() || UpdateSettings.UPDATE_STYLE.getValue() != expectedUpdateStyle;
        }

        @Override
        public void initOptions() {
            this.bugsPanel.initOptions();
            this.betaCheckBox.setSelected(UpdateSettings.UPDATE_STYLE.getValue() == 0);
        }
    }

    private class StartupShutdownPanel
    extends OptionPanel {
        private JCheckBox runAtStartupCheckBox;
        private JRadioButton minimizeButton;
        private JRadioButton exitButton;
        private boolean displaySystemTrayIcon;

        public StartupShutdownPanel() {
            super(I18n.tr("Startup and Shutdown"));
            this.displaySystemTrayIcon = false;
            this.runAtStartupCheckBox = new JCheckBox(I18n.tr("Run LimeWire on System Startup"));
            this.runAtStartupCheckBox.setContentAreaFilled(false);
            this.minimizeButton = new JRadioButton(I18n.tr("Minimize to system tray"));
            this.minimizeButton.setContentAreaFilled(false);
            this.exitButton = new JRadioButton(I18n.tr("Exit program"));
            this.exitButton.setContentAreaFilled(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.minimizeButton);
            buttonGroup.add(this.exitButton);
            if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
                this.add((Component)this.runAtStartupCheckBox, "wrap");
            }
            if (SystemOptionPanel.this.trayNotifier.supportsSystemTray()) {
                this.add((Component)new JLabel(I18n.tr("When I press X:")), "wrap");
                this.add((Component)this.minimizeButton, "gapleft 10");
                this.add(this.exitButton);
            }
        }

        @Override
        boolean applyOptions() {
            if (OSUtils.isMacOSX()) {
                MacOSXUtils.setLoginStatus(this.runAtStartupCheckBox.isSelected());
            } else if (WindowsUtils.isLoginStatusAvailable()) {
                BackgroundExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        WindowsUtils.setLoginStatus(StartupShutdownPanel.this.runAtStartupCheckBox.isSelected());
                    }
                });
            }
            StartupSettings.RUN_ON_STARTUP.setValue(this.runAtStartupCheckBox.isSelected());
            SwingUiSettings.MINIMIZE_TO_TRAY.setValue(this.minimizeButton.isSelected());
            if (SwingUiSettings.MINIMIZE_TO_TRAY.getValue()) {
                SystemOptionPanel.this.trayNotifier.showTrayIcon();
            } else {
                SystemOptionPanel.this.trayNotifier.hideTrayIcon();
            }
            return false;
        }

        @Override
        boolean hasChanged() {
            return StartupSettings.RUN_ON_STARTUP.getValue() != this.runAtStartupCheckBox.isSelected() || SwingUiSettings.MINIMIZE_TO_TRAY.getValue() != this.minimizeButton.isSelected() || this.isIconDisplayed();
        }

        private boolean isIconDisplayed() {
            if ((this.runAtStartupCheckBox.isSelected() || this.minimizeButton.isSelected()) && OSUtils.supportsTray()) {
                return !this.displaySystemTrayIcon;
            }
            return this.displaySystemTrayIcon;
        }

        @Override
        public void initOptions() {
            this.runAtStartupCheckBox.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
            this.minimizeButton.setSelected(SwingUiSettings.MINIMIZE_TO_TRAY.getValue());
            this.exitButton.setSelected(!SwingUiSettings.MINIMIZE_TO_TRAY.getValue());
        }
    }

    private static class FileAssociationPanel
    extends OptionPanel {
        private JCheckBox magnetCheckBox;
        private JCheckBox torrentCheckBox;
        private JCheckBox warnCheckBox;

        public FileAssociationPanel() {
            super(I18n.tr("File Associations"));
            this.setLayout(new MigLayout("insets 0, gap 0, hidemode 3"));
            this.setOpaque(false);
            this.magnetCheckBox = new JCheckBox(I18n.tr("\".magnet\" files"));
            this.magnetCheckBox.setContentAreaFilled(false);
            this.magnetCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileAssociationPanel.this.updateView();
                }
            });
            this.torrentCheckBox = new JCheckBox(I18n.tr("\".torrent\" files"));
            this.torrentCheckBox.setContentAreaFilled(false);
            this.torrentCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileAssociationPanel.this.updateView();
                }
            });
            this.warnCheckBox = new JCheckBox("<html>" + I18n.tr("Warn me when other programs want to automatically open these types") + "</html>");
            this.warnCheckBox.setContentAreaFilled(false);
            this.add((Component)this.magnetCheckBox, "gapleft 5, gapbottom 5, wrap");
            this.add((Component)this.torrentCheckBox, "gapleft 5, push");
            this.add(this.warnCheckBox);
        }

        @Override
        boolean applyOptions() {
            if (this.hasChanged(this.magnetCheckBox, SwingUiSettings.HANDLE_MAGNETS)) {
                this.applyOption(this.magnetCheckBox, SwingUiSettings.HANDLE_MAGNETS);
                LimeAssociationOption magnetAssociationOption = LimeAssociations.getMagnetAssociation();
                if (magnetAssociationOption != null) {
                    magnetAssociationOption.setEnabled(this.magnetCheckBox.isSelected());
                }
            }
            if (this.hasChanged(this.torrentCheckBox, SwingUiSettings.HANDLE_TORRENTS)) {
                this.applyOption(this.torrentCheckBox, SwingUiSettings.HANDLE_TORRENTS);
                LimeAssociationOption torrentAssociationOption = LimeAssociations.getTorrentAssociation();
                if (torrentAssociationOption != null) {
                    torrentAssociationOption.setEnabled(this.torrentCheckBox.isSelected());
                }
            }
            if (this.hasChanged(this.warnCheckBox, SwingUiSettings.WARN_FILE_ASSOCIATION_CHANGES)) {
                this.applyOption(this.warnCheckBox, SwingUiSettings.WARN_FILE_ASSOCIATION_CHANGES);
            }
            return false;
        }

        private void applyOption(JCheckBox checkBox, BooleanSetting booleanSetting) {
            booleanSetting.setValue(checkBox.isSelected());
        }

        @Override
        boolean hasChanged() {
            return this.hasChanged(this.magnetCheckBox, SwingUiSettings.HANDLE_MAGNETS) || this.hasChanged(this.torrentCheckBox, SwingUiSettings.HANDLE_TORRENTS) || this.hasChanged(this.warnCheckBox, SwingUiSettings.WARN_FILE_ASSOCIATION_CHANGES);
        }

        private boolean hasChanged(JCheckBox checkBox, BooleanSetting booleanSetting) {
            return booleanSetting.getValue() != checkBox.isSelected();
        }

        @Override
        public void initOptions() {
            boolean selected = SwingUiSettings.HANDLE_MAGNETS.getValue() && LimeAssociations.isMagnetAssociationSupported() && LimeAssociations.getMagnetAssociation().isEnabled();
            this.initOption(this.magnetCheckBox, selected);
            if (selected) {
                this.magnetCheckBox.setEnabled(LimeAssociations.getMagnetAssociation().canDisassociate());
            }
            selected = SwingUiSettings.HANDLE_TORRENTS.getValue() && LimeAssociations.isTorrentAssociationSupported() && LimeAssociations.getTorrentAssociation().isEnabled();
            this.initOption(this.torrentCheckBox, selected);
            if (selected) {
                this.torrentCheckBox.setEnabled(LimeAssociations.getTorrentAssociation().canDisassociate());
            }
            selected = SwingUiSettings.WARN_FILE_ASSOCIATION_CHANGES.getValue();
            this.initOption(this.warnCheckBox, selected);
            this.updateView();
        }

        private void updateView() {
            boolean warnShouldBeVisible = this.magnetCheckBox.isSelected() || this.torrentCheckBox.isSelected();
            this.warnCheckBox.setVisible(warnShouldBeVisible);
            boolean torrentShouldBeVisible = LimeAssociations.isTorrentAssociationSupported();
            this.torrentCheckBox.setVisible(torrentShouldBeVisible);
            boolean magnetShouldBeVisible = LimeAssociations.isMagnetAssociationSupported();
            this.magnetCheckBox.setVisible(magnetShouldBeVisible);
            this.setVisible(torrentShouldBeVisible || magnetShouldBeVisible);
        }

        private void initOption(JCheckBox checkBox, boolean value) {
            checkBox.setSelected(value);
        }
    }
}

