/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CompositeList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.core.settings.FilterSettings;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.setting.Setting;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.options.AbstractFilterOptionPanel;
import org.limewire.ui.swing.options.OptionPanelStateManager;
import org.limewire.ui.swing.options.UnsafeTypeOptionPanelStateManager;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.util.OSUtils;

public class FilterFileExtensionsOptionPanel
extends AbstractFilterOptionPanel {
    private final SpamManager spamManager;
    private final CategoryManager categoryManager;
    private final UnsafeTypeOptionPanelStateManager settingStateManager;
    private JButton defaultButton;
    private JButton okButton;
    private JTextField keywordTextField;
    private JButton addKeywordButton;
    private JXTable filterTable;
    private final EventList<String> immutableProgramsList;

    @Inject
    public FilterFileExtensionsOptionPanel(IconManager iconManager, SpamManager spamManager, CategoryManager categoryManager, UnsafeTypeOptionPanelStateManager settingStateManager) {
        this.spamManager = spamManager;
        this.categoryManager = categoryManager;
        this.settingStateManager = settingStateManager;
        this.setLayout(new MigLayout("gapy 10, nogrid"));
        this.keywordTextField = new JTextField(30);
        this.addKeywordButton = new JButton(I18n.tr("Add Extension"));
        TextFieldClipboardControl.install(this.keywordTextField);
        CompositeList<String> allExtensions = new CompositeList<String>(this.eventList.getPublisher(), this.eventList.getReadWriteLock());
        allExtensions.addMemberList(this.eventList);
        this.immutableProgramsList = new BasicEventList<String>(this.eventList.getPublisher(), this.eventList.getReadWriteLock());
        allExtensions.addMemberList(this.immutableProgramsList);
        this.filterTable = new MouseableTable(new DefaultEventTableModel<String>(allExtensions, new FileFilterTableFormat(categoryManager, iconManager)));
        this.filterTable.setShowGrid(false, false);
        this.filterTable.setColumnSelectionAllowed(false);
        this.filterTable.setSelectionMode(0);
        TableColumn iconColumn = this.filterTable.getColumn(0);
        iconColumn.setCellRenderer(new IconRenderer());
        iconColumn.setWidth(16);
        iconColumn.setMaxWidth(16);
        iconColumn.setMinWidth(16);
        TableColumn removeColumn = this.filterTable.getColumn(FileFilterTableFormat.columnNames.length - 1);
        removeColumn.setCellRenderer(new AbstractFilterOptionPanel.RemoveButtonRenderer(this.filterTable));
        removeColumn.setCellEditor(new AbstractFilterOptionPanel.RemoveButtonRenderer(this.filterTable));
        this.okButton = new JButton(new OKDialogAction());
        this.addKeywordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = FilterFileExtensionsOptionPanel.this.keywordTextField.getText();
                if (text == null || text.trim().length() == 0) {
                    return;
                }
                if ((text = text.trim()).charAt(0) != '.') {
                    text = "." + text;
                }
                if (!FilterFileExtensionsOptionPanel.this.eventList.contains(text) && !FilterFileExtensionsOptionPanel.this.immutableProgramsList.contains(text)) {
                    FilterFileExtensionsOptionPanel.this.eventList.add(text);
                }
                FilterFileExtensionsOptionPanel.this.keywordTextField.setText("");
            }
        });
        this.defaultButton = new JButton(new DefaultAction());
        this.add((Component)new MultiLineLabel(I18n.tr("LimeWire will not show files with the following extensions in your search results"), 300), "span, wrap");
        this.add((Component)this.keywordTextField, "gapright 10");
        this.add((Component)this.addKeywordButton, "wrap");
        this.add((Component)new JScrollPane(this.filterTable), "span 2, grow, wrap");
        this.add((Component)this.defaultButton, "alignx left");
        this.add((Component)this.okButton, "tag ok, alignx right");
    }

    @Override
    boolean applyOptions() {
        String[] values = this.eventList.toArray(new String[this.eventList.size()]);
        FilterSettings.BANNED_EXTENSIONS.set(values);
        BackgroundExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                FilterFileExtensionsOptionPanel.this.spamManager.adjustSpamFilters();
            }
        });
        return false;
    }

    @Override
    boolean hasChanged() {
        List<String> model = Arrays.asList(FilterSettings.BANNED_EXTENSIONS.get());
        String[] values = this.eventList.toArray(new String[this.eventList.size()]);
        return ((Object)model).equals(new ArrayList<String>(Arrays.asList(values)));
    }

    private void updateItems() {
        this.eventList.clear();
        this.immutableProgramsList.clear();
        if (this.settingStateManager.getValue(LibrarySettings.ALLOW_PROGRAMS) == Boolean.FALSE) {
            for (String extension : this.categoryManager.getExtensionsForCategory(Category.PROGRAM)) {
                this.immutableProgramsList.add("." + extension);
            }
        }
        for (String extension : FilterSettings.BANNED_EXTENSIONS.get()) {
            if (this.immutableProgramsList.contains(extension)) continue;
            this.eventList.add(extension);
        }
    }

    @Override
    public void initOptions() {
        this.updateItems();
        this.settingStateManager.addSettingChangedListener(new OptionPanelStateManager.SettingChangedListener(){

            @Override
            public void settingChanged(Setting setting) {
                if (setting == LibrarySettings.ALLOW_PROGRAMS) {
                    FilterFileExtensionsOptionPanel.this.updateItems();
                }
            }
        });
    }

    private static class IconRenderer
    implements TableCellRenderer {
        private final JLabel component = new JLabel();

        private IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            this.component.setIcon((Icon)value);
            return this.component;
        }
    }

    private static class FileFilterTableFormat
    implements TableFormat<String> {
        private final CategoryManager categoryManager;
        private final IconManager iconManager;
        final int ICON_COLUMN = 0;
        final int CATEGORY_COLUMN = 2;
        final int TYPE_COLUMN = 3;
        static final String[] columnNames;

        public FileFilterTableFormat(CategoryManager cagetoryManager, IconManager iconManager) {
            this.categoryManager = cagetoryManager;
            this.iconManager = iconManager;
        }

        @Override
        public Object getColumnValue(String baseObject, int column) {
            switch (column) {
                case 0: {
                    return this.iconManager.getIconForExtension(baseObject.substring(1));
                }
                case 2: {
                    return this.categoryManager.getCategoryForExtension(baseObject.substring(1));
                }
                case 3: {
                    if (!OSUtils.isWindows()) break;
                    return this.iconManager.getIconForExtension(baseObject.substring(1)).toString();
                }
            }
            return baseObject;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        static {
            String[] stringArray;
            if (OSUtils.isWindows()) {
                String[] stringArray2 = new String[5];
                stringArray2[0] = "";
                stringArray2[1] = I18n.tr("Extension");
                stringArray2[2] = I18n.tr("Category");
                stringArray2[3] = I18n.tr("Type");
                stringArray = stringArray2;
                stringArray2[4] = "";
            } else {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "";
                stringArray3[1] = I18n.tr("Extension");
                stringArray3[2] = I18n.tr("Category");
                stringArray = stringArray3;
                stringArray3[3] = "";
            }
            columnNames = stringArray;
        }
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Revert to default settings"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterSettings.BANNED_EXTENSIONS.revertToDefault();
            FilterFileExtensionsOptionPanel.this.updateItems();
        }
    }
}

