/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.List;
import javax.swing.JMenu;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.library.LibraryPanel;
import org.limewire.ui.swing.library.table.AddToListMenu;
import org.limewire.ui.swing.library.table.ShowInListMenu;

public class ListMenuFactory {
    private final SharedFileListManager sharedFileListManager;
    private final LibraryManager libraryManager;
    private final LibraryPanel libraryPanel;

    @Inject
    public ListMenuFactory(SharedFileListManager sharedFileListManager, LibraryManager libraryManager, LibraryPanel libraryPanel) {
        this.sharedFileListManager = sharedFileListManager;
        this.libraryManager = libraryManager;
        this.libraryPanel = libraryPanel;
    }

    public JMenu createAddToListMenu(Provider<List<File>> selectedFiles) {
        AddToListMenu menu = new AddToListMenu(selectedFiles);
        menu.initialize(this.sharedFileListManager);
        return menu;
    }

    public JMenu createShowInListMenu(Provider<List<File>> selectedFiles, boolean showLibrary) {
        ShowInListMenu menu = new ShowInListMenu(selectedFiles);
        menu.initialize(this.sharedFileListManager, this.libraryManager, this.libraryPanel, showLibrary);
        return menu;
    }

    public JMenu createShowInListMenu(Provider<List<File>> selectedFiles, Provider<LocalFileList> selectedLocalFileList, boolean showLibrary) {
        ShowInListMenu menu = new ShowInListMenu(selectedFiles, selectedLocalFileList);
        menu.initialize(this.sharedFileListManager, this.libraryManager, this.libraryPanel, showLibrary);
        return menu;
    }
}

