/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.core.api.Category;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.components.FancyTab;
import org.limewire.ui.swing.components.FancyTabList;
import org.limewire.ui.swing.components.NoOpAction;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.components.TabActionMap;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.components.decorators.TextFieldDecorator;
import org.limewire.ui.swing.library.LibraryInspectionUtils;
import org.limewire.ui.swing.library.table.AbstractLibraryFormat;
import org.limewire.ui.swing.library.table.AllTableFormat;
import org.limewire.ui.swing.library.table.AudioTableFormat;
import org.limewire.ui.swing.library.table.DocumentTableFormat;
import org.limewire.ui.swing.library.table.ImageTableFormat;
import org.limewire.ui.swing.library.table.OtherTableFormat;
import org.limewire.ui.swing.library.table.ProgramTableFormat;
import org.limewire.ui.swing.library.table.VideoTableFormat;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class LibraryFilterPanel {
    @Resource
    Color backgroundColor;
    @Resource
    Color borderColor;
    @Resource
    Font buttonFont;
    @Resource
    Color fontColor;
    @Resource
    Color fontSelectedColor;
    @Resource
    Color selectionTopGradientColor;
    @Resource
    Color selectionBottomGradientColor;
    @Resource
    Color selectionBorderTopColor;
    @Resource
    Color selectionBorderBottomColor;
    @Resource
    Color highlightBackgroundColor;
    @Resource
    Color highlightBorderColor;
    private final JPanel component;
    private final PromptTextField promptTextField;
    private final FancyTabList categoryList;
    private final List<TabActionMap> categoryActionMaps;
    private final List<LibraryCategoryListener> listeners;
    private Action allAction;

    @Inject
    public LibraryFilterPanel(Provider<AllTableFormat<LocalFileItem>> allFormat, Provider<AudioTableFormat<LocalFileItem>> audioFormat, Provider<VideoTableFormat<LocalFileItem>> videoFormat, Provider<ImageTableFormat<LocalFileItem>> imageFormat, Provider<DocumentTableFormat<LocalFileItem>> documentFormat, Provider<ProgramTableFormat<LocalFileItem>> programFormat, Provider<OtherTableFormat<LocalFileItem>> otherFormat, TextFieldDecorator textFieldDecorator) {
        GuiUtils.assignResources(this);
        this.categoryActionMaps = new ArrayList<TabActionMap>();
        this.addCategory(I18n.tr("All") + " ", null, allFormat);
        this.addCategory(I18n.tr("Audio"), Category.AUDIO, audioFormat);
        this.addCategory(I18n.tr("Videos"), Category.VIDEO, videoFormat);
        this.addCategory(I18n.tr("Images"), Category.IMAGE, imageFormat);
        this.addCategory(I18n.tr("Documents"), Category.DOCUMENT, documentFormat);
        this.addCategory(I18n.tr("Programs"), Category.PROGRAM, programFormat);
        this.addCategory(I18n.tr("Other"), Category.OTHER, otherFormat);
        this.component = new JPanel(new MigLayout("insets 0 5 0 5, gap 0, fill", "", "[28!]"));
        this.promptTextField = new PromptTextField(I18n.tr("Filter"));
        this.categoryList = new FancyTabList(this.categoryActionMaps);
        this.categoryList.setSelectionPainter(new CategoryTabPainter(this.selectionTopGradientColor, this.selectionBottomGradientColor, this.selectionBorderTopColor, this.selectionBorderBottomColor));
        this.categoryList.setHighlightPainter(new CategoryTabPainter(this.highlightBackgroundColor, this.highlightBackgroundColor, this.highlightBorderColor, this.highlightBorderColor));
        this.listeners = new CopyOnWriteArrayList<LibraryCategoryListener>();
        this.init(textFieldDecorator);
        this.component.setVisible(SwingUiSettings.SHOW_LIBRARY_FILTERS.getValue());
    }

    private void init(TextFieldDecorator textFieldDecorator) {
        this.component.setBackground(this.backgroundColor);
        this.component.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.borderColor));
        TextFieldClipboardControl.install(this.promptTextField);
        textFieldDecorator.decorateClearablePromptField(this.promptTextField, BorderPainter.AccentType.NONE);
        this.categoryList.setTabTextColor(this.fontColor);
        this.categoryList.setTextFont(this.buttonFont);
        this.categoryList.setTabTextSelectedColor(this.fontSelectedColor);
        this.categoryList.setUnderlineEnabled(false);
        this.component.add((Component)this.categoryList, "growy");
        this.component.add((Component)this.promptTextField, "alignx right");
        TextFilterUsageTracker usageTracker = new TextFilterUsageTracker();
        this.promptTextField.addFocusListener(usageTracker);
        this.promptTextField.addKeyListener(usageTracker);
    }

    public JComponent getComponent() {
        return this.component;
    }

    void addSearchTabListener(LibraryCategoryListener listener) {
        this.listeners.add(listener);
    }

    public AbstractLibraryFormat<LocalFileItem> getSelectedTableFormat() {
        return ((LibraryCategoryAction)this.categoryList.getSelectedTab().getTabActionMap().getMainAction()).getTableFormat();
    }

    public void clearFilters() {
        this.promptTextField.setText("");
        this.allAction.putValue("SwingSelectedKey", true);
        this.allAction.actionPerformed(null);
    }

    public JTextField getFilterField() {
        return this.promptTextField;
    }

    public void setSelectedCategory(Category category, String filterText) {
        if (category == null) {
            this.allAction.putValue("SwingSelectedKey", true);
        } else {
            for (TabActionMap action : this.categoryActionMaps) {
                LibraryCategoryAction categoryAction;
                if (!(action.getMainAction() instanceof LibraryCategoryAction) || (categoryAction = (LibraryCategoryAction)action.getMainAction()).getCategory() != category) continue;
                categoryAction.putValue("SwingSelectedKey", true);
                break;
            }
        }
        this.promptTextField.setText(filterText == null ? "" : filterText);
    }

    public Category getSelectedCategory() {
        return ((LibraryCategoryAction)this.categoryList.getSelectedTab().getTabActionMap().getMainAction()).getCategory();
    }

    private void addCategory(String title, Category category, Provider<? extends AbstractLibraryFormat<LocalFileItem>> tableFormat) {
        LibraryCategoryAction action = new LibraryCategoryAction(title, category, tableFormat);
        if (category == null) {
            action.putValue("SwingSelectedKey", true);
            this.allAction = action;
        }
        TabActionMap map = this.newTabActionMap(action);
        this.categoryActionMaps.add(map);
    }

    private TabActionMap newTabActionMap(LibraryCategoryAction action) {
        NoOpAction moreText = new NoOpAction();
        moreText.putValue("Name", "");
        return new TabActionMap(action, null, moreText, null);
    }

    private static class TextFilterUsageTracker
    extends KeyAdapter
    implements KeyListener,
    FocusListener {
        private boolean canCountUsageIfKeyIsPressed;

        private TextFilterUsageTracker() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.canCountUsageIfKeyIsPressed) {
                this.canCountUsageIfKeyIsPressed = false;
                LibraryInspectionUtils.textFilterUsed();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.canCountUsageIfKeyIsPressed = true;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.canCountUsageIfKeyIsPressed = false;
        }
    }

    private static class CategoryTabPainter
    extends RectanglePainter<FancyTab> {
        public CategoryTabPainter(Color topGradient, Color bottomGradient, Color topBorder, Color bottomBorder) {
            this.setFillPaint(new GradientPaint(0.0f, 0.0f, topGradient, 0.0f, 1.0f, bottomGradient));
            this.setBorderPaint(new GradientPaint(0.0f, 0.0f, topBorder, 0.0f, 1.0f, bottomBorder));
            this.setRoundHeight(10);
            this.setRoundWidth(10);
            this.setRounded(true);
            this.setPaintStretched(true);
            this.setInsets(new Insets(2, 0, 1, 0));
            this.setAntialiasing(true);
            this.setCacheable(true);
        }
    }

    static interface LibraryCategoryListener {
        public void categorySelected(Category var1);
    }

    private class LibraryCategoryAction
    extends AbstractAction {
        private final Category category;
        private final Provider<? extends AbstractLibraryFormat<LocalFileItem>> tableFormat;

        public LibraryCategoryAction(String name, Category category, Provider<? extends AbstractLibraryFormat<LocalFileItem>> tableFormat) {
            super(name);
            this.category = category;
            this.tableFormat = tableFormat;
        }

        Category getCategory() {
            return this.category;
        }

        public AbstractLibraryFormat<LocalFileItem> getTableFormat() {
            return this.tableFormat.get();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryInspectionUtils.categoryFilterUsed();
            for (LibraryCategoryListener listener : LibraryFilterPanel.this.listeners) {
                listener.categorySelected(this.category);
            }
        }
    }
}

