/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.login;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.settings.FriendSettings;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendConnectionFactory;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.PromptPasswordField;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.TextFieldDecorator;
import org.limewire.ui.swing.friends.login.LoginPopupPanel;
import org.limewire.ui.swing.friends.settings.FriendAccountConfiguration;
import org.limewire.ui.swing.friends.settings.FriendAccountConfigurationManager;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;

public class XMPPUserEntryLoginPanel
extends JPanel
implements Disposable {
    private static final String CUSTOM_SERVICE_NAME = "Jabber";
    private static final String GMAIL_SERVICE_NAME = "gmail.com";
    @Resource
    private Font headerTextFont;
    @Resource
    private Color headerTextForeground;
    @Resource
    private Font descriptionTextFont;
    @Resource
    private Color descriptionTextForeground;
    @Resource
    private Font inputTextFont;
    @Resource
    private Color inputTextForeground;
    @Resource
    private Font goBackTextFont;
    @Resource(key="XMPPUserEntryLoginPanel.authFailedLabel.foreground")
    private Color warningForeground;
    @Resource(key="XMPPUserEntryLoginPanel.authFailedLabel.font")
    private Font warningFont;
    @Resource(key="XMPPUserEntryLoginPanel.authFailedLabel.icon")
    private Icon warningIcon;
    @Resource(key="XMPPUserEntryLoginPanel.signInButton.foreground")
    private Color signInButtonForeground;
    @Resource(key="XMPPUserEntryLoginPanel.signInButton.font")
    private Font signInButtonFont;
    @Resource(key="XMPPUserEntryLoginPanel.autoLoginCheckBox.icon")
    private Icon autoLoginCheckBoxIcon;
    @Resource(key="XMPPUserEntryLoginPanel.autoLoginCheckBox.selectedIcon")
    private Icon autoLoginCheckBoxSelectedIcon;
    @Resource(key="XMPPUserEntryLoginPanel.autoLoginCheckBox.font")
    private Font autoLoginCheckBoxFont;
    private static final String SIGNIN_ENABLED_TEXT = I18n.tr("Sign In");
    private static final String SIGNIN_DISABLED_TEXT = I18n.tr("Signing in...");
    private static final String AUTHENTICATION_ERROR = I18n.tr("Incorrect username or password.");
    private static final String NETWORK_ERROR = I18n.tr("Network error.");
    private PromptTextField serviceField;
    private PromptTextField usernameField;
    private PromptPasswordField passwordField;
    private JCheckBox autoLoginCheckBox;
    private JLabel authFailedLabel;
    private JXButton signInButton;
    private final SignInAction signinAction = new SignInAction();
    private ListenerSupport<FriendConnectionEvent> connectionSupport = null;
    private final FriendAccountConfiguration accountConfig;
    private final LoginPopupPanel parent;
    private final FriendAccountConfigurationManager accountManager;
    private EventListener<FriendConnectionEvent> connectionListener;
    private JLabel serviceLabel;
    private JComponent serviceRecenter;
    private boolean connectionHasBeenInitiated = false;
    private final FriendConnectionFactory friendConnectionFactory;

    @Inject
    public XMPPUserEntryLoginPanel(@Assisted FriendAccountConfiguration accountConfig, LoginPopupPanel parent, FriendAccountConfigurationManager accountManager, ButtonDecorator buttonDecorator, TextFieldDecorator textFieldDecorator, BarPainterFactory barPainterFactory, FriendConnectionFactory friendConnectionFactory) {
        super(new BorderLayout());
        this.accountConfig = accountConfig;
        this.parent = parent;
        this.accountManager = accountManager;
        this.friendConnectionFactory = friendConnectionFactory;
        GuiUtils.assignResources(this);
        JXPanel headerPanel = new JXPanel(new MigLayout("gap 10, insets 15 20 15 20"));
        headerPanel.setBackgroundPainter(barPainterFactory.createPopUpBarPainter());
        JLabel headerLabel = new JLabel(I18n.tr("Sign in with {0}", accountConfig.getLabel()));
        JLabel headerIcon = new JLabel(accountConfig.getLargeIcon());
        headerLabel.setFont(this.headerTextFont);
        headerLabel.setForeground(this.headerTextForeground);
        headerPanel.add(headerIcon);
        headerPanel.add(headerLabel);
        this.add((Component)headerPanel, "North");
        this.initComponents(buttonDecorator, textFieldDecorator);
        this.initServiceField();
        this.setSignInComponentsEnabled(true);
    }

    @Inject
    void registerListener(ListenerSupport<FriendConnectionEvent> connectionSupport) {
        this.connectionSupport = connectionSupport;
        this.connectionListener = new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                switch ((FriendConnectionEvent.Type)((Object)event.getType())) {
                    case CONNECTING: {
                        XMPPUserEntryLoginPanel.this.connecting();
                        break;
                    }
                    case CONNECTED: {
                        XMPPUserEntryLoginPanel.this.connected();
                        break;
                    }
                    case CONNECT_FAILED: {
                        Exception reason;
                        if (!XMPPUserEntryLoginPanel.this.connectionHasBeenInitiated || (reason = event.getException()) == null) break;
                        XMPPUserEntryLoginPanel.this.disconnected(reason);
                    }
                }
            }
        };
        connectionSupport.addListener(this.connectionListener);
    }

    private void initComponents(ButtonDecorator buttonDecorator, TextFieldDecorator textFieldDecorator) {
        this.serviceRecenter = new JPanel();
        ResizeUtils.forceSize(this.serviceRecenter, new Dimension(30, 30));
        this.serviceLabel = new JLabel(I18n.tr("Domain"));
        this.serviceLabel.setFont(this.descriptionTextFont);
        this.serviceLabel.setForeground(this.descriptionTextForeground);
        JLabel usernameLabel = new JLabel(GMAIL_SERVICE_NAME.equals(this.accountConfig.getNetworkName()) ? I18n.tr("Email") : I18n.tr("Username"));
        usernameLabel.setFont(this.descriptionTextFont);
        usernameLabel.setForeground(this.descriptionTextForeground);
        JLabel passwordLabel = new JLabel(I18n.tr("Password"));
        passwordLabel.setFont(this.descriptionTextFont);
        passwordLabel.setForeground(this.descriptionTextForeground);
        this.serviceField = new PromptTextField();
        textFieldDecorator.decoratePromptField(this.serviceField, BorderPainter.AccentType.NONE);
        this.serviceField.setFont(this.inputTextFont);
        this.serviceField.setForeground(this.inputTextForeground);
        this.usernameField = new PromptTextField();
        textFieldDecorator.decoratePromptField(this.usernameField, BorderPainter.AccentType.NONE);
        this.usernameField.setFont(this.inputTextFont);
        this.usernameField.setForeground(this.inputTextForeground);
        this.passwordField = new PromptPasswordField();
        textFieldDecorator.decoratePromptField(this.passwordField, BorderPainter.AccentType.NONE);
        this.passwordField.setFont(this.inputTextFont);
        this.passwordField.setForeground(this.inputTextForeground);
        this.passwordField.setAction(this.signinAction);
        ResizeUtils.forceSize(this.serviceField, new Dimension(224, 26));
        ResizeUtils.forceSize(this.usernameField, new Dimension(224, 26));
        ResizeUtils.forceSize(this.passwordField, new Dimension(224, 26));
        this.autoLoginCheckBox = new JCheckBox(I18n.tr("Sign in when I start LimeWire"), true);
        this.autoLoginCheckBox.setFont(this.autoLoginCheckBoxFont);
        this.autoLoginCheckBox.setIcon(this.autoLoginCheckBoxIcon);
        this.autoLoginCheckBox.setSelectedIcon(this.autoLoginCheckBoxSelectedIcon);
        this.autoLoginCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!XMPPUserEntryLoginPanel.this.autoLoginCheckBox.isSelected()) {
                    XMPPUserEntryLoginPanel.this.accountManager.setAutoLoginConfig(null);
                }
                SwingUiSettings.REMEMBER_ME_CHECKED.setValue(XMPPUserEntryLoginPanel.this.autoLoginCheckBox.isSelected());
            }
        });
        this.autoLoginCheckBox.setOpaque(false);
        this.autoLoginCheckBox.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    XMPPUserEntryLoginPanel.this.login();
                }
            }
        });
        this.signInButton = new JXButton(this.signinAction);
        buttonDecorator.decorateGreenFullButton(this.signInButton);
        this.signInButton.setFont(this.signInButtonFont);
        this.signInButton.setForeground(this.signInButtonForeground);
        this.signInButton.setBorder(BorderFactory.createEmptyBorder(0, 15, 2, 15));
        ResizeUtils.looseForceHeight(this.signInButton, 32);
        this.authFailedLabel = new JLabel();
        this.authFailedLabel.setVisible(false);
        this.authFailedLabel.setForeground(this.warningForeground);
        this.authFailedLabel.setFont(this.warningFont);
        this.authFailedLabel.setIcon(this.warningIcon);
        HyperlinkButton goBackButton = new HyperlinkButton(new AbstractAction(I18n.tr("Choose another account")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMPPUserEntryLoginPanel.this.parent.restart();
            }
        });
        goBackButton.setFont(this.goBackTextFont);
        JPanel contentPanel = new JPanel(new MigLayout("gap 0, insets 10, align center"));
        contentPanel.add((Component)this.authFailedLabel, "dock north, gapleft 2, hidemode 3, gapbottom 3, wrap");
        contentPanel.add((Component)this.serviceLabel, "hidemode 3, wrap");
        contentPanel.add((Component)this.serviceField, "gapbottom 10, hidemode 3, grow, wrap");
        contentPanel.add((Component)usernameLabel, "wrap");
        contentPanel.add((Component)this.usernameField, "gapbottom 10, grow, wrap");
        contentPanel.add((Component)passwordLabel, "wrap");
        contentPanel.add((Component)this.passwordField, "gapbottom 6, grow, wrap");
        contentPanel.add((Component)this.autoLoginCheckBox, "gapbottom 10, wmin 0, wrap");
        contentPanel.add((Component)this.signInButton, "wrap");
        contentPanel.add((Component)this.serviceRecenter, "hidemode 3, wrap");
        JPanel bottomPanel = new JPanel(new MigLayout("insets 0, gap 0, align center"));
        bottomPanel.add((Component)goBackButton, "gapbottom 10");
        this.add((Component)contentPanel, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private void setSignInComponentsEnabled(boolean isEnabled) {
        this.signinAction.setEnabled(isEnabled);
        this.signinAction.putValue("Name", isEnabled ? SIGNIN_ENABLED_TEXT : SIGNIN_DISABLED_TEXT);
        this.serviceField.setEnabled(isEnabled);
        this.usernameField.setEnabled(isEnabled);
        this.passwordField.setEnabled(isEnabled);
        this.autoLoginCheckBox.setEnabled(isEnabled);
    }

    private void initServiceField() {
        if (this.accountConfig.getLabel().equals(CUSTOM_SERVICE_NAME)) {
            this.serviceLabel.setVisible(true);
            this.serviceField.setVisible(true);
            this.serviceRecenter.setVisible(false);
        } else {
            this.serviceLabel.setVisible(false);
            this.serviceField.setVisible(false);
            this.serviceRecenter.setVisible(true);
        }
    }

    private void login() {
        FriendSettings.EVER_TRIED_TO_SIGN_IN.setValue(true);
        String user = this.usernameField.getText().trim();
        String password = new String(this.passwordField.getPassword());
        if (user.equals("") || password.equals("")) {
            return;
        }
        if (this.accountConfig.getLabel().equals(CUSTOM_SERVICE_NAME)) {
            String service = this.serviceField.getText().trim();
            if (service.equals("")) {
                return;
            }
            this.accountConfig.setServiceName(service);
        }
        this.accountConfig.setUsername(user);
        this.accountConfig.setPassword(password);
        if (this.autoLoginCheckBox.isSelected()) {
            this.accountManager.setAutoLoginConfig(this.accountConfig);
        } else {
            this.accountManager.setAutoLoginConfig(null);
        }
        this.authFailedLabel.setVisible(false);
        this.validate();
        this.repaint();
        this.friendConnectionFactory.login(this.accountConfig);
    }

    void connected() {
        FriendSettings.EVER_SIGNED_IN.setValue(true);
        this.parent.finished();
    }

    void disconnected(Exception reason) {
        this.setSignInComponentsEnabled(true);
        if (reason != null && reason.getMessage() != null && reason.getMessage().toLowerCase(Locale.US).contains("auth")) {
            this.authFailedLabel.setText(AUTHENTICATION_ERROR);
            this.passwordField.setText("");
        } else {
            this.authFailedLabel.setText(NETWORK_ERROR);
        }
        this.authFailedLabel.setVisible(true);
    }

    public void connecting() {
        this.connectionHasBeenInitiated = true;
        this.setSignInComponentsEnabled(false);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.serviceField.isVisible()) {
            return this.serviceField.requestFocusInWindow();
        }
        return this.usernameField.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        this.connectionSupport.removeListener(this.connectionListener);
    }

    class SignInAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XMPPUserEntryLoginPanel.this.login();
        }
    }
}

