/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table.renderer;

import com.google.inject.Inject;
import javax.swing.Icon;
import org.jdesktop.application.Resource;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.malware.AntivirusUpdateType;
import org.limewire.ui.swing.transfer.TransferTitleRenderer;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.PropertiableFileUtils;

public class DownloadTitleRenderer
extends TransferTitleRenderer {
    @Resource
    private Icon antivirusIcon;
    @Resource
    private Icon warningIcon;
    @Resource
    private Icon downloadingIcon;
    private CategoryIconManager categoryIconManager;

    @Inject
    public DownloadTitleRenderer(CategoryIconManager categoryIconManager) {
        this.categoryIconManager = categoryIconManager;
        GuiUtils.assignResources(this);
    }

    @Override
    protected Icon getIcon(Object value) {
        if (!(value instanceof DownloadItem)) {
            return null;
        }
        DownloadItem item = (DownloadItem)value;
        if (item.getDownloadItemType() == DownloadItem.DownloadItemType.ANTIVIRUS) {
            return this.antivirusIcon;
        }
        switch (item.getState()) {
            case ERROR: 
            case DANGEROUS: 
            case THREAT_FOUND: 
            case SCAN_FAILED: {
                return this.warningIcon;
            }
            case FINISHING: 
            case DONE: {
                return this.categoryIconManager.getIcon(item.getCategory());
            }
            case SCANNING: 
            case SCANNING_FRAGMENT: {
                return this.antivirusIcon;
            }
        }
        return this.downloadingIcon;
    }

    @Override
    protected String getText(Object value) {
        if (!(value instanceof DownloadItem)) {
            return "";
        }
        DownloadItem item = (DownloadItem)value;
        switch (item.getDownloadItemType()) {
            case ANTIVIRUS: {
                return this.getAntivirusText(item);
            }
            case BITTORRENT: {
                return I18n.tr("{0} (torrent)", PropertiableFileUtils.getNameProperty(item, true));
            }
        }
        return PropertiableFileUtils.getNameProperty(item, true);
    }

    private String getAntivirusText(DownloadItem item) {
        AntivirusUpdateType type = (AntivirusUpdateType)((Object)item.getDownloadProperty(DownloadPropertyKey.ANTIVIRUS_UPDATE_TYPE));
        switch (type) {
            case CHECKING: {
                return I18n.tr("Checking for AVG Anti-Virus updates");
            }
            case FULL: {
                return I18n.tr("Updating AVG Anti-Virus");
            }
            case INCREMENTAL: {
                Integer index = (Integer)item.getDownloadProperty(DownloadPropertyKey.ANTIVIRUS_INCREMENT_INDEX);
                Integer count = (Integer)item.getDownloadProperty(DownloadPropertyKey.ANTIVIRUS_INCREMENT_COUNT);
                return I18n.tr("Updating AVG Anti-Virus definitions - {0} of {1}", index, count);
            }
        }
        return I18n.tr("Updating AVG Anti-Virus definitions");
    }
}

