/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table.renderer;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.downloads.table.DownloadActionHandler;
import org.limewire.ui.swing.table.TableRendererEditor;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class DownloadCancelRendererEditor
extends TableRendererEditor {
    private final JButton cancelButton;
    private final JButton removeButton;
    private DownloadItem item;
    @Resource
    private Icon cancelIcon;
    @Resource
    private Icon cancelIconPressed;
    @Resource
    private Icon cancelIconRollover;

    @Inject
    public DownloadCancelRendererEditor() {
        this.setLayout(new MigLayout("insets 0, gap 0, nogrid, novisualpadding, alignx center, aligny center"));
        GuiUtils.assignResources(this);
        this.cancelButton = new IconButton(this.cancelIcon, this.cancelIconRollover, this.cancelIconPressed);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setToolTipText(I18n.tr("Cancel download"));
        this.removeButton = new IconButton(this.cancelIcon, this.cancelIconRollover, this.cancelIconPressed);
        this.removeButton.setActionCommand("remove");
        this.removeButton.setToolTipText(I18n.tr("Remove download"));
        this.add((Component)this.cancelButton, "hidemode 3");
        this.add((Component)this.removeButton, "hidemode 3");
    }

    @Inject
    public void setActionHandler(final DownloadActionHandler actionHandler) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof IconButton) {
                    ((IconButton)e.getSource()).resetDefaultCursor();
                }
                actionHandler.performAction(e.getActionCommand(), DownloadCancelRendererEditor.this.item);
                DownloadCancelRendererEditor.this.cancelCellEditing();
            }
        };
        this.cancelButton.addActionListener(listener);
        this.removeButton.addActionListener(listener);
    }

    private void updateButtons(DownloadItem item) {
        if (item.getDownloadItemType() != DownloadItem.DownloadItemType.ANTIVIRUS) {
            DownloadState state = item.getState();
            this.cancelButton.setVisible(!state.isFinished());
            this.removeButton.setVisible(state.isFinished());
        } else {
            this.cancelButton.setVisible(false);
            this.removeButton.setVisible(false);
        }
    }

    @Override
    protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof DownloadItem) {
            this.item = (DownloadItem)value;
            this.updateButtons(this.item);
            return this;
        }
        return this.emptyPanel;
    }

    @Override
    protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DownloadItem) {
            this.updateButtons((DownloadItem)value);
            return this;
        }
        return this.emptyPanel;
    }
}

