/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table.renderer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JTable;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.ui.swing.downloads.table.DownloadActionHandler;
import org.limewire.ui.swing.downloads.table.renderer.DownloadButtonPanel;
import org.limewire.ui.swing.table.TableRendererEditor;

public class DownloadButtonRendererEditor
extends TableRendererEditor {
    private DownloadButtonPanel buttonPanel = new DownloadButtonPanel();
    private DownloadItem item;

    @Inject
    public DownloadButtonRendererEditor() {
        this.setLayout(new BorderLayout());
        this.add(this.buttonPanel);
    }

    @Inject
    public void setActionHandler(final DownloadActionHandler actionHandler) {
        this.buttonPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                actionHandler.performAction(e.getActionCommand(), DownloadButtonRendererEditor.this.item);
                DownloadButtonRendererEditor.this.cancelCellEditing();
            }
        });
    }

    @Override
    protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof DownloadItem) {
            this.item = (DownloadItem)value;
            this.buttonPanel.updateButtons(this.item);
            return this;
        }
        return this.emptyPanel;
    }

    @Override
    protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DownloadItem) {
            this.buttonPanel.updateButtons((DownloadItem)value);
            return this;
        }
        return this.emptyPanel;
    }

    @Override
    public final boolean shouldSelectCell(EventObject e) {
        return true;
    }
}

